/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.networkselector.impl;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.Comparator;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorMatcherResult;
import com.vmware.vsphere.client.modules.api.networkselector.NetworkSelectorPortgroupData;
import com.vmware.vsphere.client.networkselector.NetworkSelectorUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NetworkSelectorMatcherService {
    private static final String ANY_NETWORK_TYPE = "AnyNetwork";
    private static final String NETWORK_NAME_PROPERTY = "name";
    private static final String DVS_DV_PORT_GROUP_COUNT_PROPERTY = "portgroup._length";
    private static final String ALL_NETWORKS_COUNT_PROPERTY = "allNetwork._length";
    private static final int NETWORK_COUNT_LIMIT = 50;
    private static final Log _logger = LogFactory.getLog(NetworkSelectorMatcherService.class);
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _queryBuilder;

    public NetworkSelectorMatcherService(QueryExecutor queryExecutor, QuerySpecBuilder queryBuilder) {
        this._queryExecutor = queryExecutor;
        this._queryBuilder = queryBuilder;
    }

    public NetworkSelectorMatcherResult getMatchingNetworks(ManagedObjectReference networkProvider, NetworkSelectorPortgroupData[] sourceData) {
        ManagedObjectReference singleNetwork;
        if (networkProvider == null || sourceData == null || sourceData.length == 0) {
            return new NetworkSelectorMatcherResult();
        }
        ManagedObjectReference[] matchingNetworks = this.fetchMatchingNetworks(networkProvider, sourceData);
        NetworkSelectorMatcherResult result = new NetworkSelectorMatcherResult(matchingNetworks, false);
        if ((matchingNetworks.length == 0 || matchingNetworks.length == 1) && (singleNetwork = this.fetchIfOnlyOneNetwork(networkProvider)) != null) {
            result = new NetworkSelectorMatcherResult(new ManagedObjectReference[]{singleNetwork}, true);
        }
        return result;
    }

    private ManagedObjectReference[] fetchMatchingNetworks(ManagedObjectReference networkProvider, NetworkSelectorPortgroupData[] sourceData) {
        Constraint matchingConstraint = this.buildMatchingNetworksConstraint(sourceData);
        Constraint allNetworks = this.buildAllNetworksConstraint(networkProvider);
        QuerySpec matchingQuery = this._queryBuilder.buildQuerySpec((Constraint)QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{matchingConstraint, allNetworks}, (Conjoiner)Conjoiner.AND), new String[0]);
        long start = _logger.isDebugEnabled() ? System.currentTimeMillis() : -1L;
        ResultSet matchingNetworkSet = null;
        try {
            matchingNetworkSet = this._queryExecutor.getData(matchingQuery);
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve matching networks", (Throwable)e);
        }
        ManagedObjectReference[] networks = null;
        if (matchingNetworkSet != null && matchingNetworkSet.items != null) {
            networks = new ManagedObjectReference[matchingNetworkSet.items.length];
            for (int index = 0; index < networks.length; ++index) {
                networks[index] = (ManagedObjectReference)matchingNetworkSet.items[index].resourceObject;
            }
        } else {
            networks = new ManagedObjectReference[]{};
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug((Object)String.format("Matched %d networks in %d ms", networks.length, System.currentTimeMillis() - start));
        }
        return networks;
    }

    private ManagedObjectReference fetchIfOnlyOneNetwork(ManagedObjectReference networkProvider) {
        String networkCountProperty = ALL_NETWORKS_COUNT_PROPERTY;
        if (ManagedObjectUtil.isOfType((ManagedObjectReference)networkProvider, DistributedVirtualSwitch.class) || ManagedObjectUtil.isOfType((ManagedObjectReference)networkProvider, VmwareDistributedVirtualSwitch.class)) {
            networkCountProperty = DVS_DV_PORT_GROUP_COUNT_PROPERTY;
        }
        ManagedObjectReference network = null;
        try {
            long start = _logger.isDebugEnabled() ? System.currentTimeMillis() : -1L;
            int networkCount = (Integer)this._queryExecutor.getProperty((Object)networkProvider, networkCountProperty);
            if (_logger.isDebugEnabled()) {
                _logger.debug((Object)String.format("Fetched network count=%d for %d ms", networkCount, System.currentTimeMillis() - start));
            }
            if (networkCount <= 50) {
                Constraint allNetworks = this.buildAllNetworksConstraint(networkProvider);
                QuerySpec query = this._queryBuilder.buildQuerySpec(allNetworks, new String[0]);
                query.resultSpec = new ResultSpec();
                query.resultSpec.maxResultCount = 2;
                start = _logger.isDebugEnabled() ? System.currentTimeMillis() : -1L;
                ResultSet rs = this._queryExecutor.getData(query);
                ManagedObjectReference managedObjectReference = network = rs.items.length == 1 ? (ManagedObjectReference)rs.items[0].resourceObject : null;
                if (_logger.isDebugEnabled()) {
                    _logger.debug((Object)String.format("Fetched network for %d ms", System.currentTimeMillis() - start));
                }
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve networks information", (Throwable)e);
        }
        return network;
    }

    private Constraint buildMatchingNetworksConstraint(NetworkSelectorPortgroupData[] sourceData) {
        Constraint[] nameConstraints = new Constraint[sourceData.length];
        for (int index = 0; index < nameConstraints.length; ++index) {
            String networkName = sourceData[index].name;
            nameConstraints[index] = QueryUtil.createPropertyConstraint((String)ANY_NETWORK_TYPE, (String)NETWORK_NAME_PROPERTY, (Comparator)Comparator.EQUALS, (Object)networkName);
        }
        CompositeConstraint filterConstraint = QueryUtil.createCompositeConstraint((Constraint[])nameConstraints, (Conjoiner)Conjoiner.OR);
        return filterConstraint;
    }

    private Constraint buildAllNetworksConstraint(ManagedObjectReference networkProvider) {
        CompositeConstraint result = QueryUtil.createCompositeConstraint((Constraint[])new Constraint[]{NetworkSelectorUtil.createConstraintForStandardNetworks(networkProvider), NetworkSelectorUtil.createConstraintForOpaqueNetworks(networkProvider), NetworkSelectorUtil.createConstraintForDistributedPortGroups(networkProvider, false)}, (Conjoiner)Conjoiner.OR);
        return result;
    }
}

