/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.ceip.impl;

import com.vmware.ph.phservice.ceip.CeipApi;
import com.vmware.ph.phservice.ceip.CeipApiProvider;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vcenter.apigw.api.sso.tokenmgmt.SamlTokenEx;
import com.vmware.vim.sso.client.SamlToken;
import com.vmware.vise.vim.commons.sso.AuthSessionUtil;
import com.vmware.vsphere.client.ceip.CeipService;
import java.security.PrivateKey;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CeipServiceImpl
implements CeipService {
    private static final long FORCE_REFRESH_TIMEOUT_NANOS = TimeUnit.MINUTES.toNanos(1L);
    private static final Logger logger = LoggerFactory.getLogger(CeipServiceImpl.class);
    private final CeipApiProvider _ceipApiProvider;
    private final Object _lastSynchronizedTimeLock;
    private long _lastSynchronizedTime = 0L;

    public CeipServiceImpl(CeipApiProvider ceipApiProvider) {
        this._ceipApiProvider = ceipApiProvider;
        this._lastSynchronizedTimeLock = new Object();
    }

    @Override
    public boolean isUserCeipAuthorized() {
        logger.debug("getCeipAuthorizationStatus: started");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                boolean bl = this.isCurrentUserAuthorizedToChangeCeip();
                return bl;
            }
            catch (RuntimeException e) {
                logger.error("Error occurred in isUserCeipAuthorized.", (Throwable)e);
                throw e;
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    @Override
    public boolean isCollectionEnabled() {
        logger.debug("isCollectionEnabled: started");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        CeipApi ceipApi = this._ceipApiProvider.getCeipApi();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.syncCeipApi(ceipApi);
            Boolean status = ceipApi.isConsentAccepted();
            boolean bl = status == null ? false : status;
            return bl;
        }
        catch (RuntimeException e) {
            logger.error("Error occurred in isCollectionEnabled.", (Throwable)e);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            this._ceipApiProvider.releaseCeipApi(ceipApi);
        }
    }

    @Override
    public void setCollectionEnabled(boolean enabled) {
        logger.debug("setCollectionEnabled was executed.");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        CeipApi ceipApi = this._ceipApiProvider.getCeipApi();
        try {
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            ceipApi.setConsentAccepted(enabled);
        }
        catch (RuntimeException e) {
            logger.error("Error occurred in setCollectionEnabled.", (Throwable)e);
            throw e;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            this._ceipApiProvider.releaseCeipApi(ceipApi);
        }
    }

    @Override
    public boolean isActive() {
        CeipApi ceipApi = this._ceipApiProvider.getCeipApi();
        boolean isActive = ceipApi != null;
        logger.debug("The active state for {} is '{}'.", (Object)CeipServiceImpl.class.getSimpleName(), (Object)isActive);
        return isActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isCurrentUserAuthorizedToChangeCeip() {
        CeipApi ceipApi = this._ceipApiProvider.getCeipApi();
        try {
            boolean isUserAuthorizedToChangeCeip;
            SamlTokenEx samlTokenEx = AuthSessionUtil.getSsoTokenEx((SsoDomain)SsoDomainHelper.getLocal());
            SamlToken samlToken = samlTokenEx.getToken();
            PrivateKey privateKey = samlTokenEx.getPrivateKey().orElse(null);
            boolean bl = isUserAuthorizedToChangeCeip = ceipApi.isConsentChangeAllowed(samlToken, privateKey);
            return bl;
        }
        finally {
            this._ceipApiProvider.releaseCeipApi(ceipApi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncCeipApi(CeipApi ceipApi) {
        Object object = this._lastSynchronizedTimeLock;
        synchronized (object) {
            long currentTime = System.nanoTime();
            if (currentTime - this._lastSynchronizedTime <= FORCE_REFRESH_TIMEOUT_NANOS) {
                logger.debug("No need to force CEIP synchronization.");
                return;
            }
            try {
                logger.debug("Start the ceipAPI sync operation");
                ceipApi.sync();
                this._lastSynchronizedTime = System.nanoTime();
                logger.debug("The ceipAPI sync operation completed successfully.");
            }
            catch (Exception e) {
                logger.warn("There is an error while performing CEIP synchronization before showing CEIP UI. As a result, the current CEIP status, showed in the NGC UI, may not be up to date with CEIP  status updates executed recently in other management nodes in a MxN deployment scenario. No action is needed - the periodic synchronization feature will synchronize CEIP status in time. For more details see the underlying error message: " + e.getMessage() + " If this error persists, please file an SR to the PhoneHome team regarding the CEIP feature.", (Throwable)e);
            }
        }
    }
}

