/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.vmware.vim.binding.vim.dvs.DistributedVirtualPort;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.OpaqueSwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.DataObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostPnicData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostPnicHostData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvPortgroupModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostUplinkData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostPnicModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.util.DvsHostNicModelComparator;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DvsAddHostPnicParser {
    public static DvsAddManageHostPnicHostData[] parseHostPnics(Collection<DvsHostPnicModel> hostPnicDataObjects, DistributedVirtualSwitchManager.PhysicalNicsList[] compatibleHostPnics, DistributedVirtualPort[] uplinkPorts, DvsAddHostUplinkData dvsAddHostUplinkData, boolean areMemberHosts, boolean isNetworkOffloadSupported) {
        if (hostPnicDataObjects == null) {
            return null;
        }
        DvsHostPnicModel[] dvsHostPnicModels = hostPnicDataObjects.toArray(new DvsHostPnicModel[hostPnicDataObjects.size()]);
        Map<String, String> uplinkPortgroupKeyToName = DvsAddHostPnicParser.createUplinkPortgroupKeyToNameMap(dvsAddHostUplinkData);
        Map<String, DistributedVirtualPort> uplinkPortsMap = DvsAddHostPnicParser.createUplinkPortsMap(uplinkPorts);
        String dvsUuid = dvsAddHostUplinkData != null ? dvsAddHostUplinkData.uuid : null;
        DvsAddHostPnicParser.sortHostsAndPnics(dvsHostPnicModels);
        ArrayList<DvsAddManageHostPnicHostData> result = new ArrayList<DvsAddManageHostPnicHostData>();
        Map<String, Map<String, String>> compatibleHostPnicsMap = isNetworkOffloadSupported ? DvsAddHostPnicParser.formatCompatibleHostPnics(compatibleHostPnics) : new HashMap<String, Map<String, String>>();
        for (DvsHostPnicModel hostPnicModel : dvsHostPnicModels) {
            DvsAddManageHostPnicHostData hostItem = DvsAddHostPnicParser.createHostItem(hostPnicModel, areMemberHosts);
            if (hostItem == null) continue;
            if (!ArrayUtils.isEmpty((Object[])hostPnicModel.pnics)) {
                String hostId = ManagedObjectUtil.morefToString((ManagedObjectReference)((ManagedObjectReference)hostPnicModel.provider));
                Map<String, DataObject> pnicToSwitchMap = DvsAddHostPnicParser.createPnicToVswitchMap(hostPnicModel.proxySwitches, hostPnicModel.vswitches);
                ArrayList<DvsAddManageHostPnicData> pnicsList = new ArrayList<DvsAddManageHostPnicData>();
                for (PhysicalNic pnic : hostPnicModel.pnics) {
                    boolean isPnicNetworkOffloadCompatible = isNetworkOffloadSupported && compatibleHostPnicsMap.containsKey(hostId) && compatibleHostPnicsMap.get(hostId).containsKey(pnic.device);
                    DvsAddManageHostPnicData pnicItem = DvsAddHostPnicParser.createPnicItem(pnic, hostPnicModel.opaqueSwitches, pnicToSwitchMap, (ManagedObjectReference)hostPnicModel.provider, dvsUuid, uplinkPortgroupKeyToName, uplinkPortsMap, isPnicNetworkOffloadCompatible);
                    if (pnicItem == null) continue;
                    pnicsList.add(pnicItem);
                }
                hostItem.setPnics(pnicsList.toArray(new DvsAddManageHostPnicData[pnicsList.size()]));
            }
            result.add(hostItem);
        }
        return result.toArray(new DvsAddManageHostPnicHostData[result.size()]);
    }

    private static Map<String, Map<String, String>> formatCompatibleHostPnics(DistributedVirtualSwitchManager.PhysicalNicsList[] compatibleHostPnics) {
        HashMap<String, Map<String, String>> compatibleHostPnicsMap = new HashMap<String, Map<String, String>>();
        for (DistributedVirtualSwitchManager.PhysicalNicsList hostPnic : compatibleHostPnics) {
            HashMap<String, String> compatiblePnicsMap = new HashMap<String, String>();
            compatibleHostPnicsMap.put(ManagedObjectUtil.morefToString((ManagedObjectReference)hostPnic.host), compatiblePnicsMap);
            for (PhysicalNic physicalNic : hostPnic.physicalNics) {
                compatiblePnicsMap.put(physicalNic.device, physicalNic.dpuId);
            }
        }
        return compatibleHostPnicsMap;
    }

    private static void sortHostsAndPnics(DvsHostPnicModel[] hostPnicModels) {
        Arrays.sort(hostPnicModels, new DvsHostNicModelComparator());
        for (DvsHostPnicModel hostPnicModel : hostPnicModels) {
            if (hostPnicModel == null) continue;
            DvsAddHostPnicParser.sortPnics(hostPnicModel.pnics);
        }
    }

    private static void sortPnics(PhysicalNic[] pnics) {
        if (ArrayUtils.isEmpty((Object[])pnics)) {
            return;
        }
        Arrays.sort(pnics, new Comparator<PhysicalNic>(){

            @Override
            public int compare(PhysicalNic pnic1, PhysicalNic pnic2) {
                if (pnic1 == null) {
                    return -1;
                }
                if (pnic2 == null) {
                    return 1;
                }
                String pnic1Device = pnic1.device;
                String pnic2Device = pnic2.device;
                return NetworkUtil.compareNicDevices(pnic1Device, pnic2Device, "vmnic");
            }
        });
    }

    private static DvsAddManageHostPnicData createPnicItem(PhysicalNic pnic, OpaqueSwitch[] opaqueSwitches, Map<String, DataObject> pnicToVSwitchMap, ManagedObjectReference hostRef, String dvsUuid, Map<String, String> uplinkPortgroupKeyToName, Map<String, DistributedVirtualPort> uplinkPortsMap, boolean isNetworkOffloadCompatible) {
        if (pnic == null || NetworkUtil.isPnicAttachedToOvs(pnic, opaqueSwitches) || StringUtils.isEmpty((CharSequence)pnic.device) || StringUtils.isEmpty((CharSequence)pnic.key)) {
            return null;
        }
        DataObject vSwitch = pnicToVSwitchMap.get(pnic.key);
        String inUseBySwitch = NetworkStringUtil.getString("na");
        boolean isAssigned = false;
        boolean isStandardSwitch = false;
        String uplinkPortgroupName = NetworkStringUtil.getString("na");
        String uplinkPortgroupKey = null;
        String uplink = NetworkStringUtil.getString("na");
        if (vSwitch instanceof HostProxySwitch) {
            HostMember.PnicSpec pnicSpec;
            HostProxySwitch hpSwitch = (HostProxySwitch)vSwitch;
            inUseBySwitch = hpSwitch.dvsName;
            if (StringUtils.isNotEmpty((CharSequence)dvsUuid) && dvsUuid.equals(hpSwitch.dvsUuid) && (pnicSpec = DvsAddHostPnicParser.getPnicSpec(hpSwitch, pnic)) != null) {
                DistributedVirtualPort port;
                uplinkPortgroupKey = pnicSpec.uplinkPortgroupKey;
                String pgName = uplinkPortgroupKeyToName.get(uplinkPortgroupKey);
                if (StringUtils.isNotEmpty((CharSequence)pgName)) {
                    uplinkPortgroupName = pgName;
                }
                if ((port = uplinkPortsMap.get(pnicSpec.uplinkPortKey)) != null && port.config != null && StringUtils.isNotEmpty((CharSequence)port.config.name)) {
                    uplink = port.config.name;
                    isAssigned = true;
                }
            }
        } else if (vSwitch instanceof VirtualSwitch) {
            VirtualSwitch virtualSwitch = (VirtualSwitch)vSwitch;
            inUseBySwitch = virtualSwitch.name;
            isStandardSwitch = true;
        }
        DvPortgroupModel dvPortgroupModel = new DvPortgroupModel();
        dvPortgroupModel.name = uplinkPortgroupName;
        dvPortgroupModel.key = uplinkPortgroupKey;
        return new DvsAddManageHostPnicData(pnic.device, inUseBySwitch, uplink, dvPortgroupModel, isAssigned, isStandardSwitch, hostRef, isNetworkOffloadCompatible);
    }

    private static HostMember.PnicSpec getPnicSpec(HostProxySwitch hostProxySwitch, PhysicalNic physicalNic) {
        HostProxySwitch.Specification hostProxySwitchSpec = hostProxySwitch.spec;
        if (hostProxySwitchSpec != null && hostProxySwitchSpec.backing instanceof HostMember.PnicBacking) {
            HostMember.PnicBacking pnicBacking = (HostMember.PnicBacking)hostProxySwitchSpec.backing;
            if (!ArrayUtils.isEmpty((Object[])pnicBacking.pnicSpec)) {
                for (HostMember.PnicSpec pnicSpec : pnicBacking.pnicSpec) {
                    if (pnicSpec == null || pnicSpec.pnicDevice == null || !pnicSpec.pnicDevice.equals(physicalNic.device)) continue;
                    return pnicSpec;
                }
            }
        }
        return null;
    }

    private static DvsAddManageHostPnicHostData createHostItem(DvsHostPnicModel hostPnicModel, boolean isMemberHost) {
        if (hostPnicModel == null || hostPnicModel.provider == null || !(hostPnicModel.provider instanceof ManagedObjectReference) || StringUtils.isEmpty((CharSequence)hostPnicModel.name)) {
            return null;
        }
        DvsAddManageHostPnicHostData hostItem = new DvsAddManageHostPnicHostData((ManagedObjectReference)hostPnicModel.provider, hostPnicModel.name, isMemberHost);
        return hostItem;
    }

    private static Map<String, String> createUplinkPortgroupKeyToNameMap(DvsAddHostUplinkData dvsAddHostUplinkData) {
        HashMap<String, String> keyToNameMap = new HashMap<String, String>();
        if (dvsAddHostUplinkData != null && !ArrayUtils.isEmpty((Object[])dvsAddHostUplinkData.uplinkPortgroups)) {
            for (DvPortgroupModel dvPortgroupModel : dvsAddHostUplinkData.uplinkPortgroups) {
                if (dvPortgroupModel == null || !StringUtils.isNotEmpty((CharSequence)dvPortgroupModel.key)) continue;
                keyToNameMap.put(dvPortgroupModel.key, dvPortgroupModel.name);
            }
        }
        return keyToNameMap;
    }

    private static Map<String, DistributedVirtualPort> createUplinkPortsMap(DistributedVirtualPort[] uplinkPorts) {
        HashMap<String, DistributedVirtualPort> result = new HashMap<String, DistributedVirtualPort>();
        if (!ArrayUtils.isEmpty((Object[])uplinkPorts)) {
            for (DistributedVirtualPort port : uplinkPorts) {
                if (port == null || !StringUtils.isNotEmpty((CharSequence)port.key)) continue;
                result.put(port.key, port);
            }
        }
        return result;
    }

    private static Map<String, DataObject> createPnicToVswitchMap(HostProxySwitch[] proxySwitches, VirtualSwitch[] virtualSwitches) {
        HashMap<String, DataObject> result = new HashMap<String, DataObject>();
        if (proxySwitches != null) {
            for (HostProxySwitch hostProxySwitch : proxySwitches) {
                if (hostProxySwitch == null || hostProxySwitch.pnic == null) continue;
                for (String pnicKey : hostProxySwitch.pnic) {
                    if (!StringUtils.isNotEmpty((CharSequence)pnicKey)) continue;
                    result.put(pnicKey, (DataObject)hostProxySwitch);
                }
            }
        }
        if (virtualSwitches != null) {
            for (HostProxySwitch hostProxySwitch : virtualSwitches) {
                if (hostProxySwitch == null || hostProxySwitch.pnic == null) continue;
                for (String pnicKey : hostProxySwitch.pnic) {
                    if (!StringUtils.isNotEmpty((CharSequence)pnicKey)) continue;
                    result.put(pnicKey, (DataObject)hostProxySwitch);
                }
            }
        }
        return result;
    }
}

