/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.dvs.addhost.DvsAddHostVmParser;
import com.vmware.vsphere.client.h5.network.dvs.addhost.data.DvsAddManageHostMigrateVmData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsAddHostHostVmsModel;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.DvsHostsSpec;
import com.vmware.vsphere.client.h5.network.dvs.addhost.model.VmVnicSettingsData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.queries.VmVnicSettingsQueryModel;
import java.util.Arrays;
import java.util.Collection;

public class DvsAddHostVmPropertyProvider
implements PropertyProviderBean {
    private final QueryBindingService _queryBindingService;

    public DvsAddHostVmPropertyProvider(QueryBindingService queryBindingService) {
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsAddHost", property="hostVmData")
    public DvsAddManageHostMigrateVmData getHostVmData(ManagedObjectReference dvsRef, DvsHostsSpec dvshostsSpec) {
        Collection hostVmsModels = this._queryBindingService.prepare(DvsAddHostHostVmsModel.class).fetch(Arrays.asList(dvshostsSpec.hosts));
        return DvsAddHostVmParser.parseHostVms(hostVmsModels);
    }

    @ModelMetadata(type={"VirtualMachine"}, propertyNamespace="dvsAddHost", property="vmVnicSettingsData")
    public Collection<VmVnicSettingsData> getVmVnicSettingsData(ManagedObjectReference vmRef, final Integer nicKey) {
        VmVnicSettingsQueryModel queryModel = (VmVnicSettingsQueryModel)this._queryBindingService.prepare(VmVnicSettingsQueryModel.class).fetch((Object)vmRef);
        Collection<Object> result = DvsAddHostVmParser.parseVmVnicsSettings(queryModel);
        if (nicKey != null) {
            result = Collections2.filter(result, (Predicate)new Predicate<VmVnicSettingsData>(){

                public boolean apply(VmVnicSettingsData vmVnic) {
                    return vmVnic.key == nicKey;
                }
            });
        }
        return result;
    }
}

