/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost.spec;

import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vim.host.PhysicalNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.HostNetworkModel;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

class HostData {
    private Map<String, Object> _pnicToSwitchMap;
    private ManagedObjectReference _networkSystemRef;
    private HostProxySwitch[] _hostProxySwitches;

    public HostData(HostNetworkModel hostNetworkModel) {
        if (hostNetworkModel == null) {
            throw new IllegalArgumentException("hostNetworkModel cannot be null!");
        }
        this._networkSystemRef = hostNetworkModel.networkSystem;
        this._hostProxySwitches = hostNetworkModel.proxySwitch;
        this._pnicToSwitchMap = this.createPnicToSwitchMap(hostNetworkModel);
    }

    public Object getSwitchByPnicDevice(String pnicDevice) {
        return this._pnicToSwitchMap.get(pnicDevice);
    }

    public ManagedObjectReference getNetworkSystem() {
        return this._networkSystemRef;
    }

    public HostProxySwitch[] getProxySwitches() {
        return this._hostProxySwitches;
    }

    private Map<String, Object> createPnicToSwitchMap(HostNetworkModel hostNetworkModel) {
        String pnicDevice;
        HashMap<String, Object> pnicToSwitchMap = new HashMap<String, Object>();
        Map<String, PhysicalNic> pnicDeviceMap = this.createPnicDeviceMap(hostNetworkModel.pnic);
        if (hostNetworkModel.vswitch != null) {
            for (VirtualSwitch virtualSwitch : hostNetworkModel.vswitch) {
                if (virtualSwitch == null || virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    pnicDevice = this.findPnicDeviceByKey(pnicKey, pnicDeviceMap.keySet());
                    this.addPnic(pnicDevice, pnicToSwitchMap, pnicDeviceMap, virtualSwitch);
                }
            }
        }
        if (hostNetworkModel.proxySwitch != null) {
            for (VirtualSwitch virtualSwitch : hostNetworkModel.proxySwitch) {
                if (virtualSwitch.pnic == null) continue;
                for (String pnicKey : virtualSwitch.pnic) {
                    pnicDevice = this.findPnicDeviceByKey(pnicKey, pnicDeviceMap.keySet());
                    this.addPnic(pnicDevice, pnicToSwitchMap, pnicDeviceMap, virtualSwitch);
                }
            }
        }
        return pnicToSwitchMap;
    }

    private void addPnic(String pnicDevice, Map<String, Object> pnicToSwitchMap, Map<String, PhysicalNic> pnicDeviceMap, Object virtualSwitch) {
        PhysicalNic pnic;
        if (pnicDevice != null && (pnic = pnicDeviceMap.get(pnicDevice)) != null && StringUtils.isNotEmpty((CharSequence)pnic.device)) {
            pnicToSwitchMap.put(pnic.device, virtualSwitch);
        }
    }

    private String findPnicDeviceByKey(String pnicKey, Set<String> pnicDevices) {
        if (pnicKey == null || pnicDevices == null || pnicDevices.isEmpty()) {
            return null;
        }
        for (String pnicDevice : pnicDevices) {
            if (!StringUtils.endsWith((CharSequence)pnicKey, (CharSequence)pnicDevice)) continue;
            return pnicDevice;
        }
        return null;
    }

    private Map<String, PhysicalNic> createPnicDeviceMap(PhysicalNic[] physicalNics) {
        HashMap<String, PhysicalNic> pnicDeviceMap = new HashMap<String, PhysicalNic>();
        if (physicalNics != null) {
            for (PhysicalNic physicalNic : physicalNics) {
                if (physicalNic == null || !StringUtils.isNotEmpty((CharSequence)physicalNic.device)) continue;
                pnicDeviceMap.put(physicalNic.device, physicalNic);
            }
        }
        return pnicDeviceMap;
    }
}

