/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.addhost.spec;

import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.HostData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.PnicUpdateData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.VSwitchUpdateData;
import com.vmware.vsphere.client.h5.network.dvs.addhost.spec.VnicUpdateData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

class HostUpdateData {
    private ManagedObjectReference _hostRef;
    private Map<String, PnicUpdateData> _pnicsToAdd = new HashMap<String, PnicUpdateData>();
    private List<String> _pnicsToRemove = new ArrayList<String>();
    private Map<String, PnicUpdateData> _pnicsToUpdate = new HashMap<String, PnicUpdateData>();
    private Map<Object, VSwitchUpdateData> _vswitchesToUpdate = new HashMap<Object, VSwitchUpdateData>();
    private List<VnicUpdateData> _vnicsToReassign = new ArrayList<VnicUpdateData>();

    public VSwitchUpdateData[] getVswitchesToUpdate() {
        return this._vswitchesToUpdate.values().toArray(new VSwitchUpdateData[this._vswitchesToUpdate.values().size()]);
    }

    public Map<String, PnicUpdateData> getPnicsToAddMap() {
        return this._pnicsToAdd;
    }

    public Map<String, PnicUpdateData> getPnicsToUpdate() {
        return this._pnicsToUpdate;
    }

    public List<VnicUpdateData> getVnicsToMigrate() {
        return this._vnicsToReassign;
    }

    public ManagedObjectReference getHostRef() {
        return this._hostRef;
    }

    public HostUpdateData(ManagedObjectReference hostRef) {
        if (hostRef == null) {
            throw new IllegalArgumentException("hostRef cannot be null");
        }
        this._hostRef = hostRef;
    }

    public void migrateVnic(String device, String dvPortgroupKey, String standardPortgroup) {
        if (StringUtils.isEmpty((CharSequence)device)) {
            throw new IllegalArgumentException("device cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)dvPortgroupKey)) {
            throw new IllegalArgumentException("dvPortgroupKey cannot be null or empty");
        }
        VnicUpdateData vnicUpdateData = new VnicUpdateData();
        vnicUpdateData.device = device;
        vnicUpdateData.dvPortgroupKey = dvPortgroupKey;
        vnicUpdateData.standardPortgroup = standardPortgroup;
        this._vnicsToReassign.add(vnicUpdateData);
    }

    public void addPnic(String device, String uplinkPortgroupKey, String uplink) {
        if (StringUtils.isEmpty((CharSequence)device)) {
            throw new IllegalArgumentException("device cannot be null or empty");
        }
        if (StringUtils.isEmpty((CharSequence)uplinkPortgroupKey)) {
            throw new IllegalArgumentException("uplinkPortgroupKey cannot be null or empty");
        }
        this._pnicsToAdd.put(device, new PnicUpdateData(uplinkPortgroupKey, uplink));
    }

    public void removePnic(String device) {
        this._pnicsToRemove.add(device);
    }

    public void updatePnic(String device, String uplinkPortgroupKey, String dvUplink) {
        PnicUpdateData pnicUpdateData = new PnicUpdateData(uplinkPortgroupKey, dvUplink);
        this._pnicsToUpdate.put(device, pnicUpdateData);
    }

    public void buildVSwitchAndPnicMaps(HostData hostData, String dvsUuid) {
        this._vswitchesToUpdate = new HashMap<Object, VSwitchUpdateData>();
        for (String pnicDevice : this._pnicsToAdd.keySet()) {
            Object virtualSwitch = hostData.getSwitchByPnicDevice(pnicDevice);
            boolean pnicBelongsToDvs = false;
            if (virtualSwitch instanceof HostProxySwitch && StringUtils.isNotEmpty((CharSequence)dvsUuid)) {
                HostProxySwitch proxySwitch = (HostProxySwitch)virtualSwitch;
                if (proxySwitch.dvsUuid != null && proxySwitch.dvsUuid.equals(dvsUuid)) {
                    pnicBelongsToDvs = true;
                }
            }
            if (virtualSwitch == null || pnicBelongsToDvs) continue;
            VSwitchUpdateData vSwitchUpdateData = this._vswitchesToUpdate.get(virtualSwitch);
            if (vSwitchUpdateData == null) {
                vSwitchUpdateData = new VSwitchUpdateData(virtualSwitch);
                this._vswitchesToUpdate.put(virtualSwitch, vSwitchUpdateData);
            }
            vSwitchUpdateData.removePnic(pnicDevice);
        }
    }

    public void buildManageHostNetworkConfigUpdateData(String dvsUuid, HostData hostData) {
        this._vswitchesToUpdate = new HashMap<Object, VSwitchUpdateData>();
        if (this._pnicsToAdd.size() == 0 && this._pnicsToUpdate.size() == 0 && this._pnicsToRemove.isEmpty()) {
            return;
        }
        HostProxySwitch proxySwitch = this.findHostProxySwitch(dvsUuid, hostData);
        if (proxySwitch == null) {
            return;
        }
        VSwitchUpdateData proxySwitchUpdateData = this.getProxySwitchUpdateData(proxySwitch);
        this.addHostPnicsToDvs(hostData, proxySwitchUpdateData);
        if (proxySwitchUpdateData != null) {
            for (String string : this._pnicsToRemove) {
                proxySwitchUpdateData.removePnic(string);
            }
            for (Map.Entry entry : this._pnicsToUpdate.entrySet()) {
                proxySwitchUpdateData.updatePnic((String)entry.getKey(), (PnicUpdateData)entry.getValue());
            }
        }
    }

    private HostProxySwitch findHostProxySwitch(String dvsUuid, HostData hostData) {
        HostProxySwitch result = null;
        if (dvsUuid != null && hostData != null && !ArrayUtils.isEmpty((Object[])hostData.getProxySwitches())) {
            for (HostProxySwitch hostProxySwitch : hostData.getProxySwitches()) {
                if (hostProxySwitch == null || !dvsUuid.equals(hostProxySwitch.dvsUuid)) continue;
                result = hostProxySwitch;
                break;
            }
        }
        return result;
    }

    private VSwitchUpdateData getProxySwitchUpdateData(HostProxySwitch proxySwitch) {
        VSwitchUpdateData proxySwitchUpdateData = this._vswitchesToUpdate.get(proxySwitch);
        if (proxySwitchUpdateData == null) {
            proxySwitchUpdateData = new VSwitchUpdateData(proxySwitch);
            this._vswitchesToUpdate.put(proxySwitch, proxySwitchUpdateData);
        }
        return proxySwitchUpdateData;
    }

    private void addHostPnicsToDvs(HostData hostData, VSwitchUpdateData proxySwitchUpdateData) {
        for (Map.Entry<String, PnicUpdateData> pnicEntry : this._pnicsToAdd.entrySet()) {
            String pnicDevice = pnicEntry.getKey();
            Object vSwitch = hostData.getSwitchByPnicDevice(pnicDevice);
            if (vSwitch != null) {
                VSwitchUpdateData vSwitchUpdateData = this._vswitchesToUpdate.get(vSwitch);
                if (vSwitchUpdateData == null) {
                    vSwitchUpdateData = new VSwitchUpdateData(vSwitch);
                    this._vswitchesToUpdate.put(vSwitch, vSwitchUpdateData);
                }
                vSwitchUpdateData.removePnic(pnicDevice);
            }
            if (proxySwitchUpdateData == null) continue;
            proxySwitchUpdateData.addPnic(pnicDevice, pnicEntry.getValue());
        }
    }
}

