/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.editsettings;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.network.backend.DistributedVirtualSwitchManagerFactory;
import com.vmware.vsphere.client.h5.network.dvs.editsettings.model.DvsSettingsData;
import com.vmware.vsphere.client.h5.network.dvs.editsettings.model.DvsSettingsQueryBinding;
import java.util.List;

public class DvsEditSettingsDialogPropertyProvider
implements PropertyProviderBean {
    private static final int DEFAULT_MAX_NUM_UPLINKS = 32;
    private static final int DEFAULT_MTU = 1500;
    private static final int DEFAULT_MIN_MTU = 1280;
    private static final int DEFAULT_MAX_MTU = 9000;
    private static final String OPERATION_SUPPORTED_PROPERTY = "capability.dvsOperationSupported";
    private static final String MODIFY_PRIVILEGE = "DVSwitch.Modify";
    private static final String RES_MGMT_PRIVILEGE = "DVSwitch.ResourceManagement";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private final DistributedVirtualSwitchManagerFactory _dvsManagerFactory;

    public DvsEditSettingsDialogPropertyProvider(QueryBindingService queryBindingService, QueryService queryService, DistributedVirtualSwitchManagerFactory dvsManagerFactory) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
        this._dvsManagerFactory = dvsManagerFactory;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsedit", property="settingsdata")
    public DvsSettingsData getSettingsData(ManagedObjectReference dvsMor) {
        DvsSettingsQueryBinding dvsSettingsData = (DvsSettingsQueryBinding)((Object)this._queryBindingService.prepare(DvsSettingsQueryBinding.class).fetch((Object)dvsMor));
        DvsSettingsData dataModel = new DvsSettingsData();
        if (dvsSettingsData != null) {
            dataModel.name = dvsSettingsData.name;
            dataModel.configVersion = dvsSettingsData.configVersion;
            dataModel.uplinkPortNames = dvsSettingsData.uplinkPortNames;
            if (dvsSettingsData.niocCapability != null && dvsSettingsData.niocCapability.networkResourceManagementSupported) {
                dataModel.isNiocSupported = true;
                dataModel.isNiocEnabled = dvsSettingsData.isNiocEnabled;
            }
            dataModel.mtu = dvsSettingsData.maxMtu != 0 ? dvsSettingsData.maxMtu : 1500;
            dataModel.minMtuSupported = dvsSettingsData.mtuCapability != null ? dvsSettingsData.mtuCapability.minMtuSupported : 1280;
            dataModel.maxMtuSupported = dvsSettingsData.mtuCapability != null ? dvsSettingsData.mtuCapability.maxMtuSupported : 9000;
            int n = dataModel.maxNumUplinks = dvsSettingsData.uplinkPortNames != null ? dvsSettingsData.availableUplinkCount + dvsSettingsData.uplinkPortNames.length : 32;
            if (dvsSettingsData.description != null) {
                dataModel.description = dvsSettingsData.description;
            }
            dataModel.multicastSnoopingSupported = dvsSettingsData.multicastSnoopingSupported;
            dataModel.multicastFilteringMode = dvsSettingsData.multicastFilteringMode;
            dataModel.lldpSupported = dvsSettingsData.lldpSupported;
            if (dvsSettingsData.linkDiscoveryProtocolConfig != null) {
                dataModel.ldpOperation = dvsSettingsData.linkDiscoveryProtocolConfig.operation;
                dataModel.ldpProtocol = dvsSettingsData.linkDiscoveryProtocolConfig.protocol;
            }
            if (dvsSettingsData.contact != null) {
                dataModel.contactName = dvsSettingsData.contact.name;
                dataModel.contactDetails = dvsSettingsData.contact.contact;
            }
            dataModel.networkOffloadSpecId = dvsSettingsData.networkOffloadSpecId;
            dataModel.hostsCount = dvsSettingsData.hostsCount != null ? dvsSettingsData.hostsCount : 0;
            boolean bl = dataModel.dpuCapability = dvsSettingsData.dpuCapability != null && dvsSettingsData.dpuCapability.networkOffloadSupported != false;
            if (dataModel.dpuCapability) {
                DistributedVirtualSwitchManager manager = this._dvsManagerFactory.getDistributedVirtualSwitchManager(dvsMor.getServerGuid());
                dataModel.networkOffloadSpecs = manager.querySupportedNetworkOffloadSpec(dvsSettingsData.currentSwitchSpec);
            }
        }
        return dataModel;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsedit", property="actionAvailable")
    public Boolean getDvsEditSettingsActionAvailable(ManagedObjectReference dvsMor) throws Exception {
        List propertyValues;
        ResultSet resultSet = this._queryService.select(new String[]{OPERATION_SUPPORTED_PROPERTY, "grantedPrivileges"}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        boolean operationSupported = false;
        boolean hasPrivileges = false;
        if (resultSet != null && resultSet.getItems() != null && !resultSet.getItems().isEmpty() && (propertyValues = ((ResourceItem)resultSet.getItems().get(0)).getPropertyValues()) != null && propertyValues.size() == 2) {
            operationSupported = (Boolean)propertyValues.get(0);
            String[] allPrivileges = (String[])propertyValues.get(1);
            hasPrivileges = allPrivileges != null && (AuthorizationUtil.isPrivilegeGranted((String[])new String[]{MODIFY_PRIVILEGE}, (String[])allPrivileges) || AuthorizationUtil.isPrivilegeGranted((String[])new String[]{RES_MGMT_PRIVILEGE}, (String[])allPrivileges));
        }
        return operationSupported && hasPrivileges;
    }
}

