/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.export;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualPortgroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.dvs.api.spec.DvsExportSpec;
import com.vmware.vsphere.client.h5.network.dvs.export.model.ExportDvsSpec;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DvsExportPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(DvsExportPropertyProvider.class);
    private static final String EXPORT_CONFIGURATION = "exportConfiguration";
    private static final String PARENT_DVS_PROPERTY = "config.distributedVirtualSwitch";
    private static final String BACKING_TYPE_PROPERTY = "config.backingType";
    private static final String DVS_RELATION = "dvs";
    private final QueryService _queryService;

    public DvsExportPropertyProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvs", property="hasNsxPortgroups")
    public boolean getHasNsxPortgroups(ManagedObjectReference targetObjectRef) {
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey"}).from(new String[]{DistributedVirtualPortgroup.class.getSimpleName()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(DVS_RELATION, PropertyPredicate.ComparisonOperator.EQUAL, (Object)targetObjectRef), new PropertyPredicate(BACKING_TYPE_PROPERTY, PropertyPredicate.ComparisonOperator.EQUAL, (Object)DistributedVirtualPortgroup.BackingType.nsx.toString())}).fetch();
        if (!resultSet.getItems().isEmpty()) {
            return !((ResourceItem)resultSet.getItems().get(0)).getPropertyValues().isEmpty();
        }
        return false;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch", "DistributedVirtualPortgroup"}, propertyNamespace="dvs", property="exportDvsConfiguration")
    public byte[] getExportDvsConfiguration(ManagedObjectReference targetObjectRef, ExportDvsSpec exportDvsSpec) {
        ManagedObjectReference targetRef;
        Validate.notNull((Object)exportDvsSpec, (String)"The validated object is null", (Object[])new Object[0]);
        exportDvsSpec.description = exportDvsSpec.description.replace("\n", "\r");
        DvsExportSpec dvsExportSpec = new DvsExportSpec();
        dvsExportSpec.description = exportDvsSpec.description;
        if (DistributedVirtualPortgroup.class.getSimpleName().equals(targetObjectRef.getType())) {
            ManagedObjectReference parentDvsMor;
            dvsExportSpec.portgroupConstraint = QueryUtil.createObjectIdentityConstraint((Object)targetObjectRef);
            targetRef = parentDvsMor = (ManagedObjectReference)QueryServiceUtil.queryProperty((QueryService)this._queryService, (ManagedObjectReference)targetObjectRef, (String)PARENT_DVS_PROPERTY);
        } else {
            if (exportDvsSpec.includePortGroups) {
                dvsExportSpec.portgroupConstraint = QueryUtil.createRelationalConstraint((String)"portgroup", (Constraint)QueryUtil.createObjectIdentityConstraint((Object)targetObjectRef), (Boolean)true, (String)DistributedVirtualPortgroup.class.getSimpleName());
            }
            targetRef = targetObjectRef;
        }
        ResultSet result = this._queryService.select(new String[]{EXPORT_CONFIGURATION}).from(new String[]{targetRef.getType()}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("exportConfiguration/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsExportSpec), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)targetRef)}).fetch();
        if (result.getItems().isEmpty()) {
            return null;
        }
        ResourceItem resultItem = (ResourceItem)result.getItems().get(0);
        if (resultItem != null && resultItem.getPropertyValues() != null && !resultItem.getPropertyValues().isEmpty()) {
            return (byte[])resultItem.getPropertyValues().get(0);
        }
        return null;
    }
}

