/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.healthcheck;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.KeyValue;
import com.vmware.vim.binding.vim.dvs.HostMember;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vim.host.HostProxySwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.DvsHealthCheckDetailsCollections;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.DvsHealthCheckDetailsDataParser;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckData;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckDetailsData;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckDetailsItemData;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckDetailsQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckHostMembersRuntimeQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckItemData;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.DvsHealthCheckQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.healthcheck.model.HealthCheckHostMembersQueryBinding;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;

public class DvsHealthCheckPropertyProvider
implements PropertyProviderBean {
    private static final String ICON_GREEN = "vsphere-icon-status-ok";
    private static final String ICON_YELLOW = "vsphere-icon-status-warning";
    private static final String ICON_GRAY = "vsphere-icon-status-unknown";
    private QueryBindingService _queryBindingService;
    private QueryService _queryService;

    public DvsHealthCheckPropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsHealthCheckMonitor", property="dvsHealthCheckData")
    public DvsHealthCheckData getDvsHealthCheckData(ManagedObjectReference dvsMor) throws Exception {
        DvsHealthCheckQueryBinding healthCheckQueryBinding = (DvsHealthCheckQueryBinding)this._queryBindingService.prepare(DvsHealthCheckQueryBinding.class).fetch((Object)dvsMor);
        DvsHealthCheckData healthCheckData = new DvsHealthCheckData();
        this.setHealthCheckMonitoringData(healthCheckQueryBinding, healthCheckData);
        this.setHealthCheckConfigStatus(healthCheckData, healthCheckQueryBinding);
        return healthCheckData;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsHealthCheckMonitor", property="dvsHealthCheckDetailsData")
    public DvsHealthCheckDetailsData getDvsHealthCheckDetailsData(ManagedObjectReference dvsMor) throws Exception {
        DvsHealthCheckDetailsQueryBinding healthCheckQueryBinding = (DvsHealthCheckDetailsQueryBinding)this._queryBindingService.prepare(DvsHealthCheckDetailsQueryBinding.class).fetch((Object)dvsMor);
        DvsHealthCheckDetailsData healthVlanCheckData = new DvsHealthCheckDetailsData();
        if (healthCheckQueryBinding != null && ArrayUtils.isNotEmpty((Object[])healthCheckQueryBinding.runtimeInfos) && ArrayUtils.isNotEmpty((Object[])healthCheckQueryBinding.dvsHostMembers)) {
            HashMap<String, Map<String, String>> hostNamePortPnicMap = new HashMap<String, Map<String, String>>();
            HashMap<String, Map<String, String>> hostNameKeyPortMap = new HashMap<String, Map<String, String>>();
            this.fillMaps(healthCheckQueryBinding.dvsHostMembers, healthCheckQueryBinding.uuid, hostNamePortPnicMap, hostNameKeyPortMap);
            DvsHealthCheckDetailsDataParser parser = new DvsHealthCheckDetailsDataParser();
            DvsHealthCheckDetailsCollections dvsHealthCheckDetailsCollections = new DvsHealthCheckDetailsCollections();
            dvsHealthCheckDetailsCollections.setHostNamePortKeyPnicMap(hostNamePortPnicMap);
            dvsHealthCheckDetailsCollections.setHostNamePortKeyUplinkMap(hostNameKeyPortMap);
            dvsHealthCheckDetailsCollections.setDvsHealthCheckDetailsItemDataList(new ArrayList<DvsHealthCheckDetailsItemData>());
            for (HostMember.RuntimeInfo hostRuntimeInfo : healthCheckQueryBinding.runtimeInfos) {
                if (!ArrayUtils.isNotEmpty((Object[])hostRuntimeInfo.getHealthCheckResult())) continue;
                HostSystem hostSystem = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRuntimeInfo.getHost());
                parser.setHost(hostSystem.getName(), hostRuntimeInfo.getHost());
                for (HostMember.HealthCheckResult healthCheckResult : hostRuntimeInfo.getHealthCheckResult()) {
                    if (healthCheckResult instanceof VmwareDistributedVirtualSwitch.VlanHealthCheckResult) {
                        parser.addVlanHealthCheckDetails((VmwareDistributedVirtualSwitch.VlanHealthCheckResult)healthCheckResult, dvsHealthCheckDetailsCollections);
                    }
                    if (healthCheckResult instanceof VmwareDistributedVirtualSwitch.MtuHealthCheckResult) {
                        parser.addMtuHealthCheckDetails((VmwareDistributedVirtualSwitch.MtuHealthCheckResult)healthCheckResult, dvsHealthCheckDetailsCollections);
                    }
                    if (!(healthCheckResult instanceof VmwareDistributedVirtualSwitch.TeamingHealthCheckResult)) continue;
                    parser.addIpHashHealthCheckDetails((VmwareDistributedVirtualSwitch.TeamingHealthCheckResult)healthCheckResult, dvsHealthCheckDetailsCollections);
                }
            }
            List<DvsHealthCheckDetailsItemData> dvsHealthCheckDetailsItemDataList = dvsHealthCheckDetailsCollections.getDvsHealthCheckDetailsItemDataList();
            Collections.sort(dvsHealthCheckDetailsItemDataList);
            healthVlanCheckData.detailsItemsData = dvsHealthCheckDetailsItemDataList.toArray(new DvsHealthCheckDetailsItemData[dvsHealthCheckDetailsItemDataList.size()]);
        }
        return healthVlanCheckData;
    }

    private void fillMaps(HealthCheckHostMembersQueryBinding[] dvsHostMembers, String dvsUuid, Map<String, Map<String, String>> hostNamePortPnicMap, Map<String, Map<String, String>> hostNameKeyPortMap) {
        for (HealthCheckHostMembersQueryBinding dvsHostMember : dvsHostMembers) {
            if (dvsHostMember.hostProxySwitches == null) continue;
            for (HostProxySwitch hostProxySwitch : dvsHostMember.hostProxySwitches) {
                Object[] pnicSpecs = ((HostMember.PnicBacking)hostProxySwitch.spec.backing).pnicSpec;
                HashMap<String, String> uplinkPortKeyNameMap = new HashMap<String, String>();
                HashMap<String, String> uplinkPortKeyPnicMap = new HashMap<String, String>();
                if (ArrayUtils.isNotEmpty((Object[])pnicSpecs)) {
                    for (Object pnicSpec : pnicSpecs) {
                        uplinkPortKeyPnicMap.put(((HostMember.PnicSpec)pnicSpec).uplinkPortKey, ((HostMember.PnicSpec)pnicSpec).pnicDevice);
                    }
                }
                for (KeyValue keyValuePair : hostProxySwitch.uplinkPort) {
                    uplinkPortKeyNameMap.put(keyValuePair.key, keyValuePair.value);
                }
                if (!hostProxySwitch.dvsUuid.equals(dvsUuid)) continue;
                hostNamePortPnicMap.put(dvsHostMember.hostName, uplinkPortKeyPnicMap);
                hostNameKeyPortMap.put(dvsHostMember.hostName, uplinkPortKeyNameMap);
            }
        }
    }

    private void setHealthCheckMonitoringData(DvsHealthCheckQueryBinding healthCheckQueryBinding, DvsHealthCheckData healthCheckData) throws Exception {
        if (healthCheckQueryBinding != null && ArrayUtils.isNotEmpty((Object[])healthCheckQueryBinding.runtimeInfos) && ArrayUtils.isNotEmpty((Object[])healthCheckQueryBinding.hostsRuntimeData)) {
            HostMember.RuntimeInfo[] runtimeInfos;
            ArrayList<DvsHealthCheckItemData> dvsHealthCheckItemDataList = new ArrayList<DvsHealthCheckItemData>();
            for (HostMember.RuntimeInfo hostRuntimeInfo : runtimeInfos = healthCheckQueryBinding.runtimeInfos) {
                DvsHealthCheckItemData healthCheckItemData = new DvsHealthCheckItemData();
                this.setDvsStatus(hostRuntimeInfo, healthCheckItemData, healthCheckData);
                this.setHostData(hostRuntimeInfo, healthCheckQueryBinding.hostsRuntimeData, healthCheckItemData, healthCheckData);
                if (ArrayUtils.isNotEmpty((Object[])hostRuntimeInfo.getHealthCheckResult())) {
                    HostMember.HealthCheckResult[] healthCheckResults = hostRuntimeInfo.getHealthCheckResult();
                    this.setMtuHealthCheckStatus(healthCheckResults, healthCheckItemData);
                    this.setVlanHealthCheckStatus(healthCheckResults, healthCheckItemData);
                    this.setTeamingAndFailoverHealthCheckStatus(healthCheckResults, healthCheckItemData);
                } else {
                    healthCheckItemData.mtuHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.unknown");
                    healthCheckItemData.mtuHealthStatusIcon = ICON_GRAY;
                    healthCheckItemData.vlanHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.unknown");
                    healthCheckItemData.vlanHealthStatusIcon = ICON_GRAY;
                    healthCheckItemData.teamingAndFailoverHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.unknown");
                    healthCheckItemData.teamingAndFailoverHealthStatusIcon = ICON_GRAY;
                }
                dvsHealthCheckItemDataList.add(healthCheckItemData);
            }
            healthCheckData.dvsHealthCheckItems = dvsHealthCheckItemDataList.toArray(new DvsHealthCheckItemData[dvsHealthCheckItemDataList.size()]);
            this.setWarningsCount(healthCheckData);
            this.setOverallHealthCheckStatus(healthCheckData);
        } else {
            healthCheckData.normalOverallHealthCheckStatus = true;
            healthCheckData.overallHealthCheckStatusIcon = ICON_GREEN;
        }
    }

    private void setDvsStatus(HostMember.RuntimeInfo hostRuntimeInfo, DvsHealthCheckItemData healthCheckItemData, DvsHealthCheckData healthCheckData) {
        Map<String, String> hostProxySwitchStatusMap = this.getHostProxySwitchStatusMap();
        if (HostMember.HostComponentState.up.name().equals(hostRuntimeInfo.status)) {
            healthCheckItemData.dvsStatus = hostProxySwitchStatusMap.get(HostMember.HostComponentState.up.name());
            healthCheckItemData.dvsStatusIcon = ICON_GREEN;
        } else {
            healthCheckItemData.dvsStatus = hostProxySwitchStatusMap.get(hostRuntimeInfo.status);
            if (HostMember.HostComponentState.outOfSync.name().equals(hostRuntimeInfo.status)) {
                ++healthCheckData.outOfSyncHostsCount;
            }
            healthCheckItemData.dvsStatusIcon = ICON_YELLOW;
        }
    }

    private void setHostData(HostMember.RuntimeInfo hostRuntimeInfo, DvsHealthCheckHostMembersRuntimeQueryBinding[] hostsRuntimeData, DvsHealthCheckItemData healthCheckItemData, DvsHealthCheckData healthCheckData) throws Exception {
        DvsHealthCheckHostMembersRuntimeQueryBinding hostRuntimeData = null;
        Map<String, String> hostConnectionStateMap = this.getHostStateMap();
        for (DvsHealthCheckHostMembersRuntimeQueryBinding data : hostsRuntimeData) {
            if (data.provider == null || !data.provider.equals(hostRuntimeInfo.getHost())) continue;
            hostRuntimeData = data;
            break;
        }
        if (hostRuntimeData != null) {
            String connectionState = hostRuntimeData.hostConnectionState.toString();
            healthCheckItemData.hostState = hostRuntimeData.inMaintenanceMode ? NetworkStringUtil.getString("dvs.healthCheck.hostState.maintenance.mode") : hostConnectionStateMap.get(connectionState);
            if (HostSystem.ConnectionState.disconnected.name().equals(connectionState)) {
                ++healthCheckData.disconnectedHostsCount;
            }
            String hostName = hostRuntimeData.name;
            if (!healthCheckItemData.hostState.equals(NetworkStringUtil.getString("HostListItemData.HostState.Connected"))) {
                healthCheckItemData.hostNameFormated = NetworkStringUtil.getString("dvs.healthCheck.hostState.name.format", hostName, healthCheckItemData.hostState);
                healthCheckItemData.hostName = hostName;
            } else {
                healthCheckItemData.hostName = healthCheckItemData.hostNameFormated = hostName;
            }
            healthCheckItemData.hostIcon = hostRuntimeData.primaryIconId;
        }
    }

    private void setMtuHealthCheckStatus(HostMember.HealthCheckResult[] healthCheckResults, DvsHealthCheckItemData healthCheckItemData) {
        healthCheckItemData.mtuHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.normal");
        healthCheckItemData.mtuHealthStatusIcon = ICON_GREEN;
        for (HostMember.HealthCheckResult healthCheckResult : healthCheckResults) {
            if (!(healthCheckResult instanceof VmwareDistributedVirtualSwitch.MtuHealthCheckResult)) continue;
            VmwareDistributedVirtualSwitch.MtuHealthCheckResult mtuHealthCheckResult = (VmwareDistributedVirtualSwitch.MtuHealthCheckResult)healthCheckResult;
            Object[] vlanNotSupportSwitchMtu = mtuHealthCheckResult.vlanNotSupportSwitchMtu;
            Object[] vlanSupportSwitchMtu = mtuHealthCheckResult.vlanSupportSwitchMtu;
            boolean mtuMismatch = mtuHealthCheckResult.mtuMismatch;
            if (mtuMismatch || ArrayUtils.isNotEmpty((Object[])vlanNotSupportSwitchMtu)) {
                healthCheckItemData.mtuHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.warning");
                healthCheckItemData.mtuHealthStatusIcon = ICON_YELLOW;
                break;
            }
            if (ArrayUtils.isNotEmpty((Object[])vlanSupportSwitchMtu)) continue;
            healthCheckItemData.mtuHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.unknown");
            healthCheckItemData.mtuHealthStatusIcon = ICON_GRAY;
        }
    }

    private void setVlanHealthCheckStatus(HostMember.HealthCheckResult[] healthCheckResults, DvsHealthCheckItemData healthCheckItemData) {
        healthCheckItemData.vlanHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.normal");
        healthCheckItemData.vlanHealthStatusIcon = ICON_GREEN;
        for (HostMember.HealthCheckResult healthCheckResult : healthCheckResults) {
            if (!(healthCheckResult instanceof VmwareDistributedVirtualSwitch.VlanHealthCheckResult)) continue;
            VmwareDistributedVirtualSwitch.VlanHealthCheckResult vlanHealthCheckResult = (VmwareDistributedVirtualSwitch.VlanHealthCheckResult)healthCheckResult;
            if (ArrayUtils.isNotEmpty((Object[])vlanHealthCheckResult.untrunkedVlan)) {
                healthCheckItemData.vlanHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.warning");
                healthCheckItemData.vlanHealthStatusIcon = ICON_YELLOW;
                break;
            }
            if (ArrayUtils.isNotEmpty((Object[])vlanHealthCheckResult.trunkedVlan)) continue;
            healthCheckItemData.vlanHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.unknown");
            healthCheckItemData.vlanHealthStatusIcon = ICON_GRAY;
        }
    }

    private void setTeamingAndFailoverHealthCheckStatus(HostMember.HealthCheckResult[] healthCheckResults, DvsHealthCheckItemData healthCheckItemData) {
        for (HostMember.HealthCheckResult healthCheckResult : healthCheckResults) {
            if (!(healthCheckResult instanceof VmwareDistributedVirtualSwitch.TeamingHealthCheckResult)) continue;
            VmwareDistributedVirtualSwitch.TeamingHealthCheckResult teamingHealthCheckResult = (VmwareDistributedVirtualSwitch.TeamingHealthCheckResult)healthCheckResult;
            boolean ipHashMismatch = VmwareDistributedVirtualSwitch.TeamingMatchStatus.iphashMismatch.name().equals(teamingHealthCheckResult.teamingStatus);
            boolean nonIphashMismatch = VmwareDistributedVirtualSwitch.TeamingMatchStatus.nonIphashMismatch.name().equals(teamingHealthCheckResult.teamingStatus);
            if (ipHashMismatch || nonIphashMismatch) {
                healthCheckItemData.teamingAndFailoverHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.warning");
                healthCheckItemData.teamingAndFailoverHealthStatusIcon = ICON_YELLOW;
                break;
            }
            healthCheckItemData.teamingAndFailoverHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.normal");
            healthCheckItemData.teamingAndFailoverHealthStatusIcon = ICON_GREEN;
        }
        if (healthCheckItemData.teamingAndFailoverHealthStatus == null) {
            healthCheckItemData.teamingAndFailoverHealthStatus = NetworkStringUtil.getString("dvs.healthCheck.status.unknown");
            healthCheckItemData.teamingAndFailoverHealthStatusIcon = ICON_GRAY;
        }
    }

    private void setWarningsCount(DvsHealthCheckData healthCheckData) {
        for (DvsHealthCheckItemData itemData : healthCheckData.dvsHealthCheckItems) {
            if (NetworkStringUtil.getString("dvs.healthCheck.status.warning").equals(itemData.vlanHealthStatus)) {
                ++healthCheckData.unsupportedVlansCount;
            }
            if (NetworkStringUtil.getString("dvs.healthCheck.status.warning").equals(itemData.mtuHealthStatus)) {
                ++healthCheckData.mtuMismatchCount;
            }
            if (!NetworkStringUtil.getString("dvs.healthCheck.status.warning").equals(itemData.teamingAndFailoverHealthStatus)) continue;
            ++healthCheckData.ipHashMismatchCount;
        }
    }

    private void setOverallHealthCheckStatus(DvsHealthCheckData healthCheckData) {
        boolean dvsHostConnectivityIssues;
        boolean dvsHealthCheckResultIssues = healthCheckData.mtuMismatchCount > 0 || healthCheckData.unsupportedVlansCount > 0 || healthCheckData.ipHashMismatchCount > 0;
        boolean bl = dvsHostConnectivityIssues = healthCheckData.disconnectedHostsCount > 0 || healthCheckData.outOfSyncHostsCount > 0;
        if (dvsHealthCheckResultIssues || dvsHostConnectivityIssues) {
            healthCheckData.normalOverallHealthCheckStatus = false;
            healthCheckData.overallHealthCheckStatusIcon = ICON_YELLOW;
        } else {
            healthCheckData.normalOverallHealthCheckStatus = true;
            healthCheckData.overallHealthCheckStatusIcon = ICON_GREEN;
        }
        healthCheckData.overallWarningsCount = healthCheckData.mtuMismatchCount + healthCheckData.unsupportedVlansCount + healthCheckData.ipHashMismatchCount + healthCheckData.disconnectedHostsCount + healthCheckData.outOfSyncHostsCount;
    }

    private void setHealthCheckConfigStatus(DvsHealthCheckData healthCheckData, DvsHealthCheckQueryBinding healthCheckQueryBinding) {
        if (ArrayUtils.isNotEmpty((Object[])healthCheckQueryBinding.healthCheckConfigs)) {
            for (DistributedVirtualSwitch.HealthCheckConfig healthCheckConfig : healthCheckQueryBinding.healthCheckConfigs) {
                if (healthCheckConfig instanceof VmwareDistributedVirtualSwitch.VlanMtuHealthCheckConfig) {
                    healthCheckData.vlanAndMtuHealthCheckEnabled = healthCheckConfig.enable;
                }
                if (!(healthCheckConfig instanceof VmwareDistributedVirtualSwitch.TeamingHealthCheckConfig)) continue;
                healthCheckData.teamingAndFailoverHealthCheckEnabled = healthCheckConfig.enable;
            }
        }
    }

    private Map<String, String> getHostStateMap() {
        HashMap<String, String> hostConnectionStateMap = new HashMap<String, String>();
        hostConnectionStateMap.put(HostSystem.ConnectionState.disconnected.name(), NetworkStringUtil.getString("HostListItemData.HostState.Disconnected"));
        hostConnectionStateMap.put(HostSystem.ConnectionState.connected.name(), NetworkStringUtil.getString("HostListItemData.HostState.Connected"));
        hostConnectionStateMap.put(HostSystem.ConnectionState.notResponding.name(), NetworkStringUtil.getString("HostListItemData.HostState.NotResponding"));
        return hostConnectionStateMap;
    }

    private Map<String, String> getHostProxySwitchStatusMap() {
        HashMap<String, String> hostProxySwitchStatusMap = new HashMap<String, String>();
        hostProxySwitchStatusMap.put(HostMember.HostComponentState.up.name(), NetworkStringUtil.getString("HostListItemData.DvsConnectionState.Up"));
        hostProxySwitchStatusMap.put(HostMember.HostComponentState.down.name(), NetworkStringUtil.getString("HostListItemData.DvsConnectionState.Down"));
        hostProxySwitchStatusMap.put(HostMember.HostComponentState.outOfSync.name(), NetworkStringUtil.getString("HostListItemData.DvsConnectionState.OutOfSync"));
        hostProxySwitchStatusMap.put(HostMember.HostComponentState.disconnected.name(), NetworkStringUtil.getString("HostListItemData.DvsConnectionState.Disconnected"));
        hostProxySwitchStatusMap.put(HostMember.HostComponentState.warning.name(), NetworkStringUtil.getString("HostListItemData.DvsConnectionState.Warning"));
        hostProxySwitchStatusMap.put(HostMember.HostComponentState.pending.name(), NetworkStringUtil.getString("HostListItemData.DvsConnectionState.Pending"));
        return hostProxySwitchStatusMap;
    }
}

