/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.portmirroring;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.PortCriteria;
import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.ParameterSpec;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.ResourceSpec;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.dvs.api.spec.DistributedVirtualPortFilterSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.DvsAddSpanSessionWizardPortParser;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.DvsPortMirroringQueryBinding;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.portbrowser.DvsSpanSessionPortBrowserData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.portbrowser.DvsSpanSessionPortBrowserPortData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.portlist.DvsSpanSessionPortListData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.portlist.DvsSpanSessionPortListItemData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.portlist.DvsSpanSessionPortListSpec;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.wizard.DvsAddSpanSessionWizardData;
import com.vmware.vsphere.client.h5.network.dvs.portmirroring.model.wizard.DvsSpanSessionDestinationUplinksData;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import java.util.ArrayList;
import java.util.List;

public class DvsAddSpanSessionWizardPropertyProvider
implements PropertyProviderBean {
    private static final String VSPAN_DVS_UPLINKS = "config/uplinkPortPolicy/uplinkPortName";
    private static final String DVPORT_ENTITY_TYPE = "DVPort";
    private static final String DVPORT_KEY = "key";
    private static final String DVPORT_NAME = "name";
    private static final String DVPORT_CONN_ENTITY = "connectedEntityName";
    private static final String DVPORT_CONNECTEE = "connectee";
    private static final String DVPORT_MAC = "macAddress";
    private static final String DVPORT_PGNAME = "portgroupName";
    private static final String DVPORT_PORTSTATE = "portState";
    private static final String DVPORT_VLAN = "vlanInfo";
    private static final String DVPORT_PROXYHOST = "proxyHostName";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;
    private final QueryExecutor _queryExecutor;

    public DvsAddSpanSessionWizardPropertyProvider(QueryBindingService queryBindingService, QueryService queryService, QueryExecutor queryExecutor) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
        this._queryExecutor = queryExecutor;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="addSpanSessionWizardData")
    public DvsAddSpanSessionWizardData getAddSpanSessionWizardData(ManagedObjectReference dvsMor) {
        DvsPortMirroringQueryBinding portMirroringQueryBinding = (DvsPortMirroringQueryBinding)this._queryBindingService.prepare(DvsPortMirroringQueryBinding.class).fetch((Object)dvsMor);
        DvsAddSpanSessionWizardData wizardData = new DvsAddSpanSessionWizardData();
        if (portMirroringQueryBinding != null && portMirroringQueryBinding.vspanSupported) {
            wizardData.dvsName = MixedUtil.unescapeVimEntityNameSpecialChars((String)portMirroringQueryBinding.dvsName);
            wizardData.sessionName = this.getUniqueSessionName(portMirroringQueryBinding.vspanSessions);
            if (portMirroringQueryBinding.vspanCapabilities.erspanProtocolSupported != null) {
                wizardData.erspanSupported = portMirroringQueryBinding.vspanCapabilities.erspanProtocolSupported;
            }
            if (portMirroringQueryBinding.vspanCapabilities.mirrorNetstackSupported != null) {
                wizardData.mirrorNetstackSupported = portMirroringQueryBinding.vspanCapabilities.mirrorNetstackSupported;
            }
            wizardData.remoteSourceSupported = portMirroringQueryBinding.vspanCapabilities.remoteSourceSupported;
            wizardData.remoteDestSupported = portMirroringQueryBinding.vspanCapabilities.remoteDestSupported;
            wizardData.dvPortMirrorSupported = portMirroringQueryBinding.vspanCapabilities.dvportSupported;
        }
        return wizardData;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="portBrowserData")
    public DvsSpanSessionPortBrowserData getPortBrowserData(ManagedObjectReference dvsMor) throws Exception {
        com.vmware.vise.data.query.ResultSet resultSet = this._queryExecutor.getData(this.getPortBrowserDataQuerySpec(dvsMor));
        ArrayList<DvsSpanSessionPortBrowserPortData> ports = new ArrayList<DvsSpanSessionPortBrowserPortData>();
        if (resultSet != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                ports.add(DvsAddSpanSessionWizardPortParser.parsePortBrowserPortData(item));
            }
        }
        DvsSpanSessionPortBrowserData data = new DvsSpanSessionPortBrowserData();
        data.ports = ports.toArray(new DvsSpanSessionPortBrowserPortData[ports.size()]);
        return data;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="portListData")
    public DvsSpanSessionPortListData getPortListData(ManagedObjectReference dvsMor, DvsSpanSessionPortListSpec spec) throws Exception {
        com.vmware.vise.data.query.ResultSet resultSet;
        ArrayList<DvsSpanSessionPortListItemData> ports = new ArrayList<DvsSpanSessionPortListItemData>();
        if (spec != null && (resultSet = this._queryExecutor.getData(this.getPortListDataQuerySpec(dvsMor, spec.portIds))) != null && resultSet.items != null) {
            for (ResultItem item : resultSet.items) {
                ports.add(DvsAddSpanSessionWizardPortParser.parsePortListPortData(item));
            }
        }
        DvsSpanSessionPortListData data = new DvsSpanSessionPortListData();
        data.items = ports.toArray(new DvsSpanSessionPortListItemData[ports.size()]);
        return data;
    }

    @ModelMetadata(type={"VmwareDistributedVirtualSwitch"}, propertyNamespace="dvswitchportmirroring", property="dvsuplinks")
    public DvsSpanSessionDestinationUplinksData[] getDvsUplinksForAddSpanSession(ManagedObjectReference dvsMor) {
        ResultSet resultSet = this._queryService.select(new String[]{VSPAN_DVS_UPLINKS}).from(new String[]{dvsMor.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsMor)}).fetch();
        List resultItems = resultSet.getItems();
        if (resultItems != null && !resultItems.isEmpty()) {
            ArrayList<DvsSpanSessionDestinationUplinksData> uplinksData = new ArrayList<DvsSpanSessionDestinationUplinksData>();
            for (ResourceItem resultItem : resultItems) {
                String[] uplinkNames;
                for (String name : uplinkNames = (String[])resultItem.get(VSPAN_DVS_UPLINKS)) {
                    DvsSpanSessionDestinationUplinksData uplinkData = new DvsSpanSessionDestinationUplinksData();
                    uplinkData.uplinkName = name;
                    uplinksData.add(uplinkData);
                }
            }
            return uplinksData.toArray(new DvsSpanSessionDestinationUplinksData[uplinksData.size()]);
        }
        return new DvsSpanSessionDestinationUplinksData[0];
    }

    private QuerySpec getPortBrowserDataQuerySpec(ManagedObjectReference dvsMor) {
        PortCriteria criteria = new PortCriteria();
        criteria.connected = true;
        criteria.uplinkPort = false;
        criteria.nsxPort = false;
        return this.getQuerySpec(criteria, dvsMor, this.getPortBrowserDataPropertyNames(), "H5CustomPortBrowserQuery");
    }

    private QuerySpec getPortListDataQuerySpec(ManagedObjectReference dvsMor, String[] portIds) {
        PortCriteria criteria = new PortCriteria();
        criteria.connected = true;
        criteria.portKey = portIds;
        criteria.nsxPort = false;
        return this.getQuerySpec(criteria, dvsMor, this.getPortListDataPropertyNames(), "H5CustomPortListQuery");
    }

    private QuerySpec getQuerySpec(PortCriteria criteria, ManagedObjectReference dvsMor, String[] properties, String queryName) {
        DistributedVirtualPortFilterSpec filterSpec = new DistributedVirtualPortFilterSpec();
        filterSpec.portCriteria = criteria;
        filterSpec.dvs = dvsMor;
        Constraint constraint = new Constraint();
        constraint.targetType = DVPORT_ENTITY_TYPE;
        ParameterSpec parameterSpec = new ParameterSpec();
        parameterSpec.propertyName = DVPORT_KEY;
        parameterSpec.parameter = filterSpec;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.propertyNames = properties;
        propertySpec.parameters = new ParameterSpec[]{parameterSpec};
        propertySpec.type = DVPORT_ENTITY_TYPE;
        ResourceSpec resourceSpec = new ResourceSpec();
        resourceSpec.constraint = constraint;
        resourceSpec.propertySpecs = new PropertySpec[]{propertySpec};
        QuerySpec querySpec = new QuerySpec();
        querySpec.resourceSpec = resourceSpec;
        querySpec.resultSpec = new ResultSpec();
        querySpec.name = queryName;
        return querySpec;
    }

    private String[] getPortBrowserDataPropertyNames() {
        return new String[]{DVPORT_KEY, DVPORT_NAME, DVPORT_CONN_ENTITY, DVPORT_MAC, DVPORT_PGNAME, DVPORT_PORTSTATE, DVPORT_VLAN, DVPORT_CONNECTEE, DVPORT_PROXYHOST};
    }

    private String[] getPortListDataPropertyNames() {
        return new String[]{DVPORT_KEY, DVPORT_CONNECTEE, DVPORT_CONN_ENTITY, DVPORT_PROXYHOST};
    }

    private String getUniqueSessionName(VmwareDistributedVirtualSwitch.VspanSession[] vspanSessions) {
        String uniqueName;
        ArrayList<String> sessionNames = new ArrayList<String>();
        if (vspanSessions != null) {
            for (VmwareDistributedVirtualSwitch.VspanSession session : vspanSessions) {
                sessionNames.add(session.name);
            }
        }
        Integer i = 0;
        do {
            uniqueName = NetworkStringUtil.getString("AddSpanSessionWizard.defaultSessionName", i.toString());
            Integer n = i;
            Integer n2 = i = Integer.valueOf(i + 1);
        } while (sessionNames.contains(uniqueName));
        return uniqueName;
    }
}

