/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic;

import com.vmware.vim.binding.vim.DistributedVirtualSwitch;
import com.vmware.vsphere.client.dvs.api.info.DvsResControlStatistics;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic.model.DvsSystemTrafficListData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic.model.DvsSystemTrafficListItemData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic.model.DvsSystemTrafficMeterData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic.model.DvsSystemTrafficOverviewData;
import com.vmware.vsphere.client.h5.network.dvs.resmgmt.systemtraffic.model.DvsSystemTrafficQueryBinding;
import java.util.ArrayList;

public class DvsSystemTrafficViewPropertyParser {
    public static DvsSystemTrafficListData getSystemTrafficListData(DvsSystemTrafficQueryBinding queryBinding) {
        DvsSystemTrafficListData listData = new DvsSystemTrafficListData();
        ArrayList<DvsSystemTrafficListItemData> itemsData = new ArrayList<DvsSystemTrafficListItemData>();
        if (queryBinding != null && queryBinding.infrastructureTrafficResource != null) {
            for (DistributedVirtualSwitch.HostInfrastructureTrafficResource resource : queryBinding.infrastructureTrafficResource) {
                DvsSystemTrafficListItemData itemData = new DvsSystemTrafficListItemData();
                itemData.key = resource.key;
                if (resource.allocationInfo != null) {
                    itemData.limit = resource.allocationInfo.limit;
                    itemData.reservation = resource.allocationInfo.reservation;
                    if (resource.allocationInfo.shares != null) {
                        itemData.sharesLevel = resource.allocationInfo.shares.level != null ? resource.allocationInfo.shares.level.toString() : null;
                        itemData.sharesValue = resource.allocationInfo.shares.shares;
                    }
                }
                itemsData.add(itemData);
            }
        }
        listData.items = itemsData.toArray(new DvsSystemTrafficListItemData[itemsData.size()]);
        return listData;
    }

    public static DvsSystemTrafficOverviewData getSystemTrafficOverviewData(DvsSystemTrafficQueryBinding queryBinding) {
        DvsSystemTrafficOverviewData overviewData = new DvsSystemTrafficOverviewData();
        if (queryBinding != null) {
            overviewData.niocEnabled = queryBinding.niocEnabled;
            overviewData.niocVersion = queryBinding.niocVersion;
            if (queryBinding.resControlStatistics != null) {
                overviewData.minPnicSpeed = queryBinding.resControlStatistics.minPnicLinkSpeed;
                overviewData.numPnics = queryBinding.resControlStatistics.totalPnicCount;
                overviewData.excludedPnics = queryBinding.resControlStatistics.excludedPnicCount;
            }
        }
        return overviewData;
    }

    public static DvsSystemTrafficMeterData getSystemTrafficMeterData(DvsSystemTrafficQueryBinding queryBinding) {
        DvsSystemTrafficMeterData meterData = new DvsSystemTrafficMeterData();
        if (queryBinding != null && queryBinding.resControlStatistics != null) {
            DvsResControlStatistics stats = queryBinding.resControlStatistics;
            meterData.ratio = stats.pnicCapacityRatio;
            meterData.reserved = stats.reservedInfrastructureTrafficBandwidth;
            meterData.capacity = stats.minPnicLinkSpeed;
            meterData.available = stats.minPnicLinkSpeed - stats.reservedInfrastructureTrafficBandwidth;
        }
        return meterData;
    }
}

