/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.dvs.upgrade;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.dvs.DistributedVirtualSwitchManager;
import com.vmware.vim.binding.vim.dvs.ProductSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.RuntimeFault;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.HostCompatibilityListItem;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.HostData;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.UpgradeDvsActionData;
import com.vmware.vsphere.client.h5.network.dvs.upgrade.model.UpgradeDvsData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class DvsUpgradePropertyProvider
implements PropertyProviderBean {
    private static final String ANY_DVS_TYPE = "AnyDistributedVirtualSwitch";
    private static final String DVS_HOST_COMPATIBILITY_PROPERTY = "dvsHostCompatibility";
    private static final String DVS_HOST_PROPERTY = "host";
    private final QueryBindingService _queryBindingService;
    private final QueryService _queryService;

    public DvsUpgradePropertyProvider(QueryBindingService queryBindingService, QueryService queryService) {
        this._queryBindingService = queryBindingService;
        this._queryService = queryService;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsupgrade", property="actionAvailable")
    public Boolean getDvsUpgradeActionAvailable(ManagedObjectReference dvsRef) {
        UpgradeDvsActionData upgradeDvsData = (UpgradeDvsActionData)this._queryBindingService.prepare(UpgradeDvsActionData.class).fetch((Object)dvsRef);
        if (upgradeDvsData.currentSwitchSpec != null && upgradeDvsData.currentSwitchSpec.version != null && upgradeDvsData.supportedSwitchSpec != null && !ArrayUtils.isEmpty((Object[])upgradeDvsData.supportedSwitchSpec)) {
            int currentSwitchVersion = this.convertSwitchVersionToInt(upgradeDvsData.currentSwitchSpec.version);
            for (ProductSpec productSpec : upgradeDvsData.supportedSwitchSpec) {
                int supportedSwitchVersion = this.convertSwitchVersionToInt(productSpec.version);
                if (supportedSwitchVersion <= currentSwitchVersion) continue;
                return true;
            }
        }
        return false;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsupgrade", property="wizardData")
    public UpgradeDvsData getDvsUpgradeWizardData(ManagedObjectReference dvsRef) {
        UpgradeDvsData upgradeDvsData = (UpgradeDvsData)this._queryBindingService.prepare(UpgradeDvsData.class).fetch((Object)dvsRef);
        return upgradeDvsData;
    }

    @ModelMetadata(type={"DistributedVirtualSwitch", "VmwareDistributedVirtualSwitch"}, propertyNamespace="dvsupgrade", property="hostCompatibility")
    public List<HostCompatibilityListItem> getDvsUpgradeHostCompatibilityData(ManagedObjectReference dvsRef, ProductSpec productSpec) {
        ResultSet result = this._queryService.select(new String[]{DVS_HOST_COMPATIBILITY_PROPERTY, DVS_HOST_PROPERTY}).from(new String[]{ANY_DVS_TYPE}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate("dvsHostCompatibility/@param", PropertyPredicate.ComparisonOperator.EQUAL, (Object)productSpec), new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)dvsRef)}).fetch();
        if (result.getItems().isEmpty()) {
            return null;
        }
        ResourceItem resultItem = (ResourceItem)result.getItems().get(0);
        DistributedVirtualSwitchManager.CompatibilityResult[] hostCompatibilityResult = (DistributedVirtualSwitchManager.CompatibilityResult[])resultItem.get(DVS_HOST_COMPATIBILITY_PROPERTY);
        Object[] hosts = (ManagedObjectReference[])resultItem.get(DVS_HOST_PROPERTY);
        ArrayList<HostCompatibilityListItem> allHostListItems = new ArrayList<HostCompatibilityListItem>();
        if (ArrayUtils.isEmpty((Object[])hosts)) {
            return allHostListItems;
        }
        HashMap<ManagedObjectReference, HostData> hostRefToDataMap = new HashMap<ManagedObjectReference, HostData>();
        Collection hostDataCollection = this._queryBindingService.prepare(HostData.class).fetch(Arrays.asList(hosts));
        for (HostData hostData : hostDataCollection) {
            hostRefToDataMap.put((ManagedObjectReference)hostData.provider, hostData);
        }
        if (hostCompatibilityResult != null) {
            ArrayList<HostCompatibilityListItem> compatibleHostListItems = new ArrayList<HostCompatibilityListItem>();
            for (DistributedVirtualSwitchManager.CompatibilityResult compatibilityResult : hostCompatibilityResult) {
                HostCompatibilityListItem item = new HostCompatibilityListItem();
                HostData hostData = (HostData)hostRefToDataMap.get(compatibilityResult.host);
                if (hostData != null) {
                    item.hostName = hostData.name;
                    item.hostIcon = hostData.iconId;
                }
                item.compatibilityErrors = this.getCompatibilityErrors(compatibilityResult.error);
                if (item.compatibilityErrors == null) {
                    compatibleHostListItems.add(item);
                    continue;
                }
                allHostListItems.add(item);
            }
            allHostListItems.addAll(compatibleHostListItems);
        }
        return allHostListItems;
    }

    private List<String> getCompatibilityErrors(Exception[] exceptions) {
        if (ArrayUtils.isEmpty((Object[])exceptions)) {
            return null;
        }
        ArrayList<String> errors = new ArrayList<String>();
        for (Exception exception : exceptions) {
            if (exception instanceof RuntimeFault) {
                Object[] faults = ((RuntimeFault)exception).getFaultMessage();
                if (ArrayUtils.isEmpty((Object[])faults)) continue;
                for (Object faultMessage : faults) {
                    if (faultMessage == null || faultMessage.getMessage() == null) continue;
                    errors.add(faultMessage.getMessage());
                }
                continue;
            }
            if (exception.getLocalizedMessage() == null) continue;
            errors.add(exception.getLocalizedMessage());
        }
        return errors;
    }

    private int convertSwitchVersionToInt(String switchVersion) {
        if (StringUtils.isEmpty((CharSequence)switchVersion)) {
            return 0;
        }
        return Integer.parseInt(switchVersion.replaceAll("\\.*", ""));
    }
}

