/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.managepnic;

import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.managepnic.ManagePnicParser;
import com.vmware.vsphere.client.h5.network.host.managepnic.model.ManagePnicValidateSpec;
import com.vmware.vsphere.client.h5.network.host.managepnic.model.VssPnicReconfigureSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ManagePnicMutationProvider
implements MutationProvider {
    private static final String NETWORK_SYSTEM = "networkSystem";
    private static final String CONFIG_NETWORK = "config.network";
    private static final String HOST_NAME = "name";
    private static final Log _logger = LogFactory.getLog(ManagePnicMutationProvider.class);
    private final QueryExecutor _queryExecutor;

    public ManagePnicMutationProvider(QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
    }

    public OperationResult apply(ManagedObjectReference hostRef, VssPnicReconfigureSpec vssPnicReconfigureSpec) throws Exception {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        if (vssPnicReconfigureSpec == null) {
            _logger.error((Object)"VssPnicReconfigureSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        ManagedObjectReference networkSystemRef = (ManagedObjectReference)this._queryExecutor.getProperty((Object)hostRef, NETWORK_SYSTEM);
        NetworkSystem networkSystem = (NetworkSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)networkSystemRef);
        VirtualSwitch virtualSwitch = NetworkUtil.getVswitchByName(vssPnicReconfigureSpec.vSwitchName, networkSystem.getNetworkInfo().vswitch);
        if (virtualSwitch == null) {
            _logger.error((Object)String.format("Virtual switch with name '%s' does not exist", vssPnicReconfigureSpec.vSwitchName));
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        VirtualSwitch.Specification virtualSwitchConfig = ManagePnicParser.buildVSwitchSpec(virtualSwitch, vssPnicReconfigureSpec.activeNic, vssPnicReconfigureSpec.standbyNic, vssPnicReconfigureSpec.unusedNic);
        try {
            networkSystem.updateVirtualSwitch(vssPnicReconfigureSpec.vSwitchName, virtualSwitchConfig);
        }
        catch (Exception ex) {
            _logger.error((Object)("Error when editing virtual standard switch: " + ex.getMessage()));
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    public ValidationResult validate(ManagedObjectReference host, ManagePnicValidateSpec spec) throws Exception {
        ValidationResult validationResult = new ValidationResult();
        if (spec == null || spec.vSwitchName == null) {
            validationResult.result = MixedUtil.getInvalidEntityFault();
            return validationResult;
        }
        PropertyValue[] propertyValues = this._queryExecutor.getProperties((Object)host, new String[]{CONFIG_NETWORK, HOST_NAME});
        NetworkInfo networkInfo = (NetworkInfo)this.getValue(propertyValues, CONFIG_NETWORK);
        String hostName = (String)this.getValue(propertyValues, HOST_NAME);
        if (networkInfo == null || hostName == null) {
            validationResult.result = MixedUtil.getInvalidEntityFault();
            return validationResult;
        }
        VirtualNic[] defaultNetStackVnics = NetworkUtil.getDefaultNetStackVnics(networkInfo);
        validationResult.result = NetworkUtil.areAllVnicsBelongingTo(spec.vSwitchName, networkInfo, defaultNetStackVnics) ? NetworkStringUtil.getString("VssPhysicalNicEditor.warn.vmkernelBacking", spec.vSwitchName, hostName) : NetworkStringUtil.getString("VssPhysicalNicEditor.warn.noActiveNics.text");
        return validationResult;
    }

    private <T> T getValue(PropertyValue[] propertyValues, String property) {
        Object value = null;
        for (PropertyValue pVal : propertyValues) {
            if (!pVal.propertyName.equals(property)) continue;
            value = pVal.value;
            break;
        }
        return (T)value;
    }
}

