/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.migratevmkadapter;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vim.host.NetworkPolicy;
import com.vmware.vim.binding.vim.host.NetworkSystem;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.h5.network.host.migratevmkadapter.model.MigrateVmkToVssSpec;
import com.vmware.vsphere.client.h5.network.host.netstack.HostNetStackMutationProvider;
import java.util.Collection;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MigrateVmkAdapterToVssMutationProvider
implements MutationProvider {
    private final QueryService _queryService;
    private static final String NETWORK_SYSTEM = "networkSystem";
    private static final Log _logger = LogFactory.getLog(HostNetStackMutationProvider.class);

    public MigrateVmkAdapterToVssMutationProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    public OperationResult apply(ManagedObjectReference hostRef, MigrateVmkToVssSpec migrateVmkSpec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        if (migrateVmkSpec == null) {
            _logger.error((Object)"MigrateVmkToVssSpec cannot be null");
            opResult.error = MixedUtil.getInvalidEntityFault();
            return opResult;
        }
        try {
            NetworkSystem networkSystem = this.getNetworkSystem(hostRef);
            PortGroup.Specification portGroupSpec = new PortGroup.Specification();
            portGroupSpec.name = migrateVmkSpec.networkName;
            portGroupSpec.vswitchName = migrateVmkSpec.strandardSwitchName;
            portGroupSpec.vlanId = migrateVmkSpec.vlanId;
            portGroupSpec.policy = new NetworkPolicy();
            networkSystem.addPortGroup(portGroupSpec);
            VirtualNic.Specification nicSpec = new VirtualNic.Specification();
            nicSpec.portgroup = migrateVmkSpec.networkName;
            networkSystem.updateVirtualNic(migrateVmkSpec.vmkDevice, nicSpec);
            if (migrateVmkSpec.networkToRemoveName != null) {
                networkSystem.removePortGroup(migrateVmkSpec.networkToRemoveName);
            }
        }
        catch (Exception ex) {
            opResult.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return opResult;
    }

    private NetworkSystem getNetworkSystem(ManagedObjectReference hostRef) throws Exception {
        ResultSet resultSet = this._queryService.select(new String[]{NETWORK_SYSTEM}).from(new String[]{hostRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef)}).fetch();
        ManagedObjectReference networkSystemMor = null;
        if (CollectionUtils.isNotEmpty((Collection)resultSet.getItems())) {
            networkSystemMor = (ManagedObjectReference)((ResourceItem)resultSet.getItems().get(0)).get(NETWORK_SYSTEM);
        }
        return (NetworkSystem)ManagedObjectUtil.getManagedObject(networkSystemMor);
    }
}

