/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.portgroup;

import com.vmware.cis.data.api.binding.QueryBindingService;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vsphere.client.h5.network.VlanUtil;
import com.vmware.vsphere.client.h5.network.host.portgroup.PortGroupParser;
import com.vmware.vsphere.client.h5.network.host.portgroup.model.EditPortgroupDialogData;
import com.vmware.vsphere.client.h5.network.host.portgroup.model.PortgroupDetailsData;
import com.vmware.vsphere.client.h5.network.host.wizard.addnetworking.model.HostStandardPortgroupInfo;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import org.apache.commons.lang3.StringUtils;

public class HostPortgroupPropertyProvider
implements PropertyProviderBean {
    private static final String HOST_PORT_GROUPS = "config.network.portgroup";
    private final QueryExecutor _queryExecutor;
    private final QueryBindingService _queryBindingService;

    public HostPortgroupPropertyProvider(QueryBindingService queryBindingService, QueryExecutor queryExecutor) {
        this._queryExecutor = queryExecutor;
        this._queryBindingService = queryBindingService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="portgroup", property="portgroupDialogData")
    public EditPortgroupDialogData getPortgroupDialogData(ManagedObjectReference hostRef, String portgroupKey) {
        if (StringUtils.isEmpty((CharSequence)portgroupKey)) {
            throw new IllegalArgumentException("Invalid key value: " + portgroupKey);
        }
        PortgroupDetailsData portgroupDetailsData = (PortgroupDetailsData)this._queryBindingService.prepare(PortgroupDetailsData.class).fetch((Object)hostRef);
        return PortGroupParser.createEditPortgroupDialogData(portgroupKey, portgroupDetailsData);
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="portgroup", property="hostStandardPortgroupInfo")
    public HostStandardPortgroupInfo getHostStandardPortgroupInfo(ManagedObjectReference hostRef, String uniqueNamePrefix) throws Exception {
        HostStandardPortgroupInfo hostStandardPortgroupInfo = new HostStandardPortgroupInfo();
        PortGroup[] portGroups = (PortGroup[])this._queryExecutor.getProperty((Object)hostRef, HOST_PORT_GROUPS);
        hostStandardPortgroupInfo.uniquePortGroupName = NetworkUtil.getUniqueName(portGroups, uniqueNamePrefix);
        hostStandardPortgroupInfo.vlanIds = VlanUtil.getAvailableVlanIds((PortGroup[])portGroups);
        return hostStandardPortgroupInfo;
    }
}

