/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.host.summary;

import com.vmware.cis.data.api.LogicalOperator;
import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.annotation.ModelMetadata;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vsphere.client.h5.network.host.model.GhostDvsData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.Validate;

public class HostSummaryNetworkingPropertyProvider
implements PropertyProviderBean {
    private static final String NAME_PROPERTY = "name";
    private static final String UUID_PROPERTY = "uuid";
    private static final String ANY_DVS = "AnyDistributedVirtualSwitch";
    private QueryService _queryService;

    public HostSummaryNetworkingPropertyProvider(QueryService queryService) {
        this._queryService = queryService;
    }

    @ModelMetadata(type={"HostSystem"}, propertyNamespace="hostNetworkingIssue", property="ghostDvsProxySwitchDetails")
    public GhostDvsData[] getGhostDvsProxySwitchDetails(ManagedObjectReference hostRef, List<String> switchUuids) {
        Validate.notNull((Object)hostRef);
        ResultSet dvsRefResult = this._queryService.select(new String[]{NAME_PROPERTY}).from(new String[]{ANY_DVS}).where(LogicalOperator.AND, new PropertyPredicate[]{new PropertyPredicate(UUID_PROPERTY, PropertyPredicate.ComparisonOperator.IN, switchUuids), new PropertyPredicate("@instanceUuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)hostRef.getServerGuid())}).fetch();
        if (dvsRefResult == null || CollectionUtils.isEmpty((Collection)dvsRefResult.getItems())) {
            return new GhostDvsData[0];
        }
        ArrayList<GhostDvsData> ghostDvsDataList = new ArrayList<GhostDvsData>();
        for (ResourceItem resultItem : dvsRefResult.getItems()) {
            GhostDvsData ghostDvsData = new GhostDvsData((String)resultItem.get(0), (ManagedObjectReference)resultItem.getKey());
            ghostDvsDataList.add(ghostDvsData);
        }
        return ghostDvsDataList.toArray(new GhostDvsData[ghostDvsDataList.size()]);
    }
}

