/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.ippools.impl;

import com.vmware.vim.binding.vim.vApp.IpPool;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.query.client.exception.ValidationException;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vsphere.client.h5.network.ippools.data.ValidateNameAndNetworksSpec;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import com.vmware.vsphere.client.h5.network.util.NetworkUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IpPoolsMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(IpPoolsMutationProvider.class);
    private static final String IP_POOLS_PROP_NAME = "ipPools";
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public IpPoolsMutationProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    public ValidationResult validate(ValidateNameAndNetworksSpec spec) throws Exception {
        ValidationResult result = new ValidationResult();
        IpPool[] ipPools = (IpPool[])NetworkUtil.requestPropertyWithParam(this._queryExecutor, this._querySpecBuilder, spec.datacenterRef, IP_POOLS_PROP_NAME, null);
        if (ipPools == null) {
            return result;
        }
        boolean isNetworkAlreadyAssociated = false;
        for (IpPool ipPool : ipPools) {
            if (ipPool.id.equals(spec.ipPoolId)) continue;
            if (ipPool.getName().equals(spec.name)) {
                result.error = new ValidationException(NetworkStringUtil.getString("ippools.error.nameNotUnique"));
                return result;
            }
            for (ManagedObjectReference networkRef : spec.networkRefs) {
                isNetworkAlreadyAssociated = isNetworkAlreadyAssociated || this.isNetworkAlreadyAssociated(networkRef, ipPool.getNetworkAssociation());
            }
        }
        if (isNetworkAlreadyAssociated) {
            result.result = NetworkStringUtil.getString("ippools.error.networkOverride");
        }
        return result;
    }

    private boolean isNetworkAlreadyAssociated(ManagedObjectReference networkRef, IpPool.Association[] networkAssociations) {
        for (IpPool.Association association : networkAssociations) {
            if (!association.getNetwork().equals((Object)networkRef)) continue;
            return true;
        }
        return false;
    }
}

