/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.network.util;

import com.vmware.vim.binding.vim.dvs.VmwareDistributedVirtualSwitch;
import com.vmware.vsphere.client.h5.network.util.NetworkStringUtil;
import org.apache.commons.lang3.StringUtils;

public class DvsPortMirrorUtil {
    public static final int MIN_SAMPLING_RATE = 1;
    public static final int MAX_SAMPLING_RATE = 65535;
    public static final int MIN_MIRRORED_PACKET_LENGTH = 60;
    public static final int MAX_MIRRORED_PACKET_LENGTH = 9000;
    public static final int MIN_SESSION_ID = 0;
    public static final int MAX_SESSION_ID = 1023;
    public static final int DEFAULT_UNSET_INT_VALUE = -1;
    public static final String DEFAULT_TCP_IP_STACK = "defaultTcpipStack";
    public static final String MIRROR_TCP_IP_STACK = "mirror";

    public static String formatDvsPortMirrorSessionType(String sessionType) {
        String sessionTypeLabel;
        if (StringUtils.isEmpty((CharSequence)sessionType)) {
            return NetworkStringUtil.getString("na");
        }
        try {
            switch (VmwareDistributedVirtualSwitch.VspanSessionType.valueOf((String)sessionType)) {
                case dvPortMirror: {
                    sessionTypeLabel = NetworkStringUtil.getString("dvsPortMirror.sessionType.dvPortMirror");
                    break;
                }
                case encapsulatedRemoteMirrorSource: {
                    sessionTypeLabel = NetworkStringUtil.getString("dvsPortMirror.sessionType.encapsulatedRemoteMirrorSource");
                    break;
                }
                case remoteMirrorDest: {
                    sessionTypeLabel = NetworkStringUtil.getString("dvsPortMirror.sessionType.remoteMirrorDest");
                    break;
                }
                case remoteMirrorSource: {
                    sessionTypeLabel = NetworkStringUtil.getString("dvsPortMirror.sessionType.remoteMirrorSource");
                    break;
                }
                case mixedDestMirror: {
                    sessionTypeLabel = NetworkStringUtil.getString("dvsPortMirror.sessionType.mixedDestMirror");
                    break;
                }
                default: {
                    sessionTypeLabel = NetworkStringUtil.getString("na");
                    break;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            sessionTypeLabel = NetworkStringUtil.getString("na");
        }
        return sessionTypeLabel;
    }

    public static String formatDvsPortMirrorEncapsulationType(String encapType) {
        String encapsulationTypeLabel;
        if (StringUtils.isEmpty((CharSequence)encapType)) {
            return NetworkStringUtil.getString("na");
        }
        try {
            switch (VmwareDistributedVirtualSwitch.VspanSessionEncapType.valueOf((String)encapType)) {
                case erspan2: {
                    encapsulationTypeLabel = NetworkStringUtil.getString("dvsPortMirror.encapType.erspan2");
                    break;
                }
                case erspan3: {
                    encapsulationTypeLabel = NetworkStringUtil.getString("dvsPortMirror.encapType.erspan3");
                    break;
                }
                case gre: {
                    encapsulationTypeLabel = NetworkStringUtil.getString("dvsPortMirror.encapType.gre");
                    break;
                }
                default: {
                    encapsulationTypeLabel = NetworkStringUtil.getString("na");
                    break;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            encapsulationTypeLabel = NetworkStringUtil.getString("na");
        }
        return encapsulationTypeLabel;
    }

    public static String formatDvsPortMirrorNetStack(String tcpIpStackKey) {
        String netStackLabel;
        if (StringUtils.isEmpty((CharSequence)tcpIpStackKey)) {
            return NetworkStringUtil.getString("na");
        }
        try {
            switch (tcpIpStackKey) {
                case "defaultTcpipStack": {
                    netStackLabel = NetworkStringUtil.getString("dvsPortMirror.tcpIpStack.defualt");
                    break;
                }
                case "mirror": {
                    netStackLabel = NetworkStringUtil.getString("dvsPortMirror.tcpIpStack.mirror");
                    break;
                }
                default: {
                    netStackLabel = NetworkStringUtil.getString("dvsPortMirror.tcpIpStack.defualt");
                    break;
                }
            }
        }
        catch (IllegalArgumentException ex) {
            netStackLabel = NetworkStringUtil.getString("na");
        }
        return netStackLabel;
    }
}

