/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.impl;

import com.vmware.eam.util.EamConnection;
import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.Agent;
import com.vmware.vim.binding.eam.EsxAgentManager;
import com.vmware.vim.binding.eam.issue.Issue;
import com.vmware.vim.binding.eam.issue.UnknownAgentVm;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.CompositeConstraint;
import com.vmware.vise.data.query.Conjoiner;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.ResultUtil;
import com.vmware.vsphere.client.common.data.DataProviderAdapterBase;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.ResultObject;
import com.vmware.vsphere.client.vcextension.common.SearchUtil;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="VirtualMachine")
public class AgentSearchProvider
extends DataProviderAdapterBase {
    private static final Log _logger = LogFactory.getLog(AgentSearchProvider.class);
    private static final String TYPE_VIRTUAL_MACHINE = "VirtualMachine";
    private static final String RELATIONSHIP_UNKNOWN_AGENT = "unknownAgent";
    private final DataService _dataService;

    public AgentSearchProvider(DataService dataService) {
        assert (dataService != null);
        this._dataService = dataService;
    }

    protected ResultSet processQuery(RelationalConstraint constraint, QuerySpec query) {
        ExtensionUriSpec relationshipSource = this.validateConstraint(constraint);
        if (relationshipSource == null) {
            return ResultUtil.newEmptyResultSet();
        }
        try {
            if (SearchUtil.isObjectCountQuery((QuerySpec)query)) {
                int objCount = this.getObjectCount(relationshipSource, constraint.relation);
                return SearchUtil.createResultSet((int)objCount);
            }
            boolean storeRelationType = SearchUtil.isPropertyRequested((String)"vcExtensionRelatedObjectType", (QuerySpec)query);
            List<? extends ManagedObjectReference> foundObjects = this.getObjects(relationshipSource, constraint.relation, storeRelationType);
            Set propertyConstraints = Collections.emptySet();
            return SearchUtil.createFilteredResultSet(foundObjects, propertyConstraints, (QuerySpec)query, (DataService)this._dataService);
        }
        catch (Exception eamException) {
            _logger.error((Object)("Exception occured while communicating with the ESX Agent Manager. Agent query: " + constraint.relation + " for " + relationshipSource), (Throwable)eamException);
            String message = EamUtil.getLocalizedString("error.unableToContactEam", new String[0]);
            return ResultUtil.newErrorResultSet((Exception[])new Exception[]{new Exception(message, eamException)});
        }
    }

    protected ResultSet processQuery(CompositeConstraint constraint, QuerySpec query) {
        Set relationalConstraints = SearchUtil.getSubConstraints((Constraint)constraint, RelationalConstraint.class, (String)TYPE_VIRTUAL_MACHINE, (Conjoiner)Conjoiner.OR, (boolean)true);
        ArrayList<AgentQuerySpec> agentQueries = new ArrayList<AgentQuerySpec>();
        for (RelationalConstraint relation : relationalConstraints) {
            ExtensionUriSpec extension = this.validateConstraint(relation);
            if (extension == null) continue;
            agentQueries.add(new AgentQuerySpec(extension, relation.relation));
        }
        if (agentQueries.isEmpty()) {
            return ResultUtil.newEmptyResultSet();
        }
        Set propertyConstraints = SearchUtil.getSubConstraints((Constraint)constraint, PropertyConstraint.class, (String)TYPE_VIRTUAL_MACHINE, (Conjoiner)Conjoiner.OR, (boolean)true);
        boolean unconstrainedCount = SearchUtil.isObjectCountQuery((QuerySpec)query) && propertyConstraints.isEmpty();
        boolean storeRelationType = false;
        if (!unconstrainedCount) {
            storeRelationType = SearchUtil.isPropertyRequested((String)"vcExtensionRelatedObjectType", (QuerySpec)query);
        }
        ArrayList<? extends ManagedObjectReference> foundObjects = new ArrayList<ManagedObjectReference>();
        int objCount = 0;
        for (AgentQuerySpec agentQuery : agentQueries) {
            try {
                if (unconstrainedCount) {
                    objCount += this.getObjectCount(agentQuery.extensionContext, agentQuery.relation);
                    continue;
                }
                List<? extends ManagedObjectReference> queryResult = this.getObjects(agentQuery.extensionContext, agentQuery.relation, storeRelationType);
                foundObjects.addAll(queryResult);
            }
            catch (Exception eamException) {
                _logger.error((Object)("Exception occured while communicating with the ESX Agent Manager. Agent query: " + agentQuery), (Throwable)eamException);
                String message = EamUtil.getLocalizedString("error.unableToContactEam", new String[0]);
                return ResultUtil.newErrorResultSet((Exception[])new Exception[]{new Exception(message, eamException)});
            }
        }
        if (unconstrainedCount) {
            return SearchUtil.createResultSet((int)objCount);
        }
        return SearchUtil.createFilteredResultSet(foundObjects, (Set)propertyConstraints, (QuerySpec)query, (DataService)this._dataService);
    }

    private ExtensionUriSpec validateConstraint(RelationalConstraint constraint) {
        if (!constraint.hasInverseRelation) {
            return null;
        }
        if (!this.isSupportedRelation(constraint.relation)) {
            return null;
        }
        ExtensionUriSpec relationshipSource = SearchUtil.getRelatedExtensionSpec((RelationalConstraint)constraint);
        if (relationshipSource == null) {
            return null;
        }
        if ("esxAgent".equals(constraint.relation)) {
            if ("com.vmware.vim.eam".equals(relationshipSource.getKey())) {
                return null;
            }
            return relationshipSource;
        }
        if (RELATIONSHIP_UNKNOWN_AGENT.equals(constraint.relation)) {
            if ("com.vmware.vim.eam".equals(relationshipSource.getKey())) {
                return relationshipSource;
            }
            return null;
        }
        return null;
    }

    private List<? extends ManagedObjectReference> getObjects(ExtensionUriSpec extension, String relation, boolean addRelationDescription) throws Exception {
        assert (extension != null && this.isSupportedRelation(relation));
        List<ManagedObjectReference> objects = null;
        objects = "esxAgent".equals(relation) ? this.getExtensionAgents(extension) : this.getUnknownAgents(extension);
        assert (objects != null);
        if (!addRelationDescription) {
            return objects;
        }
        ArrayList<ResultObject> objectsWithProperties = new ArrayList<ResultObject>();
        String relationTypeKey = RELATIONSHIP_UNKNOWN_AGENT.equals(relation) ? "unknownAgentVm.relationType" : "agentVm.relationType";
        String relationType = EamUtil.getLocalizedString(relationTypeKey, new String[0]);
        for (ManagedObjectReference obj : objects) {
            PropertyValue relationTypeProperty = ResultUtil.newProperty((String)"vcExtensionRelatedObjectType", (Object)relationType, (Object)obj);
            ResultObject resultObj = ResultObject.newInstance((ManagedObjectReference)obj);
            resultObj.add(new PropertyValue[]{relationTypeProperty});
            objectsWithProperties.add(resultObj);
        }
        return objectsWithProperties;
    }

    private int getObjectCount(ExtensionUriSpec extension, String relation) throws Exception {
        assert (extension != null && this.isSupportedRelation(relation));
        if ("esxAgent".equals(relation)) {
            return this.getExtensionAgents(extension).size();
        }
        return this.getUnknownAgentCount(extension);
    }

    private List<ManagedObjectReference> getUnknownAgents(ExtensionUriSpec extension) throws Exception {
        assert ("com.vmware.vim.eam".equals(extension.getKey()));
        Object[] issues = this.getEamIssues(extension);
        if (ArrayUtils.isEmpty((Object[])issues)) {
            return Collections.emptyList();
        }
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (Object issue : issues) {
            if (!(issue instanceof UnknownAgentVm)) continue;
            ManagedObjectReference eamVmMoRef = ((UnknownAgentVm)issue).getVm();
            ManagedObjectReference vimVmMoref = EamUtil.eamToVimMoref(eamVmMoRef, extension.getServerGuid());
            result.add(vimVmMoref);
        }
        return result;
    }

    private int getUnknownAgentCount(ExtensionUriSpec extension) throws Exception {
        assert ("com.vmware.vim.eam".equals(extension.getKey()));
        Object[] issues = this.getEamIssues(extension);
        if (ArrayUtils.isEmpty((Object[])issues)) {
            return 0;
        }
        int unknownAgentCount = 0;
        for (Object issue : issues) {
            if (!(issue instanceof UnknownAgentVm)) continue;
            ++unknownAgentCount;
        }
        return unknownAgentCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ManagedObjectReference> getExtensionAgents(ExtensionUriSpec extension) throws Exception {
        _logger.debug((Object)("Get agent VMs for " + extension + " - open connection to EAM"));
        EamConnection eamConnection = null;
        try {
            eamConnection = EamConnection.newInstance(extension.getServerGuid());
            EsxAgentManager eam = eamConnection.getEsxAgentManager();
            _logger.debug((Object)("Get agent VMs for " + extension + " - established connection to EAM"));
            Object[] agencies = eam.queryAgency();
            if (ArrayUtils.isEmpty((Object[])agencies)) {
                _logger.debug((Object)("No agencies returned for extension " + extension));
                List<ManagedObjectReference> list = Collections.emptyList();
                return list;
            }
            _logger.debug((Object)(agencies.length + " agencies returned for extension " + extension));
            ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
            for (Object agencyRef : agencies) {
                Object[] agents;
                Agency agency = eamConnection.getAgency((ManagedObjectReference)agencyRef);
                if (!extension.getKey().equals(agency.getSolutionId()) || ArrayUtils.isEmpty((Object[])(agents = agency.queryAgent()))) continue;
                for (Object agentRef : agents) {
                    Agent agent = eamConnection.getAgent((ManagedObjectReference)agentRef);
                    ManagedObjectReference vmRef = agent.queryRuntime().getVm();
                    if (vmRef == null) {
                        _logger.warn((Object)("EAM returned a null VM for the agent " + agentRef));
                        continue;
                    }
                    ManagedObjectReference vimVmRef = EamUtil.eamToDsMoref(vmRef, extension.getServerGuid());
                    result.add(vimVmRef);
                }
            }
            ArrayList<ManagedObjectReference> arrayList = result;
            return arrayList;
        }
        finally {
            EamConnection.tryClose((VcExtensionConnection)eamConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Issue[] getEamIssues(ExtensionUriSpec eamInstance) throws Exception {
        _logger.debug((Object)("Get issues for EAM on " + eamInstance.getServerGuid() + " - open connection to EAM"));
        EamConnection eamConnection = null;
        try {
            eamConnection = EamConnection.newInstance(eamInstance.getServerGuid());
            EsxAgentManager eam = eamConnection.getEsxAgentManager();
            _logger.debug((Object)("Get issues for EAM on " + eamInstance.getServerGuid() + " - established connection to EAM"));
            Issue[] issueArray = eam.getIssue();
            return issueArray;
        }
        finally {
            EamConnection.tryClose((VcExtensionConnection)eamConnection);
        }
    }

    private boolean isSupportedRelation(String relation) {
        return "esxAgent".equals(relation) || RELATIONSHIP_UNKNOWN_AGENT.equals(relation);
    }

    private static class AgentQuerySpec {
        public ExtensionUriSpec extensionContext;
        public String relation;

        public AgentQuerySpec(ExtensionUriSpec extensionContext, String relation) {
            assert (extensionContext != null && StringUtils.isNotEmpty((CharSequence)relation));
            this.extensionContext = extensionContext;
            this.relation = relation;
        }

        public String toString() {
            return this.relation + " [" + this.extensionContext + "]";
        }
    }
}

