/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.impl;

import com.vmware.eam.EamOperation;
import com.vmware.eam.EamOperationSpec;
import com.vmware.eam.util.EamConnection;
import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.EsxAgentManager;
import com.vmware.vise.core.model.monitor.ClientTaskInfo;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vsphere.client.task.TaskRegistry;
import com.vmware.vsphere.client.task.impl.ParametrizedMessageException;
import com.vmware.vsphere.client.vcextension.common.ExtensionUriSpec;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import java.net.URI;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class EamMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(EamMutationProvider.class);
    private final TaskRegistry _taskRegistry;

    public EamMutationProvider(TaskRegistry taskRegistry) {
        assert (taskRegistry != null);
        this._taskRegistry = taskRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public OperationResult apply(URI uri, EamOperationSpec opSpec) {
        EamConnection eamConnection;
        ExtensionUriSpec uriSpec;
        OperationResult result;
        block9: {
            Validate.notNull((Object)uri);
            Validate.notNull((Object)opSpec);
            assert (opSpec.operation == EamOperation.SCAN_FOR_UNKNOWN_AGENTS);
            result = new OperationResult();
            result.entity = uri;
            result.parameter = opSpec;
            uriSpec = null;
            eamConnection = null;
            try {
                uriSpec = new ExtensionUriSpec(uri);
                if (!"com.vmware.vim.eam".equals(uriSpec.getKey())) {
                    result.error = new ParametrizedMessageException("error.unknownAgentScan.invalidUri", new String[]{uri.toString()});
                    _logger.debug((Object)("Bad URI context for unknown agent scan. Expected EAM URI but got: " + uri));
                    break block9;
                }
                eamConnection = EamConnection.newInstance(uriSpec.getServerGuid());
                EsxAgentManager eam = eamConnection.getEsxAgentManager();
                eam.scanForUnknownAgentVm();
            }
            catch (IllegalArgumentException ex) {
                _logger.error((Object)("Extension URI is invalid. Exception:" + ex));
                result.error = ex;
                OperationResult operationResult = result;
                EamConnection.tryClose((VcExtensionConnection)eamConnection);
                return operationResult;
            }
            catch (Exception ex2) {
                _logger.error((Object)("Exception communicating with EAM:" + ex2));
                result.error = ex2;
                {
                    catch (Throwable throwable) {
                        EamConnection.tryClose(eamConnection);
                        throw throwable;
                    }
                }
                EamConnection.tryClose((VcExtensionConnection)eamConnection);
            }
        }
        EamConnection.tryClose((VcExtensionConnection)eamConnection);
        assert (uriSpec != null);
        EamOperation operation = EamOperation.SCAN_FOR_UNKNOWN_AGENTS;
        ClientTaskInfo task = EamUtil.newFinishedEamTask(uriSpec.getServerGuid(), operation.getTaskLabelKey(), result.error);
        task.details = operation.getTaskDetailsKey();
        this._taskRegistry.addTask(task);
        return result;
    }
}

