/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.eam.util;

import com.vmware.eam.util.EamUtil;
import com.vmware.vim.binding.eam.Agency;
import com.vmware.vim.binding.eam.Agent;
import com.vmware.vim.binding.eam.EsxAgentManager;
import com.vmware.vim.binding.eam.version.version2;
import com.vmware.vim.binding.eam.version.version7_1;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vsphere.client.vcextension.common.VcExtensionConnection;
import com.vmware.vsphere.client.vcextension.common.VmomiClientFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class EamConnection
extends VcExtensionConnection {
    private static final String EAM_MOREF_TYPE = "EsxAgentManager";
    private static final String EAM_MOREF_VALUE = "EsxAgentManager";
    private static final String SERVER_INFO_TYPE = "com.vmware.vim.eam";
    private static final String EAM_VMODL_PACKAGE = "com.vmware.vim.binding.eam";
    private static final Log _logger = LogFactory.getLog(EamConnection.class);
    private final String _serverGuid;

    private EamConnection(VmomiClientFactory.ClientSpec clientSpec) throws Exception {
        super(clientSpec);
        this._serverGuid = clientSpec.serverGuid;
    }

    public static EamConnection newInstance(String serverGuid) throws Exception {
        VmomiClientFactory.ClientSpec clientSpec = new VmomiClientFactory.ClientSpec();
        clientSpec.serverGuid = serverGuid;
        clientSpec.vmodlVersion = EamConnection.getVmodlVersion(serverGuid);
        clientSpec.vmodlPackage = EAM_VMODL_PACKAGE;
        clientSpec.extensionKey = SERVER_INFO_TYPE;
        clientSpec.extensionServerType = SERVER_INFO_TYPE;
        return new EamConnection(clientSpec);
    }

    public EsxAgentManager getEsxAgentManager() throws Exception {
        ManagedObjectReference eamRef = new ManagedObjectReference("EsxAgentManager", "EsxAgentManager");
        EsxAgentManager eam = this.createStub(EsxAgentManager.class, eamRef);
        if (eam == null) {
            String message = EamUtil.getLocalizedString("error.unableToContactEam", new String[0]);
            throw new Exception(message);
        }
        return eam;
    }

    public String getServerGuid() {
        return this._serverGuid;
    }

    public Agency getAgency(ManagedObjectReference agencyRef) {
        if (agencyRef == null) {
            throw new IllegalArgumentException("agencyRef is null");
        }
        if (!"Agency".equals(agencyRef.getType())) {
            throw new IllegalArgumentException("Invalid moref type " + agencyRef.getType());
        }
        return this.createStub(Agency.class, agencyRef);
    }

    public Agent getAgent(ManagedObjectReference agentRef) {
        if (agentRef == null) {
            throw new IllegalArgumentException("agentRef is null");
        }
        if (!"Agent".equals(agentRef.getType())) {
            throw new IllegalArgumentException("Invalid moref type " + agentRef.getType());
        }
        return this.createStub(Agent.class, agentRef);
    }

    private static Class<?> getVmodlVersion(String serverGuid) {
        if (VcServiceUtil.is67VcOrLaterByServerGuid((String)serverGuid, (boolean)true)) {
            return version7_1.class;
        }
        return version2.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends ManagedObject> T createStub(Class<T> clazz, ManagedObjectReference mor) {
        ManagedObject stub = null;
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader bundleClassLoader = clazz.getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(bundleClassLoader);
            stub = this.getClient().createStub(clazz, mor);
        }
        catch (Exception ex) {
            _logger.error((Object)String.format("Error while creating stub for type: %s", clazz.getSimpleName()), (Throwable)ex);
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
        return (T)stub;
    }
}

