/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.model.DerivedProperty;
import com.vmware.cis.data.model.SourceProperty;
import com.vmware.vim.binding.vim.Capability;
import com.vmware.vim.binding.vim.EVCMode;
import com.vmware.vim.binding.vim.FeatureEVCMode;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.host.CpuPackage;
import com.vmware.vim.binding.vim.host.FeatureMask;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.h5.vm.model.SupportedEvcMode;
import com.vmware.vsphere.client.h5.vm.model.VmEditEvcCpuData;
import com.vmware.vsphere.client.h5.vm.model.VmEditEvcData;
import com.vmware.vsphere.client.h5.vm.model.VmEditEvcGpuData;
import com.vmware.vsphere.client.h5.vm.model.VmEvcData;
import com.vmware.vsphere.client.h5.vm.util.VmHardwareVersion;
import com.vmware.vsphere.client.h5.vm.util.VmStringUtil;
import java.util.ArrayList;
import java.util.EnumMap;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmEvcPropertyProvider {
    private static final Log _logger = LogFactory.getLog(VmEvcPropertyProvider.class);

    @DerivedProperty(value="VirtualMachine/vmEvcEnabled")
    public static boolean getVmEvcEnabled(@SourceProperty(value="VirtualMachine/capability/perVmEvcSupported") Boolean vmEvcSupported, @SourceProperty(value="VirtualMachine/runtime/minRequiredEVCModeKey") String vmMinRequiredEVCModeKey) {
        if (!Boolean.TRUE.equals(vmEvcSupported)) {
            return false;
        }
        return StringUtils.isNotEmpty((CharSequence)vmMinRequiredEVCModeKey);
    }

    @DerivedProperty(value="VirtualMachine/vmEvcData")
    public static VmEvcData getVmEvcData(@SourceProperty(value="VirtualMachine/@instanceUuid") String serverGuid, @SourceProperty(value="VirtualMachine/runtime/minRequiredEVCModeKey") String vmMinRequiredEVCModeKey, @SourceProperty(value="VirtualMachine/vmEVCGraphicsModeKey") String vmEVCGraphicsModeKey, @SourceProperty(value="VirtualMachine/vmEVCGraphicsFeatureMasks") FeatureMask[] evcGraphicsMasks, @SourceProperty(value="VirtualMachine/vmEVCCPUIDFeatureMasks") FeatureMask[] evcCpuMasks) {
        Capability capability = VmEvcPropertyProvider.getCapability(serverGuid);
        EVCMode[] supportedEvcModes = VmEvcPropertyProvider.getSupportedCpuEvcModes(serverGuid, capability);
        VmEvcData data = VmEvcPropertyProvider.getCurrentEvcMode(vmMinRequiredEVCModeKey, supportedEvcModes);
        FeatureEVCMode[] supportedEvcGraphicsModes = VmEvcPropertyProvider.getSupportedEvcGraphicsModes(capability);
        VmEvcPropertyProvider.localizeMasks(evcGraphicsMasks);
        VmEvcPropertyProvider.setCurrentEvcGraphicsMode(data, vmEVCGraphicsModeKey, supportedEvcGraphicsModes, evcGraphicsMasks);
        VmEvcPropertyProvider.localizeMasks(evcCpuMasks);
        data.cpuEVCFeatures = evcCpuMasks;
        return data;
    }

    @DerivedProperty(value="VirtualMachine/vmEditEvcData")
    public static VmEditEvcData getVmEditEvcData(@SourceProperty(value="VirtualMachine/@instanceUuid") String serverGuid, @SourceProperty(value="VirtualMachine/config/version") String vmHwVersion, @SourceProperty(value="VirtualMachine/runtime/minRequiredEVCModeKey") String vmMinRequiredEVCModeKey, @SourceProperty(value="VirtualMachine/vmEVCGraphicsModeKey") String currentEvcGpuModeKey) {
        VmEditEvcData vmEditEvcData = new VmEditEvcData();
        Capability capability = VmEvcPropertyProvider.getCapability(serverGuid);
        EVCMode[] supportedEvcCpuModes = VmEvcPropertyProvider.getSupportedCpuEvcModes(serverGuid, capability);
        vmEditEvcData.cpuData = VmEvcPropertyProvider.buildEditEvcCpuData(vmMinRequiredEVCModeKey, supportedEvcCpuModes);
        try {
            VmHardwareVersion minVmHwVersion = new VmHardwareVersion("vmx-18");
            if (new VmHardwareVersion(vmHwVersion).compareTo(minVmHwVersion) >= 0) {
                Object[] supportedEvcGpuModes = VmEvcPropertyProvider.getSupportedEvcGraphicsModes(capability);
                vmEditEvcData.gpuData = !ArrayUtils.isEmpty((Object[])supportedEvcGpuModes) ? VmEvcPropertyProvider.buildEditEvcGraphicsData(currentEvcGpuModeKey, (FeatureEVCMode[])supportedEvcGpuModes) : null;
            }
        }
        catch (VmHardwareVersion.IncorrectHardwareVersionException exception) {
            _logger.warn((Object)"GPU EVC data is not available");
        }
        if (VmEvcPropertyProvider.isGpuModeCustom(vmEditEvcData)) {
            VmEvcPropertyProvider.setCustomCpuDataWhenGpuIsCustom(vmEditEvcData, vmMinRequiredEVCModeKey, supportedEvcCpuModes);
        }
        return vmEditEvcData;
    }

    private static void setCustomCpuDataWhenGpuIsCustom(VmEditEvcData vmEditEvcData, String vmMinRequiredEVCModeKey, EVCMode[] supportedEvcCpuModes) {
        if (VmEvcPropertyProvider.isCpuModeCustom(vmEditEvcData)) {
            return;
        }
        vmEditEvcData.cpuData.vendor = VmEvcData.VmEvcVendor.CUSTOM;
        VmEvcData currentEvcMode = VmEvcPropertyProvider.getCurrentEvcMode(vmMinRequiredEVCModeKey, supportedEvcCpuModes);
        SupportedEvcMode currentCpuMode = new SupportedEvcMode();
        currentCpuMode.key = currentEvcMode.key;
        currentCpuMode.label = currentEvcMode.label;
        currentCpuMode.summary = currentEvcMode.summary;
        ArrayList<SupportedEvcMode> customModes = new ArrayList<SupportedEvcMode>();
        customModes.add(currentCpuMode);
        vmEditEvcData.cpuData.evcModesByVendor.put(VmEvcData.VmEvcVendor.CUSTOM, customModes);
        vmEditEvcData.cpuData.key = currentCpuMode.key;
    }

    private static boolean isCpuModeCustom(VmEditEvcData data) {
        String customVendor = VmEvcData.VmEvcVendor.CUSTOM.toString();
        return data.cpuData != null && customVendor.equals(data.cpuData.key);
    }

    private static boolean isGpuModeCustom(VmEditEvcData data) {
        String customVendor = VmEvcData.VmEvcVendor.CUSTOM.toString();
        return data.gpuData != null && customVendor.equals(data.gpuData.key);
    }

    private static VmEvcData getCurrentEvcMode(String vmMinRequiredEVCModeKey, EVCMode[] supportedEvcModes) {
        VmEvcData evcData = new VmEvcData();
        if (ArrayUtils.isEmpty((Object[])supportedEvcModes)) {
            evcData.vendor = VmEvcData.VmEvcVendor.NONE;
            evcData.key = VmEvcData.VmEvcVendor.NONE.toString();
            return evcData;
        }
        if (StringUtils.isNotEmpty((CharSequence)vmMinRequiredEVCModeKey)) {
            if ("custom".equals(vmMinRequiredEVCModeKey)) {
                evcData.vendor = VmEvcData.VmEvcVendor.CUSTOM;
                evcData.key = VmEvcData.VmEvcVendor.CUSTOM.toString();
                return evcData;
            }
            for (EVCMode mode : supportedEvcModes) {
                if (!mode.getKey().equals(vmMinRequiredEVCModeKey)) continue;
                evcData.vendor = VmEvcPropertyProvider.getEvcVendor(mode);
                evcData.key = mode.getKey();
                evcData.label = mode.getLabel();
                evcData.summary = mode.getSummary();
                evcData.guaranteedCPUFeatures = mode.getGuaranteedCPUFeatures();
                return evcData;
            }
        }
        evcData.vendor = VmEvcData.VmEvcVendor.NONE;
        evcData.key = VmEvcData.VmEvcVendor.NONE.toString();
        return evcData;
    }

    private static void setCurrentEvcGraphicsMode(VmEvcData evcData, String vmMinRequiredEVCModeKey, FeatureEVCMode[] supportedEvcGraphicsModes, FeatureMask[] evcGraphicsMasks) {
        if (ArrayUtils.isEmpty((Object[])supportedEvcGraphicsModes)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)vmMinRequiredEVCModeKey)) {
            for (FeatureEVCMode mode : supportedEvcGraphicsModes) {
                if (!mode.getKey().equals(vmMinRequiredEVCModeKey)) continue;
                evcData.graphicsEVCLabel = mode.getLabel();
                evcData.graphicsEVCSummary = mode.getSummary();
                evcData.graphicsEVCFeatures = evcGraphicsMasks == null ? new FeatureMask[]{} : evcGraphicsMasks;
                return;
            }
        }
    }

    private static void localizeMasks(FeatureMask[] masks) {
        if (!ArrayUtils.isEmpty((Object[])masks)) {
            for (FeatureMask mask : masks) {
                String localizationKey = mask.getKey().toLowerCase();
                String localizedMaskName = LocalizationUtil.getLocalizedMessage((String)localizationKey);
                if (localizedMaskName.equals(localizationKey)) {
                    return;
                }
                mask.setFeatureName(localizedMaskName);
            }
        }
    }

    private static VmEditEvcCpuData buildEditEvcCpuData(String vmMinRequiredEVCModeKey, EVCMode[] supportedEvcModes) {
        VmEditEvcCpuData editEvcData = new VmEditEvcCpuData();
        editEvcData.evcModesByVendor = new EnumMap(VmEvcData.VmEvcVendor.class);
        SupportedEvcMode disabledEvcMode = new SupportedEvcMode();
        disabledEvcMode.key = VmEvcData.VmEvcVendor.NONE.toString();
        disabledEvcMode.label = VmStringUtil.getString("vmEvc.disableEvc.optionLabel");
        ArrayList<SupportedEvcMode> disabledEvcModes = new ArrayList<SupportedEvcMode>(1);
        disabledEvcModes.add(disabledEvcMode);
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.NONE, disabledEvcModes);
        SupportedEvcMode customEvcMode = new SupportedEvcMode();
        customEvcMode.key = VmEvcData.VmEvcVendor.CUSTOM.toString();
        customEvcMode.label = VmStringUtil.getString("vmEvc.customEvc.optionLabel");
        ArrayList<SupportedEvcMode> customEvcModes = new ArrayList<SupportedEvcMode>(1);
        customEvcModes.add(customEvcMode);
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.CUSTOM, customEvcModes);
        ArrayList<SupportedEvcMode> amdEvcModes = new ArrayList<SupportedEvcMode>();
        ArrayList<SupportedEvcMode> intelEvcModes = new ArrayList<SupportedEvcMode>();
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.AMD, amdEvcModes);
        editEvcData.evcModesByVendor.put(VmEvcData.VmEvcVendor.INTEL, intelEvcModes);
        for (EVCMode mode : supportedEvcModes) {
            SupportedEvcMode supportedMode = new SupportedEvcMode();
            supportedMode.key = mode.getKey();
            supportedMode.label = mode.getLabel();
            supportedMode.summary = mode.getSummary();
            supportedMode.featureMasks = mode.getFeatureMask();
            VmEvcData.VmEvcVendor vendor = VmEvcPropertyProvider.getEvcVendor(mode);
            if (VmEvcData.VmEvcVendor.AMD.equals((Object)vendor)) {
                amdEvcModes.add(supportedMode);
                continue;
            }
            if (!VmEvcData.VmEvcVendor.INTEL.equals((Object)vendor)) continue;
            intelEvcModes.add(supportedMode);
        }
        VmEvcData currentEvcMode = VmEvcPropertyProvider.getCurrentEvcMode(vmMinRequiredEVCModeKey, supportedEvcModes);
        editEvcData.vendor = currentEvcMode.vendor;
        editEvcData.key = currentEvcMode.key;
        return editEvcData;
    }

    private static VmEditEvcGpuData buildEditEvcGraphicsData(String currentEvcGpuModeKey, FeatureEVCMode[] supportedEvcGpuModes) {
        VmEditEvcGpuData editData = new VmEditEvcGpuData();
        editData.gpuModes = new ArrayList();
        for (FeatureEVCMode supportedEvcGpuMode : supportedEvcGpuModes) {
            SupportedEvcMode supportedEvcMode = new SupportedEvcMode();
            supportedEvcMode.key = supportedEvcGpuMode.getKey();
            supportedEvcMode.label = supportedEvcGpuMode.getLabel();
            supportedEvcMode.summary = supportedEvcGpuMode.getSummary();
            supportedEvcMode.featureMasks = supportedEvcGpuMode.getMask();
            editData.gpuModes.add(supportedEvcMode);
        }
        editData.key = "custom".equals(currentEvcGpuModeKey) ? VmEvcData.VmEvcVendor.CUSTOM.toString() : (StringUtils.isEmpty((CharSequence)currentEvcGpuModeKey) ? VmEvcData.VmEvcVendor.NONE.toString() : currentEvcGpuModeKey);
        return editData;
    }

    private static VmEvcData.VmEvcVendor getEvcVendor(EVCMode mode) {
        if (CpuPackage.Vendor.amd.toString().equals(mode.getVendor())) {
            return VmEvcData.VmEvcVendor.AMD;
        }
        if (CpuPackage.Vendor.intel.toString().equals(mode.getVendor())) {
            return VmEvcData.VmEvcVendor.INTEL;
        }
        return VmEvcData.VmEvcVendor.NONE;
    }

    private static EVCMode[] getSupportedCpuEvcModes(String serverGuid, Capability capability) {
        return capability == null ? null : capability.getSupportedEVCMode();
    }

    private static FeatureEVCMode[] getSupportedEvcGraphicsModes(Capability capability) {
        return capability == null ? null : capability.getSupportedEVCGraphicsMode();
    }

    private static Capability getCapability(String serverGuid) {
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            return null;
        }
        ServiceInstance si = service.getServiceInstance();
        if (si == null) {
            _logger.error((Object)"Could not retrieve service instance");
            return null;
        }
        Capability caps = si.getCapability();
        if (caps == null) {
            _logger.error((Object)"Could not retrieve service instance capabilities");
            return null;
        }
        return caps;
    }
}

