/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.vm.ConfigOption;
import com.vmware.vim.binding.vim.vm.GuestOsDescriptor;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.h5.vm.data.GuestOsDescriptorData;
import com.vmware.vsphere.client.h5.vm.data.VmConfigOptionSpec;
import com.vmware.vsphere.client.h5.vm.model.provisioning.GuestOsVersionParams;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;

public class VmGuestOsVersionsPropertyProvider
implements PropertyProviderBean {
    private static final String OWNER_PROP = "owner";
    private static final String ENV_BROWSER_PROP = "environmentBrowser";
    private QueryService _queryService;

    public VmGuestOsVersionsPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @type(value="ResourcePool,VirtualApp")
    public VmConfigOptionSpec getVmConfigOptionByPool(ManagedObjectReference objRef, GuestOsVersionParams params) throws Exception {
        ResultSet res = this._queryService.select(new String[]{OWNER_PROP}).from(new String[]{objRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)objRef)}).fetch();
        ManagedObjectReference crRef = (ManagedObjectReference)((ResourceItem)res.getItems().get(0)).get(OWNER_PROP);
        res = this._queryService.select(new String[]{ENV_BROWSER_PROP}).from(new String[]{crRef.getType()}).where(new PropertyPredicate[]{new PropertyPredicate("@modelKey", PropertyPredicate.ComparisonOperator.EQUAL, (Object)crRef)}).fetch();
        ManagedObjectReference envBrowserRef = (ManagedObjectReference)((ResourceItem)res.getItems().get(0)).get(ENV_BROWSER_PROP);
        EnvironmentBrowser envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)envBrowserRef);
        ConfigOption configOption = envBrowser.queryConfigOption(params.key, params.host);
        VmConfigOptionSpec vmConfigOptionSpec = new VmConfigOptionSpec();
        if (!ArrayUtils.isEmpty((Object[])configOption.getGuestOSDescriptor())) {
            ArrayList<GuestOsDescriptorData> supportedForCreateDescs = new ArrayList<GuestOsDescriptorData>();
            int index = -1;
            for (GuestOsDescriptor gosDesc : configOption.getGuestOSDescriptor()) {
                boolean isDefaultGosDescriptor;
                boolean bl = isDefaultGosDescriptor = ++index == configOption.guestOSDefaultIndex;
                if (!gosDesc.getSupportedForCreate().booleanValue()) continue;
                supportedForCreateDescs.add(new GuestOsDescriptorData(gosDesc));
                if (!isDefaultGosDescriptor) continue;
                vmConfigOptionSpec.guestOSDefaultIndex = supportedForCreateDescs.size() - 1;
            }
            vmConfigOptionSpec.guestOSDescriptor = supportedForCreateDescs.toArray(new GuestOsDescriptorData[0]);
        }
        return vmConfigOptionSpec;
    }
}

