/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.vm.impl;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.model.PropertyProvider;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.EnvironmentBrowser;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.ConfigTarget;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.h5.vm.util.VmCryptoUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class VmPropertyProvider {
    private static final String CONNECTION_STATE_PROP = "runtime/connectionState";
    private static final String TEMPLATE_PROP = "config/template";
    private static final String DISABLED_METHODS_PROP = "disabledMethod";
    private static final String RELOCATE_TASK = "RelocateVM_Task";
    private static final String VM_PATH_NAME_PROP = "vmPathName";
    private static final String VM_DATASTORE_PROP = "datastore";
    private static final String NAME_PROP = "name";
    private static Pattern DATASTORE_NAME_PATTERN = Pattern.compile("^\\[(.*)\\]");
    private QueryService _queryService;

    public VmPropertyProvider(QueryServiceFactory queryServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
    }

    @PropertyProvider(value="VirtualMachine/isMoveFromDragAndDropAvailable")
    public Collection<Boolean> getIsMoveFromDragAndDropAvailable(Collection<ManagedObjectReference> vmRefs) {
        ArrayList<Boolean> result = new ArrayList<Boolean>(vmRefs.size());
        ResultSet resultSet = this._queryService.select(new String[]{"@modelKey", CONNECTION_STATE_PROP, TEMPLATE_PROP, DISABLED_METHODS_PROP}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vmRefs).fetch();
        HashMap<ManagedObjectReference, Boolean> propValueMap = new HashMap<ManagedObjectReference, Boolean>(resultSet.getItems().size());
        for (ResourceItem resourceItem : resultSet.getItems()) {
            Boolean isTemplate;
            VirtualMachine.ConnectionState connectionState = (VirtualMachine.ConnectionState)resourceItem.get(CONNECTION_STATE_PROP);
            boolean isConnected = VirtualMachine.ConnectionState.connected.equals((Object)connectionState);
            boolean isOperationAllowed = true;
            if (isConnected && Boolean.FALSE.equals(isTemplate = (Boolean)resourceItem.get(TEMPLATE_PROP))) {
                String[] disabledMethods = (String[])resourceItem.get(DISABLED_METHODS_PROP);
                isOperationAllowed = AuthorizationUtil.isOperationAllowed((String[])new String[]{RELOCATE_TASK}, (String[])disabledMethods);
            }
            propValueMap.put((ManagedObjectReference)resourceItem.getKey(), isConnected && isOperationAllowed);
        }
        for (ManagedObjectReference vmRef : vmRefs) {
            result.add((Boolean)propValueMap.get(vmRef));
        }
        return result;
    }

    @PropertyProvider(value="VirtualMachine/vmHomeDatastore")
    public Collection<ManagedObjectReference> getVmHomeDatastore(Collection<ManagedObjectReference> vmRefs) {
        ResultSet vmPropsResultSet = this._queryService.select(new String[]{VM_PATH_NAME_PROP, VM_DATASTORE_PROP}).from(new String[]{VirtualMachine.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, vmRefs).fetch();
        HashSet<ManagedObjectReference> allDatastores = new HashSet<ManagedObjectReference>();
        for (ResourceItem resourceItem : vmPropsResultSet.getItems()) {
            ManagedObjectReference[] dsRefs = (ManagedObjectReference[])resourceItem.get(VM_DATASTORE_PROP);
            if (dsRefs == null) continue;
            allDatastores.addAll(Arrays.asList(dsRefs));
        }
        HashMap<ManagedObjectReference, String> dsNames = new HashMap<ManagedObjectReference, String>();
        if (!allDatastores.isEmpty()) {
            ResultSet dsPropsResultSet = this._queryService.select(new String[]{NAME_PROP}).from(new String[]{Datastore.class.getSimpleName()}).where("@modelKey", PropertyPredicate.ComparisonOperator.IN, allDatastores).fetch();
            for (ResourceItem resourceItem : dsPropsResultSet.getItems()) {
                dsNames.put((ManagedObjectReference)resourceItem.getKey(), (String)resourceItem.get(NAME_PROP));
            }
        }
        ArrayList<ManagedObjectReference> result = new ArrayList<ManagedObjectReference>();
        for (ResourceItem resourceItem : vmPropsResultSet.getItems()) {
            Matcher matcher;
            ManagedObjectReference vmHomeDsRef = null;
            String vmPathName = (String)resourceItem.get(VM_PATH_NAME_PROP);
            if (vmPathName != null && (matcher = DATASTORE_NAME_PATTERN.matcher(vmPathName)).find()) {
                String vmHomeDsName = matcher.group(1);
                ManagedObjectReference[] vmDsRefs = (ManagedObjectReference[])resourceItem.get(VM_DATASTORE_PROP);
                if (vmDsRefs != null && vmHomeDsName != null) {
                    for (ManagedObjectReference dsRef : vmDsRefs) {
                        if (!vmHomeDsName.equals(dsNames.get(dsRef))) continue;
                        vmHomeDsRef = dsRef;
                        break;
                    }
                }
            }
            result.add(vmHomeDsRef);
        }
        return result;
    }

    @PropertyProvider(value="VirtualMachine/isEncryptedWithTrustedProvider")
    public Collection<Boolean> getIsEncryptedWithTrustedProvider(Collection<ManagedObjectReference> vmRefs) throws Exception {
        ArrayList<Boolean> result = new ArrayList<Boolean>(vmRefs.size());
        for (ManagedObjectReference vmRef : vmRefs) {
            CryptoManagerKmip cryptoManager = VmCryptoUtil.getCryptoManager(vmRef);
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            ConfigInfo vmConfigInfo = vm.getConfig();
            if (vmConfigInfo.getKeyId() == null) {
                result.add(false);
                continue;
            }
            boolean isVc68orLater = VcServiceUtil.is68VcOrLaterByServerGuid((String)vmRef.getServerGuid(), (boolean)true);
            boolean isEncryptedWithTrustedProvider = isVc68orLater && VmCryptoUtil.isTrustedKeyProvider(vmConfigInfo.getKeyId().getProviderId(), cryptoManager);
            result.add(isEncryptedWithTrustedProvider);
        }
        return result;
    }

    @PropertyProvider(value="VirtualMachine/encryptionProviderManagementType")
    public Collection<String> getEncryptionProviderManagementType(Collection<ManagedObjectReference> vmRefs) throws Exception {
        ArrayList<String> result = new ArrayList<String>(vmRefs.size());
        for (ManagedObjectReference vmRef : vmRefs) {
            CryptoManagerKmip cryptoManager = VmCryptoUtil.getCryptoManager(vmRef);
            VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
            ConfigInfo vmConfigInfo = vm.getConfig();
            if (vmConfigInfo.getKeyId() == null) {
                result.add(null);
                continue;
            }
            boolean isVc68orLater = VcServiceUtil.is68VcOrLaterByServerGuid((String)vmRef.getServerGuid(), (boolean)true);
            if (!isVc68orLater) {
                result.add(KmipClusterInfo.KmsManagementType.vCenter.toString());
                continue;
            }
            String encryptionProviderManagementType = VmCryptoUtil.getKeyProviderManagementType(vmConfigInfo.getKeyId().getProviderId(), cryptoManager);
            result.add(encryptionProviderManagementType);
        }
        return result;
    }

    @PropertyProvider(value="VirtualMachine/configTargetDevices")
    public Collection<ConfigTarget> getConfigTargetDevices(Collection<ManagedObjectReference> vmRefs) throws Exception {
        Validate.notEmpty(vmRefs);
        if (vmRefs.size() > 1) {
            throw new IllegalArgumentException("VirtualMachine/configTargetDevices is not supported for multiple vms");
        }
        ManagedObjectReference vmRef = vmRefs.iterator().next();
        ConfigTarget configTarget = this.getConfigTarget(vmRef, new EnvironmentBrowser.ConfigTargetQuerySpec(Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false)));
        return Arrays.asList(configTarget);
    }

    @PropertyProvider(value="VirtualMachine/configTargetDatastores")
    public Collection<ConfigTarget> getConfigTargetDatastores(Collection<ManagedObjectReference> vmRefs) throws Exception {
        Validate.notEmpty(vmRefs);
        if (vmRefs.size() > 1) {
            throw new IllegalArgumentException("VirtualMachine/configTargetDatastores is not supported for multiple vms");
        }
        ManagedObjectReference vmRef = vmRefs.iterator().next();
        ConfigTarget configTarget = this.getConfigTarget(vmRef, new EnvironmentBrowser.ConfigTargetQuerySpec(Boolean.valueOf(true), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false), Boolean.valueOf(false)));
        return Arrays.asList(configTarget);
    }

    @PropertyProvider(value="VirtualMachine/datastoreBrowser")
    public Collection<ManagedObjectReference> getDatastoreBrowser(Collection<ManagedObjectReference> vmRefs) throws Exception {
        Validate.notEmpty(vmRefs);
        if (vmRefs.size() > 1) {
            throw new IllegalArgumentException("VirtualMachine/datastoreBrowser is not supported for multiple vms");
        }
        ManagedObjectReference vmRef = vmRefs.iterator().next();
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        ManagedObjectReference evnRef = vm.getEnvironmentBrowser();
        EnvironmentBrowser envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)evnRef);
        ManagedObjectReference datastoreBrowser = envBrowser.getDatastoreBrowser();
        return Arrays.asList(datastoreBrowser);
    }

    private ConfigTarget getConfigTarget(ManagedObjectReference vmRef, EnvironmentBrowser.ConfigTargetQuerySpec spec) throws Exception {
        VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmRef);
        ManagedObjectReference evnRef = vm.getEnvironmentBrowser();
        EnvironmentBrowser envBrowser = (EnvironmentBrowser)ManagedObjectUtil.getManagedObject((ManagedObjectReference)evnRef);
        ConfigTarget configTarget = envBrowser.queryConfigTargetSpec(null, spec);
        return configTarget;
    }
}

