/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.computepolicy;

import com.vmware.cis.data.api.PropertyPredicate;
import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.api.ResourceItem;
import com.vmware.cis.data.api.ResultSet;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vcenter.compute.Policies;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vsphere.client.h5.computepolicy.spec.TagUsageSpec;
import java.util.ArrayList;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ComputePolicyMutationProvider
implements MutationProvider {
    private static final Log _logger = LogFactory.getLog(ComputePolicyMutationProvider.class);
    private final Policies _policyService;
    private final QueryService _queryService;

    public ComputePolicyMutationProvider(Policies policyService, QueryServiceFactory queryServiceFactory) {
        this._policyService = policyService;
        this._queryService = queryServiceFactory.getQueryService();
    }

    public ValidationResult validate(TagUsageSpec spec) {
        ResultSet resultSet;
        Validate.notNull((Object)spec);
        ValidationResult result = new ValidationResult();
        if (spec.objectType == null) {
            resultSet = this._queryService.select(new String[]{"policy_name"}).from(new String[]{"com.vmware.vcenter.compute.tag_usage"}).where("tag_identifier", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.tagId).fetch();
        } else {
            String tagIdProp = "VirtualMachine".equals(spec.objectType) ? "vm_tag_identifier" : "host_tag_identifier";
            resultSet = this._queryService.select(new String[]{"policy_name", "serverGuid"}).from(new String[]{"com.vmware.vcenter.compute.policies"}).where(new PropertyPredicate[]{new PropertyPredicate(tagIdProp, PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.tagId), new PropertyPredicate("serverGuid", PropertyPredicate.ComparisonOperator.EQUAL, (Object)spec.objectVcServer)}).fetch();
        }
        ArrayList<String> policyNames = new ArrayList<String>(resultSet.getItems().size());
        for (ResourceItem resultItem : resultSet.getItems()) {
            policyNames.add((String)resultItem.get("policy_name"));
        }
        result.result = policyNames;
        return result;
    }
}

