/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.h5.spbm.impl;

import com.vmware.cis.data.api.QueryService;
import com.vmware.cis.data.query.util.QueryServiceFactory;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.DerivedPropertyData;
import com.vmware.vise.data.query.DerivedPropertyInfo;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.data.query.derivedproperty.DerivedPropertyProviderAdapter;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.security.AuthorizationUtil;
import com.vmware.vsphere.client.commonservice.util.QueryServiceUtil;
import com.vmware.vsphere.client.spbm.PbmServiceFactory;
import com.vmware.vsphere.client.spbm.util.PbmUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SpbmPropertyProviderAdapter
implements DerivedPropertyProviderAdapter {
    private static final String VC_GRANTED_PRIVILEGES = "vcGrantedPrivileges";
    private static final String PROFILE_MISMATCH = "vmSpbmProfileMismatch";
    private static final String IS_SPBM_POLICY_PERMISSION_SUPPORTED = "isSpbmPolicyPermissionSupported";
    private static final String MANAGE_VM_PROFILE = "isManageVmStorageProfilesActionAvailable";
    private static final String REAPPLY_VM_PROFILE = "isReapplyActionAvailable";
    private static final String VIEW_PRIVILEGE = "StorageProfile.View";
    private static final String UPDATE_PRIVILEGE = "StorageProfile.Update";
    private static final String APPLY_PRIVILEGE = "StorageProfile.Apply";
    private final QueryService _queryService;
    private final PbmServiceFactory _pbmServiceFactory;
    private static final Log _logger = LogFactory.getLog(SpbmPropertyProviderAdapter.class);

    public SpbmPropertyProviderAdapter(DataServiceExtensionRegistry registry, QueryServiceFactory queryServiceFactory, PbmServiceFactory pbmServiceFactory) {
        this._queryService = queryServiceFactory.getQueryService();
        this._pbmServiceFactory = pbmServiceFactory;
        registry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = VirtualMachine.class.getSimpleName();
        ti.properties = new String[]{MANAGE_VM_PROFILE, REAPPLY_VM_PROFILE};
        ti.derivedProperties = new DerivedPropertyInfo[]{SpbmPropertyProviderAdapter.newDerivedPropertyInfo(MANAGE_VM_PROFILE, new String[]{VC_GRANTED_PRIVILEGES, IS_SPBM_POLICY_PERMISSION_SUPPORTED}), SpbmPropertyProviderAdapter.newDerivedPropertyInfo(REAPPLY_VM_PROFILE, new String[]{VC_GRANTED_PRIVILEGES, IS_SPBM_POLICY_PERMISSION_SUPPORTED})};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Validate.notNull((Object)propertyRequest);
        Object[] objects = propertyRequest.objects;
        Set<String> requestedProperties = this.getDistinctRequestedProperties(propertyRequest);
        ResultSet resultSet = new ResultSet();
        ArrayList<ResultItem> resultItems = new ArrayList<ResultItem>();
        DerivedPropertyData derivedPropertyData = propertyRequest.derivedPropertyData;
        Map sourcePropertyValues = derivedPropertyData.getSourcePropertyValuesByObject();
        boolean areOnDistinctVcs = this.areOnDistinctVcs(objects);
        Map<ManagedObjectReference, Boolean> reapplyActionAvailability = null;
        if (requestedProperties.contains(REAPPLY_VM_PROFILE)) {
            reapplyActionAvailability = this.computeReapplyActionAvailability(sourcePropertyValues);
        }
        for (Object resourceObject : objects) {
            Map dsPropertyValues = (Map)sourcePropertyValues.get(resourceObject);
            if (dsPropertyValues == null) continue;
            ResultItem resultItem = new ResultItem();
            resultItem.resourceObject = resourceObject;
            resultItem.properties = this.computePropertyValues(requestedProperties, dsPropertyValues, resourceObject, areOnDistinctVcs, reapplyActionAvailability);
            resultItems.add(resultItem);
        }
        resultSet.items = resultItems.toArray(new ResultItem[0]);
        return resultSet;
    }

    private Set<String> getDistinctRequestedProperties(PropertyRequestSpec propertyRequest) {
        HashSet<String> requestedProperties = new HashSet<String>();
        for (PropertySpec propSpec : propertyRequest.properties) {
            requestedProperties.addAll(Arrays.asList(propSpec.propertyNames));
        }
        return requestedProperties;
    }

    private PropertyValue[] computePropertyValues(Set<String> requestedProperties, Map<String, Object> dsPropertyValues, Object resourceObject, boolean onDistinctVcs, Map<ManagedObjectReference, Boolean> reapplyActionAvailability) {
        ArrayList<PropertyValue> result = new ArrayList<PropertyValue>();
        if (requestedProperties.contains(MANAGE_VM_PROFILE)) {
            result.add(this.canManage(resourceObject, dsPropertyValues, onDistinctVcs));
        }
        if (requestedProperties.contains(REAPPLY_VM_PROFILE)) {
            result.add(this.canReapply(resourceObject, reapplyActionAvailability));
        }
        return result.toArray(new PropertyValue[0]);
    }

    private PropertyValue canManage(Object resourceObject, Map<String, Object> dsPropertyValues, boolean onDistinctVcs) {
        boolean canManageVmStorageProfiles = false;
        if (!onDistinctVcs) {
            String vcServiceGuid = ((ManagedObjectReference)resourceObject).getServerGuid();
            Boolean isSpbmPolicyPermissionSupported = BooleanUtils.isTrue((Boolean)((Boolean)dsPropertyValues.get(IS_SPBM_POLICY_PERMISSION_SUPPORTED)));
            String[] grantedVcPrivileges = (String[])dsPropertyValues.get(VC_GRANTED_PRIVILEGES);
            canManageVmStorageProfiles = PbmUtil.canViewSpbmStorageProfiles((String)vcServiceGuid, (Boolean)isSpbmPolicyPermissionSupported, (String[])grantedVcPrivileges, (PbmServiceFactory)this._pbmServiceFactory);
        }
        return this.createPropValue(MANAGE_VM_PROFILE, canManageVmStorageProfiles, resourceObject);
    }

    private PropertyValue canReapply(Object resourceObject, Map<ManagedObjectReference, Boolean> reapplyActionAvailability) {
        boolean isActionAvailable = Boolean.TRUE.equals(reapplyActionAvailability.get((ManagedObjectReference)resourceObject));
        return this.createPropValue(REAPPLY_VM_PROFILE, isActionAvailable, resourceObject);
    }

    private Map<ManagedObjectReference, Boolean> computeReapplyActionAvailability(Map<Object, Map<String, Object>> sourcePropertyValues) {
        Map<ManagedObjectReference, Map<String, Object>> vmsMismatch;
        HashMap<ManagedObjectReference, Boolean> result = new HashMap<ManagedObjectReference, Boolean>(sourcePropertyValues.size());
        boolean arePrivilegesGranted = true;
        for (Map.Entry<Object, Map<String, Object>> sourcePropertyValue : sourcePropertyValues.entrySet()) {
            arePrivilegesGranted = arePrivilegesGranted && this.hasVcLevelReapplyPrivileges(sourcePropertyValue.getValue());
            result.put((ManagedObjectReference)sourcePropertyValue.getKey(), false);
        }
        if (arePrivilegesGranted && (vmsMismatch = this.retrieveVmsMismatch(result.keySet())) != null) {
            for (Map.Entry<ManagedObjectReference, Map<String, Object>> entry : vmsMismatch.entrySet()) {
                Boolean isOutOfDate = (Boolean)entry.getValue().get(PROFILE_MISMATCH);
                result.put(entry.getKey(), isOutOfDate);
            }
        }
        return result;
    }

    private boolean hasVcLevelReapplyPrivileges(Map<String, Object> sourcePropertyValue) {
        Boolean isSpbmPolicyPermissionSupported = (Boolean)sourcePropertyValue.get(IS_SPBM_POLICY_PERMISSION_SUPPORTED);
        String[] grantedVcPrivileges = (String[])sourcePropertyValue.get(VC_GRANTED_PRIVILEGES);
        if (BooleanUtils.isTrue((Boolean)isSpbmPolicyPermissionSupported)) {
            return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{VIEW_PRIVILEGE, UPDATE_PRIVILEGE}, (String[])grantedVcPrivileges) || AuthorizationUtil.isPrivilegeGranted((String[])new String[]{VIEW_PRIVILEGE, APPLY_PRIVILEGE}, (String[])grantedVcPrivileges);
        }
        return AuthorizationUtil.isPrivilegeGranted((String[])new String[]{VIEW_PRIVILEGE, UPDATE_PRIVILEGE}, (String[])grantedVcPrivileges);
    }

    private Map<ManagedObjectReference, Map<String, Object>> retrieveVmsMismatch(Set<ManagedObjectReference> vms) {
        try {
            return QueryServiceUtil.queryPropertiesForMultipleObjects((QueryService)this._queryService, vms, (String[])new String[]{PROFILE_MISMATCH});
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Failed to retrieve \"%s\" property", PROFILE_MISMATCH), (Throwable)e);
            return null;
        }
    }

    private static DerivedPropertyInfo newDerivedPropertyInfo(String propertyName, String[] sourcePropertyNames) {
        DerivedPropertyInfo derivedPropertyInfo = new DerivedPropertyInfo();
        derivedPropertyInfo.propertyName = propertyName;
        derivedPropertyInfo.sourcePropertyNames = sourcePropertyNames;
        return derivedPropertyInfo;
    }

    private PropertyValue createPropValue(String name, Object value, Object provider) {
        PropertyValue propValue = new PropertyValue();
        propValue.propertyName = name;
        propValue.value = value;
        propValue.resourceObject = provider;
        return propValue;
    }

    private boolean areOnDistinctVcs(Object[] vms) {
        HashSet<ManagedObjectReference> vmVcs = new HashSet<ManagedObjectReference>();
        for (Object vm : vms) {
            ManagedObjectReference vmRef = (ManagedObjectReference)vm;
            vmVcs.add(ManagedObjectUtil.getRootFolder((String)vmRef.getServerGuid()));
        }
        return vmVcs.size() > 1;
    }
}

