/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.host.CacheConfigurationManager;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiagnosticSystem;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.I18nUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.storage.StorageDataService;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageDataServiceImpl
implements StorageDataService {
    private DataService _dataService;
    private static final Log _logger = LogFactory.getLog(StorageDataServiceImpl.class);
    private static final String HOST_STORAGE_SYSTEM = "storageSystem";
    private static final String HOST_STORAGE_SYSTEM_TYPE = "StorageSystem";
    private static final String HOST_STORAGE_DEVICE_INFO = "storageDeviceInfo";
    private static final String HOST_STORAGE_MULTIPATH_INFO = "multipathStateInfo";
    private static final String HOST_STORAGE_MOUNT_INFO = "fileSystemVolumeInfo.mountInfo";
    private static final String HOST_DATASTORE_SYSTEM = "datastoreSystem";
    private static final String HOST_CACHE_CONFIG_MANAGER = "cacheConfigurationManager";
    private static final String HOST_DIAGNOSTIC_SYSTEM = "diagnosticSystem";
    private static final String HOST_NETWORK_INFO = "config.network";
    private static final String HOST_FIREWALL_SYSTEM = "firewallSystem";
    private static final String HOST_FIREWALL_SYSTEM_TYPE = "FirewallSystem";
    private static final String HOST_FIREWALL_INFO = "firewallInfo";

    public StorageDataServiceImpl(DataService dataService) {
        this._dataService = dataService;
    }

    public StorageSystem getHostStorageSystem(ManagedObjectReference hostRef) throws Exception {
        return (StorageSystem)this.getHostProperty(hostRef, HOST_STORAGE_SYSTEM);
    }

    public StorageDeviceInfo getHostStorageDeviceInfo(ManagedObjectReference hostRef) throws Exception {
        Object[] result = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)hostRef, (String)HOST_STORAGE_SYSTEM, (String)HOST_STORAGE_SYSTEM_TYPE, (String)HOST_STORAGE_DEVICE_INFO);
        if (ArrayUtils.isEmpty((Object[])result) || ((PropertyValue)result[0]).value == null || !(((PropertyValue)result[0]).value instanceof StorageDeviceInfo)) {
            return null;
        }
        StorageDeviceInfo deviceInfo = (StorageDeviceInfo)((PropertyValue)result[0]).value;
        return deviceInfo;
    }

    public MultipathStateInfo getHostMultipathStateInfo(ManagedObjectReference hostRef) throws Exception {
        Object[] result = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)hostRef, (String)HOST_STORAGE_SYSTEM, (String)HOST_STORAGE_SYSTEM_TYPE, (String)HOST_STORAGE_MULTIPATH_INFO);
        if (ArrayUtils.isEmpty((Object[])result) || ((PropertyValue)result[0]).value == null || !(((PropertyValue)result[0]).value instanceof MultipathStateInfo)) {
            return null;
        }
        MultipathStateInfo multipathStateInfo = (MultipathStateInfo)((PropertyValue)result[0]).value;
        return multipathStateInfo;
    }

    public StorageDataService.StorageDeviceAndMultipathStateInfoData getStorageDeviceAndMultipathStateInfoData(ManagedObjectReference hostRef) throws Exception {
        PropertyValue[] result = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)hostRef, (String)HOST_STORAGE_SYSTEM, (String)HOST_STORAGE_SYSTEM_TYPE, (String[])new String[]{HOST_STORAGE_DEVICE_INFO, HOST_STORAGE_MULTIPATH_INFO});
        if (result != null && result.length > 0) {
            StorageDataService.StorageDeviceAndMultipathStateInfoData hostStorageData = new StorageDataService.StorageDeviceAndMultipathStateInfoData();
            for (PropertyValue propertyValue : result) {
                if (HOST_STORAGE_DEVICE_INFO.equals(propertyValue.propertyName) && propertyValue.value instanceof StorageDeviceInfo) {
                    hostStorageData.storageDeviceInfo = (StorageDeviceInfo)propertyValue.value;
                    continue;
                }
                if (!HOST_STORAGE_MULTIPATH_INFO.equals(propertyValue.propertyName) || !(propertyValue.value instanceof MultipathStateInfo)) continue;
                hostStorageData.multipathStateInfo = (MultipathStateInfo)propertyValue.value;
            }
            return hostStorageData;
        }
        return null;
    }

    public FileSystemMountInfo[] getHostMountInfo(ManagedObjectReference hostRef) throws Exception {
        Object[] result = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)hostRef, (String)HOST_STORAGE_SYSTEM, (String)HOST_STORAGE_SYSTEM_TYPE, (String)HOST_STORAGE_MOUNT_INFO);
        if (ArrayUtils.isEmpty((Object[])result) || ((PropertyValue)result[0]).value == null || !(((PropertyValue)result[0]).value instanceof FileSystemMountInfo[])) {
            return null;
        }
        FileSystemMountInfo[] mountInfo = (FileSystemMountInfo[])((PropertyValue)result[0]).value;
        return mountInfo;
    }

    public HostBusAdapter getHostBusAdapterByKey(ManagedObjectReference hostRef, String adapterKey, StorageDeviceInfo sdi) throws Exception {
        if (hostRef == null) {
            String errorText = I18nUtil.getLocalizedString((String)"error.invalidHost", (String[])new String[0]);
            _logger.error((Object)"Host is null!");
            throw new IllegalArgumentException(errorText);
        }
        if (sdi == null) {
            sdi = this.getHostStorageDeviceInfo(hostRef);
        }
        for (int i = 0; i < sdi.hostBusAdapter.length; ++i) {
            HostBusAdapter hba = sdi.hostBusAdapter[i];
            if (!hba.key.equals(adapterKey)) continue;
            _logger.debug((Object)("Found host bus adapter with key:[" + hba.key + "]"));
            return hba;
        }
        _logger.error((Object)("Could not find host bus adapter with key:[" + adapterKey + "]"));
        return null;
    }

    public DatastoreSystem getHostDatastoreSystem(ManagedObjectReference hostRef) throws Exception {
        return (DatastoreSystem)this.getHostProperty(hostRef, HOST_DATASTORE_SYSTEM);
    }

    public CacheConfigurationManager getHostCacheConfigurationManager(ManagedObjectReference hostRef) throws Exception {
        return (CacheConfigurationManager)this.getHostProperty(hostRef, HOST_CACHE_CONFIG_MANAGER);
    }

    public DiagnosticSystem getHostDiagnosticSystem(ManagedObjectReference hostRef) throws Exception {
        return (DiagnosticSystem)this.getHostProperty(hostRef, HOST_DIAGNOSTIC_SYSTEM);
    }

    public NetworkInfo getHostNetworkInfo(ManagedObjectReference hostRef) throws Exception {
        NetworkInfo networkInfo = (NetworkInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_NETWORK_INFO);
        if (networkInfo == null) {
            return null;
        }
        return networkInfo;
    }

    public FirewallSystem getHostFirewallSystem(ManagedObjectReference hostRef) throws Exception {
        return (FirewallSystem)this.getHostProperty(hostRef, HOST_FIREWALL_SYSTEM);
    }

    public FirewallInfo getHostFirewallInfo(ManagedObjectReference hostRef) throws Exception {
        Object[] result = QueryUtil.getPropertyForRelatedObjects((DataService)this._dataService, (Object)hostRef, (String)HOST_FIREWALL_SYSTEM, (String)HOST_FIREWALL_SYSTEM_TYPE, (String)HOST_FIREWALL_INFO);
        if (ArrayUtils.isEmpty((Object[])result) || ((PropertyValue)result[0]).value == null || !(((PropertyValue)result[0]).value instanceof FirewallInfo)) {
            return null;
        }
        FirewallInfo firewallInfo = (FirewallInfo)((PropertyValue)result[0]).value;
        return firewallInfo;
    }

    private <Type extends ManagedObject> Type getHostProperty(ManagedObjectReference objRef, String property) throws Exception {
        ManagedObjectReference result = (ManagedObjectReference)QueryUtil.getProperty((DataService)this._dataService, (Object)objRef, (String)property);
        if (result == null) {
            return null;
        }
        return (Type)ManagedObjectUtil.getManagedObject((ManagedObjectReference)result);
    }
}

