/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.AboutInfo;
import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.fault.ResourceInUse;
import com.vmware.vim.binding.vim.host.CacheConfigurationManager;
import com.vmware.vim.binding.vim.host.ConfigInfo;
import com.vmware.vim.binding.vim.host.ConfigManager;
import com.vmware.vim.binding.vim.host.DatastoreSystem;
import com.vmware.vim.binding.vim.host.DiagnosticPartition;
import com.vmware.vim.binding.vim.host.DiagnosticSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.FirewallInfo;
import com.vmware.vim.binding.vim.host.FirewallSystem;
import com.vmware.vim.binding.vim.host.HostBusAdapter;
import com.vmware.vim.binding.vim.host.InternetScsiHba;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.NasDatastoreInfo;
import com.vmware.vim.binding.vim.host.NetCapabilities;
import com.vmware.vim.binding.vim.host.NetworkInfo;
import com.vmware.vim.binding.vim.host.PortGroup;
import com.vmware.vim.binding.vim.host.Ruleset;
import com.vmware.vim.binding.vim.host.RuntimeInfo;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.VFlashManager;
import com.vmware.vim.binding.vim.host.VirtualNic;
import com.vmware.vim.binding.vim.host.VirtualSwitch;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.core.model.mutation.OperationEffect;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.util.session.SessionUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.storage.DatastoreRemovalSpec;
import com.vmware.vsphere.client.storage.DiagnosticPartitionCreateSpec;
import com.vmware.vsphere.client.storage.DiagnosticPartitionType;
import com.vmware.vsphere.client.storage.FormatHostDiskSpec;
import com.vmware.vsphere.client.storage.HppMultipathLunPolicySpec;
import com.vmware.vsphere.client.storage.LightDiskLedSpec;
import com.vmware.vsphere.client.storage.MultipathLunPolicySpec;
import com.vmware.vsphere.client.storage.NfsClearCredentialsSpec;
import com.vmware.vsphere.client.storage.NfsDatastoreRemovalSpec;
import com.vmware.vsphere.client.storage.NfsEditCredentialsSpec;
import com.vmware.vsphere.client.storage.StorageDataService;
import com.vmware.vsphere.client.storage.StorageSystemRefreshSpec;
import com.vmware.vsphere.client.storage.TagDiskAsLocalSpec;
import com.vmware.vsphere.client.storage.TagDiskAsSsdSpec;
import com.vmware.vsphere.client.storage.VFlashAddSpec;
import com.vmware.vsphere.client.storage.VFlashRemovalSpec;
import com.vmware.vsphere.client.storage.adapters.FcoeStorageAdapterCreationSpec;
import com.vmware.vsphere.client.storage.adapters.FcoeStorageAdapterRemovalSpec;
import com.vmware.vsphere.client.storage.adapters.InternetScsiStorageAdapterActivationSpec;
import com.vmware.vsphere.client.storage.adapters.InternetScsiStorageAdapterAuthenticationUpdateSpec;
import com.vmware.vsphere.client.storage.adapters.InternetScsiStorageAdapterIpConfigurationUpdateSpec;
import com.vmware.vsphere.client.storage.adapters.InternetScsiStorageAdapterSendTargetsSpec;
import com.vmware.vsphere.client.storage.adapters.InternetScsiStorageAdapterSettingsUpdateSpec;
import com.vmware.vsphere.client.storage.adapters.InternetScsiStorageAdapterStaticTargetsSpec;
import com.vmware.vsphere.client.storage.adapters.PortGroupType;
import com.vmware.vsphere.client.storage.adapters.ScsiLunDisplayNameUpdateSpec;
import com.vmware.vsphere.client.storage.adapters.SoftwareIScsiActivationValidationResult;
import com.vmware.vsphere.client.storage.adapters.StorageAdapterRescanSpec;
import com.vmware.vsphere.client.storage.adapters.StorageDeviceMountSpec;
import com.vmware.vsphere.client.storage.adapters.StorageDevicePerenniallyReservedSpec;
import com.vmware.vsphere.client.storage.adapters.StoragePathEnableSpec;
import com.vmware.vsphere.client.storage.i18n.I18nUtil;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import com.vmware.vsphere.client.storage.vvol.RemoveVvolDatastoreSpec;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StorageMutationProvider
implements MutationProvider {
    private static final String RESOURCE_BUNDLE_NAME = "StorageService";
    private static final Log _logger = LogFactory.getLog(StorageMutationProvider.class);
    private static final String INFO_PROP = "info";
    private static final String HOST_MOUNT_PROP = "hostMount";
    private static final String SW_ISCSI_RULE_KEY = "iSCSI";
    private final DataService _dataService;
    private final TaskMonitor _taskMonitor;
    private final StorageDataService _storageDataService;
    private final ThreadPoolExecutor _threadPoolExecutor;

    public StorageMutationProvider(DataService dataService, TaskMonitor taskMonitor, StorageDataService storageDataService, ThreadPoolExecutor threadPoolExecutor) {
        this._dataService = dataService;
        this._taskMonitor = taskMonitor;
        this._storageDataService = storageDataService;
        this._threadPoolExecutor = threadPoolExecutor;
    }

    public OperationResult remove(ManagedObjectReference host, NfsDatastoreRemovalSpec spec) {
        ManagedObjectReference[] hosts = new ManagedObjectReference[]{host};
        OperationResult[] opResults = this.removeOnMultiEntity(hosts, spec);
        return opResults[0];
    }

    public OperationResult[] removeOnMultiEntity(ManagedObjectReference[] hosts, NfsDatastoreRemovalSpec spec) {
        return this.unmountDatastore(hosts, spec);
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hosts, NfsDatastoreRemovalSpec spec) {
        return this.unmountDatastore(hosts, spec);
    }

    private OperationResult[] unmountDatastore(ManagedObjectReference[] hosts, NfsDatastoreRemovalSpec spec) {
        OperationResult[] opResults = new OperationResult[1];
        if (hosts == null || hosts.length == 0) {
            String errorText = this.getLocalizedString("error.invalidHostArray");
            _logger.error((Object)errorText);
            opResults[0] = new OperationResult();
            opResults[0].error = new MethodFault(errorText);
            return opResults;
        }
        if (spec == null || spec.datastoreToRemove == null) {
            String errorText = this.getLocalizedString("error.datastoreRemoveSpecInvalid");
            _logger.error((Object)errorText);
            opResults[0] = new OperationResult();
            opResults[0].error = new MethodFault(errorText);
            return opResults;
        }
        Datastore.Info dsInfo = null;
        try {
            dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)spec.datastoreToRemove, (String)INFO_PROP);
        }
        catch (Exception e) {
            _logger.error((Object)e);
            opResults[0] = new OperationResult();
            opResults[0].error = MixedUtil.getMethodFault((Throwable)e);
            return opResults;
        }
        if (dsInfo == null || !(dsInfo instanceof NasDatastoreInfo)) {
            String errorText = this.getLocalizedString("error.dsIsNotNAS");
            _logger.error((Object)errorText);
            opResults[0] = new OperationResult();
            opResults[0].error = new MethodFault(errorText);
            return opResults;
        }
        opResults = new OperationResult[hosts.length];
        for (int i = 0; i < hosts.length; ++i) {
            opResults[i] = new OperationResult();
            opResults[i].entity = i == 0 ? spec.datastoreToRemove : null;
            try {
                this.removeInternal(spec.datastoreToRemove, dsInfo, hosts[i]);
                continue;
            }
            catch (Exception e) {
                _logger.error((Object)e);
                opResults[i].error = MixedUtil.getMethodFault((Throwable)e);
            }
        }
        return opResults;
    }

    public OperationResult remove(ManagedObjectReference dsRef, DatastoreRemovalSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = dsRef;
        try {
            Datastore ds = (Datastore)ManagedObjectUtil.getManagedObject((ManagedObjectReference)dsRef);
            if (ds == null) {
                String errorMessage = this.getLocalizedString("error.invalidDatastore");
                throw new IllegalArgumentException(errorMessage);
            }
            PropertyValue[] dsProps = QueryUtil.getProperties((DataService)this._dataService, (Object)dsRef, (String[])new String[]{INFO_PROP, HOST_MOUNT_PROP});
            Datastore.HostMount[] hostMounts = null;
            Datastore.Info dsInfo = null;
            if (dsProps != null && dsProps[0] != null && dsProps[1] != null) {
                if (INFO_PROP.equals(dsProps[0].propertyName)) {
                    dsInfo = (Datastore.Info)dsProps[0].value;
                    hostMounts = (Datastore.HostMount[])dsProps[1].value;
                } else {
                    dsInfo = (Datastore.Info)dsProps[1].value;
                    hostMounts = (Datastore.HostMount[])dsProps[0].value;
                }
            } else {
                _logger.error((Object)("Could not retrieve info and/or hostMount for datastore: [" + dsRef.getServerGuid() + "]"));
                String errorMessage = this.getLocalizedString("error.failedToRetrieveDatastoreInfo");
                throw new IllegalArgumentException(errorMessage);
            }
            if (StorageUtil.isForceMountedVMFSDatastore((Datastore.Info)dsInfo).booleanValue()) {
                for (Datastore.HostMount hostMount : hostMounts) {
                    if (hostMount == null) continue;
                    this.removeInternal(dsRef, dsInfo, hostMount.key);
                }
            } else if (dsInfo instanceof NasDatastoreInfo) {
                ManagedObjectReference selectedCtxObject = spec.selectedContextObject;
                if (selectedCtxObject.getType().equals(HostSystem.class.getSimpleName())) {
                    this.removeInternal(dsRef, dsInfo, selectedCtxObject);
                } else {
                    PropertyValue[] hostsProps = QueryUtil.getPropertiesForRelatedObjects((DataService)this._dataService, (Object)dsRef, (String)"hostKey", (String)"HostSystem", (String[])new String[]{"runtime.connectionState"});
                    ArrayList<MethodFault> exceptions = null;
                    for (PropertyValue hostProp : hostsProps) {
                        HostSystem.ConnectionState hostConnectionState = (HostSystem.ConnectionState)hostProp.value;
                        if (!hostConnectionState.equals((Object)HostSystem.ConnectionState.connected)) continue;
                        try {
                            this.removeInternal(dsRef, dsInfo, (ManagedObjectReference)hostProp.resourceObject);
                        }
                        catch (Exception ex) {
                            if (exceptions == null) {
                                exceptions = new ArrayList<MethodFault>();
                            }
                            exceptions.add(MixedUtil.getMethodFault((Throwable)ex));
                        }
                    }
                    if (exceptions != null) {
                        opResult.error = MixedUtil.constructCompositeException(exceptions);
                    }
                }
            } else {
                if (hostMounts == null || hostMounts.length == 0) {
                    String errorMessage = this.getLocalizedString("error.invalidHostMount");
                    throw new IllegalArgumentException(errorMessage);
                }
                Boolean foundValidHost = false;
                for (Datastore.HostMount hostMount : hostMounts) {
                    if (hostMount == null || !this.isHostConnected(hostMount.key).booleanValue()) continue;
                    foundValidHost = true;
                    this.removeInternal(dsRef, dsInfo, hostMount.key);
                    break;
                }
                if (!foundValidHost.booleanValue()) {
                    String errorMessage = this.getLocalizedString("error.invalidHostMount");
                    throw new IllegalArgumentException(errorMessage);
                }
            }
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult remove(ManagedObjectReference host, RemoveVvolDatastoreSpec spec) {
        Validate.notNull((Object)host);
        Validate.notNull((Object)spec);
        OperationResult result = new OperationResult();
        try {
            DatastoreSystem datastoreSystem = this._storageDataService.getHostDatastoreSystem(host);
            datastoreSystem.removeDatastore(spec.datastore);
            result.entity = spec.datastore;
            OperationEffect effect = new OperationEffect();
            effect.affectedEntites = new Object[]{host};
            result.effect = effect;
        }
        catch (Exception exception) {
            result.error = MixedUtil.getMethodFault((Throwable)exception);
        }
        return result;
    }

    public OperationResult apply(ManagedObjectReference hostRef, NfsClearCredentialsSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            this._storageDataService.getHostStorageSystem(hostRef).clearNFSUser();
        }
        catch (Exception e) {
            _logger.error((Object)"Exception while clearining the host's nfs kerberos credentials!", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, NfsEditCredentialsSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            if (StringUtils.isEmpty((CharSequence)spec.userName)) {
                this._storageDataService.getHostStorageSystem(hostRef).changeNFSUserPassword(spec.password);
            } else {
                this._storageDataService.getHostStorageSystem(hostRef).setNFSUser(spec.userName, spec.password);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"Exception while editting the host's nfs kerberos credentials!", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, StorageDeviceMountSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            if (spec.mount) {
                storageSystem.attachScsiLun(spec.lunUuid);
            } else {
                storageSystem.detachScsiLun(spec.lunUuid);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during ScsiLunDisplayNameUpdate:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, TagDiskAsSsdSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        opResult.effect = OperationEffect.newDelayedEffect();
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            ArrayList<ManagedObjectReference> taskList = new ArrayList<ManagedObjectReference>();
            if (spec.diskUUID != null) {
                for (String diskUuid : spec.diskUUID) {
                    try {
                        if (spec.isSSD) {
                            taskList.add(storageSystem.markAsSsd(diskUuid));
                            continue;
                        }
                        taskList.add(storageSystem.markAsNonSsd(diskUuid));
                    }
                    catch (Exception e) {
                        opResult.error = e;
                        _logger.error((Object)"StorageMutationProvider: Unable to tag disk as SSD/NonSSD:", (Throwable)e);
                    }
                }
                this._taskMonitor.monitorTasks(taskList);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Unable to tag disk as SSD/NonSSD:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, StorageDevicePerenniallyReservedSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        opResult.effect = OperationEffect.newDelayedEffect();
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.markPerenniallyReserved(spec.lunUuid, spec.perenniallyReserved);
        }
        catch (Exception e) {
            _logger.error((Object)String.format("StorageMutationProvider: Unable to %s disk %s as perennially reserved on host %s", spec.perenniallyReserved ? "mark" : "unmark", spec.lunUuid, hostRef.toString()), (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, TagDiskAsLocalSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        opResult.effect = OperationEffect.newDelayedEffect();
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            ArrayList<ManagedObjectReference> taskList = new ArrayList<ManagedObjectReference>();
            if (spec.diskUUID != null) {
                for (String diskUuid : spec.diskUUID) {
                    try {
                        if (spec.isLocal) {
                            taskList.add(storageSystem.markAsLocal(diskUuid));
                            continue;
                        }
                        taskList.add(storageSystem.markAsNonLocal(diskUuid));
                    }
                    catch (Exception e) {
                        opResult.error = e;
                        _logger.error((Object)"StorageMutationProvider: Unable to tag disk as Local/Remote:", (Throwable)e);
                    }
                }
                this._taskMonitor.monitorTasks(taskList);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Unable to tag disk as Local/Remote:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, LightDiskLedSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            ManagedObjectReference taskRef = spec.turnOn ? storageSystem.turnDiskLocatorLedOn(spec.diskUUID) : storageSystem.turnDiskLocatorLedOff(spec.diskUUID);
            opResult.task = taskRef;
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during lighting disk LED:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, FormatHostDiskSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.updateDiskPartitions(spec.devicePath, new DiskPartitionInfo.Specification());
            storageSystem.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error formatting disk:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, StoragePathEnableSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            if (spec.enable) {
                storageSystem.enableMultipathPath(spec.pathName);
            } else {
                storageSystem.disableMultipathPath(spec.pathName);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during ScsiLunDisplayNameUpdate:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, StorageAdapterRescanSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            if (spec.adapterKey != null) {
                StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
                HostBusAdapter[] hostHbas = sdi.hostBusAdapter;
                HostBusAdapter hba = null;
                for (HostBusAdapter adapter : hostHbas) {
                    if (!adapter.key.equals(spec.adapterKey)) continue;
                    hba = adapter;
                    break;
                }
                if (hba == null) {
                    _logger.error((Object)("No adapter found for key:[" + spec.adapterKey + "]"));
                    String[] params = new String[]{spec.adapterKey};
                    throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.invalidAdapter", params));
                }
                storageSystem.rescanHba(hba.device);
                return opResult;
            }
            if (spec.rescanHbas) {
                storageSystem.rescanAllHba();
            }
            if (spec.rescanVmfs) {
                storageSystem.rescanVmfs();
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during Rescan:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] hostRefs, final StorageAdapterRescanSpec spec) {
        ArrayList<OperationResult> opResults = new ArrayList<OperationResult>();
        ArrayList<1> tasks = new ArrayList<1>();
        final HttpServletRequest threadContext = SessionUtil.getHttpRequest();
        for (final ManagedObjectReference hostRef : hostRefs) {
            tasks.add(new Callable<OperationResult>(){

                @Override
                public OperationResult call() throws Exception {
                    SessionUtil.setHttpRequest((HttpServletRequest)threadContext);
                    return StorageMutationProvider.this.apply(hostRef, spec);
                }
            });
        }
        try {
            List responses = this._threadPoolExecutor.invokeAll(tasks);
            for (Future response : responses) {
                try {
                    opResults.add((OperationResult)response.get());
                }
                catch (ExecutionException e) {
                    _logger.error((Object)"StorageMutationProvider: Error during Rescan:", (Throwable)e);
                }
            }
        }
        catch (InterruptedException e) {
            _logger.error((Object)"StorageMutationProvider: The executor has been interrupted:", (Throwable)e);
        }
        return opResults.toArray(new OperationResult[opResults.size()]);
    }

    public OperationResult apply(ManagedObjectReference hostRef, StorageSystemRefreshSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.refresh();
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during Refresh:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, InternetScsiStorageAdapterActivationSpec spec) {
        OperationResult opResult;
        block8: {
            opResult = new OperationResult();
            opResult.entity = hostRef;
            try {
                StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
                if (storageSystem == null) {
                    throw new Exception(this.getLocalizedString("error.noStorageSystem"));
                }
                storageSystem.updateSoftwareInternetScsiEnabled(spec.activate);
                FirewallSystem firewallSystem = this._storageDataService.getHostFirewallSystem(hostRef);
                if (firewallSystem == null) {
                    _logger.warn((Object)"StorageMutationProvider: IScsiActivation: Host does not support firewall.");
                    return opResult;
                }
                FirewallInfo firewallInfo = this._storageDataService.getHostFirewallInfo(hostRef);
                if (firewallInfo == null) break block8;
                for (Ruleset rule : firewallInfo.ruleset) {
                    if (rule.key == null || !rule.key.equals(SW_ISCSI_RULE_KEY)) continue;
                    if (!rule.enabled && spec.activate) {
                        firewallSystem.enableRuleset(SW_ISCSI_RULE_KEY);
                    } else if (rule.enabled && !spec.activate) {
                        firewallSystem.disableRuleset(SW_ISCSI_RULE_KEY);
                    }
                    break;
                }
            }
            catch (Exception e) {
                _logger.error((Object)"StorageMutationProvider: Error during IScsiActivation:", (Throwable)e);
                opResult.error = MixedUtil.getMethodFault((Throwable)e);
            }
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, InternetScsiStorageAdapterSettingsUpdateSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            if (spec.name != null) {
                storageSystem.updateInternetScsiName(spec.device, spec.name);
            }
            if (spec.alias != null) {
                storageSystem.updateInternetScsiAlias(spec.device, spec.alias);
            }
            opResult.effect = OperationEffect.newDelayedEffect();
            opResult.effect.affectedEntites = new Object[]{hostRef};
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during update of iSCSI name/alias:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, InternetScsiStorageAdapterSendTargetsSpec spec) {
        return spec.isAdditionOperation != false ? this.addSendTargets(spec) : this.removeSendTargets(spec);
    }

    public OperationResult apply(ManagedObjectReference hostRef, InternetScsiStorageAdapterStaticTargetsSpec spec) {
        return spec.isAdditionOperation != false ? this.addStaticTargets(spec) : this.removeStaticTargets(spec);
    }

    public OperationResult apply(ManagedObjectReference hostRef, MultipathLunPolicySpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.setMultipathLunPolicy(spec.logicalUnitId, spec.policy);
        }
        catch (Exception e) {
            _logger.error((Object)"Error during applying multipath lun policy:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, HppMultipathLunPolicySpec spec) throws Exception {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.updateHppMultipathLunPolicy(spec.logicalUnitId, this.getNewInstanceFromProperties(MultipathInfo.HppLogicalUnitPolicy.class, spec.policy));
        }
        catch (Exception e) {
            _logger.error((Object)"Error during applying HPP multipath lun policy:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, InternetScsiStorageAdapterAuthenticationUpdateSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        if (spec == null || spec.device == null || spec.properties == null) {
            _logger.error((Object)"StorageMutationProvider: Error during update of authentication settings: invalid spec");
            return opResult;
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.updateInternetScsiAuthenticationProperties(spec.device, spec.properties, spec.targetSet);
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during update of authentication settings:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, InternetScsiStorageAdapterIpConfigurationUpdateSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        if (spec == null || spec.device == null || spec.properties == null) {
            _logger.error((Object)"StorageMutationProvider: Error during update of IP/DNS configuration: invalid spec");
            return opResult;
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.updateInternetScsiIPProperties(spec.device, spec.properties);
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during update of IP/DNS configuration:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, ScsiLunDisplayNameUpdateSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.updateScsiLunDisplayName(spec.uuid, spec.text);
            opResult.effect = OperationEffect.newDelayedEffect();
            opResult.effect.affectedEntites = new Object[]{hostRef};
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during ScsiLunDisplayNameUpdate:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, FcoeStorageAdapterRemovalSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            storageSystem.markForRemoval(spec.hbaName, spec.mark);
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during FcoeStorageAdapterActivation:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, FcoeStorageAdapterCreationSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
            if (spec != null) {
                storageSystem.discoverFcoeHbas(spec.fcoeSpec);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during FcoeStorageAdapterCreationSpec:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, CacheConfigurationManager.CacheConfigurationSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            CacheConfigurationManager cfgManager = this._storageDataService.getHostCacheConfigurationManager(hostRef);
            if (cfgManager == null) {
                _logger.error((Object)"StorageMutationProvider: Failed to retrieve host's CacheConfigurationManager.");
                throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
            }
            ManagedObjectReference taskRef = cfgManager.configureCache(spec);
            opResult.task = taskRef;
            TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
            if (taskInfo.error == null) {
                Datastore datastore = (Datastore)ManagedObjectUtil.getManagedObject((ManagedObjectReference)spec.datastore);
                datastore.refreshStorageInfo();
            } else {
                _logger.error((Object)taskInfo.error);
                opResult.error = taskInfo.error;
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during host cache configuration:", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, VFlashAddSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        if (hostRef == null || spec == null) {
            _logger.error((Object)"StorageMutationProvider: Error extending vFlash resource: invalid spec");
            opResult.error = StorageUtil.getFault((String)I18nUtil.getLocalizedString("error.invalidArgument"));
            return opResult;
        }
        try {
            VFlashManager vFlashManager = StorageUtil.getHostVFlashManager((ManagedObjectReference)hostRef);
            if (spec.isTaskMonitored) {
                BlockingFuture future = new BlockingFuture();
                vFlashManager.configureVFlashResourceEx(spec.devicePath, (com.vmware.vim.vmomi.core.Future)future);
                ManagedObjectReference taskRef = (ManagedObjectReference)future.get();
                opResult.task = taskRef;
                TaskInfo taskInfo = this._taskMonitor.monitorTask(taskRef);
                if (taskInfo.error != null) {
                    _logger.error((Object)taskInfo.error);
                    opResult.error = taskInfo.error;
                }
            } else {
                vFlashManager.configureVFlashResourceEx(spec.devicePath);
            }
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, VFlashManager.VFlashCacheConfigSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            VFlashManager vFlashManager = StorageUtil.getHostVFlashManager((ManagedObjectReference)hostRef);
            vFlashManager.configureHostVFlashCache(spec);
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult apply(ManagedObjectReference hostRef, VFlashRemovalSpec spec) {
        OperationResult opResult = new OperationResult();
        opResult.entity = hostRef;
        try {
            VFlashManager vFlashManager = StorageUtil.getHostVFlashManager((ManagedObjectReference)hostRef);
            vFlashManager.removeVFlashResource();
        }
        catch (ResourceInUse e) {
            opResult.error = StorageUtil.getFault((String)I18nUtil.getLocalizedString("error.vFlashResourceInUse"));
        }
        catch (Exception e) {
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public OperationResult add(DiagnosticPartitionCreateSpec spec) {
        OperationResult opResult = new OperationResult();
        if (spec == null || spec.diskUuid == null || spec.diagnosticPartitionType == null || spec.hostRef == null) {
            _logger.error((Object)"StorageMutationProvider: Error adding diagnostic partition: invalid spec");
            opResult.error = StorageUtil.getFault((String)I18nUtil.getLocalizedString("error.invalidArgument"));
            return opResult;
        }
        opResult.entity = spec.hostRef;
        try {
            DiagnosticSystem diagnosticSystem = this._storageDataService.getHostDiagnosticSystem(spec.hostRef);
            DiagnosticPartition.CreateDescription createDescription = diagnosticSystem.queryPartitionCreateDesc(spec.diskUuid, StorageUtil.getDiagnosticType((DiagnosticPartitionType)spec.diagnosticPartitionType));
            diagnosticSystem.createDiagnosticPartition(createDescription.spec);
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error adding diagnostic partition: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    public ValidationResult validate(Object hostRef, InternetScsiStorageAdapterActivationSpec spec) {
        ValidationResult result = new ValidationResult();
        result.entity = hostRef;
        ConfigInfo configInfo = null;
        try {
            configInfo = (ConfigInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"config");
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error validating iSCSI activation prerequisites: ", (Throwable)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        if (configInfo == null) {
            return result;
        }
        if (!this.hasIpStorageNetworking(configInfo)) {
            result.result = SoftwareIScsiActivationValidationResult.VMKERNEL;
            return result;
        }
        if (this.isCommonNicRequired(configInfo) && !StorageMutationProvider.hasCommonNicForConsoleAndStorage(configInfo)) {
            result.result = SoftwareIScsiActivationValidationResult.COMMONCONSOLE;
            return result;
        }
        result.result = SoftwareIScsiActivationValidationResult.SUCCESS;
        return result;
    }

    private void removeInternal(ManagedObjectReference dsRef, Datastore.Info dsInfo, ManagedObjectReference hostRef) throws Exception {
        HostSystem host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        ConfigManager configManager = host.getConfigManager();
        if (StorageUtil.isForceMountedVMFSDatastore((Datastore.Info)dsInfo).booleanValue()) {
            String uuid = StorageUtil.getVmfsDatastoreUuid((Datastore.Info)dsInfo);
            StorageSystem storageSystem = (StorageSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configManager.storageSystem);
            storageSystem.unmountForceMountedVmfsVolume(uuid);
        } else {
            DatastoreSystem datastoreSystem = (DatastoreSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)configManager.datastoreSystem);
            datastoreSystem.removeDatastore(dsRef);
        }
    }

    private OperationResult addSendTargets(InternetScsiStorageAdapterSendTargetsSpec spec) {
        OperationResult opResult = this.createTargetModificationOperationResult(spec.hostRef);
        if (spec == null || spec.device == null || spec.sendTargets == null) {
            _logger.error((Object)"StorageMutationProvider: Error during addition of send targets: invalid spec");
            opResult.error = StorageUtil.getFault((String)I18nUtil.getLocalizedString("error.invalidArgument"));
            return opResult;
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(spec.hostRef);
            storageSystem.addInternetScsiSendTargets(spec.device, spec.sendTargets);
            if (Boolean.TRUE.equals(spec.sendTargets[0].authenticationProperties.chapInherited)) {
                InternetScsiHba.TargetSet targets = new InternetScsiHba.TargetSet();
                targets.sendTargets = spec.sendTargets;
                storageSystem.updateInternetScsiAuthenticationProperties(spec.device, spec.sendTargets[0].authenticationProperties, targets);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during addition of send targets: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private OperationResult addStaticTargets(InternetScsiStorageAdapterStaticTargetsSpec spec) {
        OperationResult opResult = this.createTargetModificationOperationResult(spec.hostRef);
        if (spec == null || spec.device == null || spec.staticTargets == null) {
            _logger.error((Object)"StorageMutationProvider: Error during addition of static targets: invalid spec");
            opResult.error = StorageUtil.getFault((String)I18nUtil.getLocalizedString("error.invalidArgument"));
            return opResult;
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(spec.hostRef);
            storageSystem.addInternetScsiStaticTargets(spec.device, spec.staticTargets);
            if (spec.staticTargets[0].authenticationProperties.chapInherited.booleanValue()) {
                InternetScsiHba.TargetSet targets = new InternetScsiHba.TargetSet();
                targets.staticTargets = spec.staticTargets;
                storageSystem.updateInternetScsiAuthenticationProperties(spec.device, spec.staticTargets[0].authenticationProperties, targets);
            }
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during addition of static targets: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private OperationResult removeSendTargets(InternetScsiStorageAdapterSendTargetsSpec spec) {
        OperationResult opResult = this.createTargetModificationOperationResult(spec.hostRef);
        if (spec == null || spec.device == null || spec.sendTargets == null) {
            _logger.error((Object)"StorageMutationProvider: Error during removal of send targets: invalid spec");
            return opResult;
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(spec.hostRef);
            storageSystem.removeInternetScsiSendTargets(spec.device, spec.sendTargets, null);
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error removal addition of send targets: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private OperationResult removeStaticTargets(InternetScsiStorageAdapterStaticTargetsSpec spec) {
        OperationResult opResult = this.createTargetModificationOperationResult(spec.hostRef);
        if (spec == null || spec.device == null || spec.staticTargets == null) {
            _logger.error((Object)"StorageMutationProvider: Error during removal of static targets: invalid spec");
            return opResult;
        }
        try {
            StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(spec.hostRef);
            storageSystem.removeInternetScsiStaticTargets(spec.device, spec.staticTargets);
        }
        catch (Exception e) {
            _logger.error((Object)"StorageMutationProvider: Error during removal of static targets: ", (Throwable)e);
            opResult.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return opResult;
    }

    private OperationResult createTargetModificationOperationResult(ManagedObjectReference host) {
        OperationResult result = new OperationResult();
        result.entity = host;
        result.effect = new OperationEffect();
        result.effect.affectedEntites = new Object[]{host};
        return result;
    }

    private Boolean isHostConnected(ManagedObjectReference hostRef) {
        HostSystem host = null;
        try {
            host = (HostSystem)ManagedObjectUtil.getManagedObject((ManagedObjectReference)hostRef);
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            return false;
        }
        RuntimeInfo runtime = host.getRuntime();
        if (runtime != null && runtime.getConnectionState() == HostSystem.ConnectionState.connected) {
            return true;
        }
        return false;
    }

    private boolean hasIpStorageNetworking(ConfigInfo configInfo) {
        VirtualNic[] vnics = configInfo.network.vnic;
        if (vnics != null) {
            return vnics.length > 0;
        }
        return false;
    }

    private boolean isCommonNicRequired(ConfigInfo configInfo) {
        AboutInfo info = configInfo.product;
        if (info != null) {
            return StorageUtil.retrieveMajorEsxApiVersion((String)info.apiVersion) < 4 && !info.productLineId.equals("embeddedEsx");
        }
        return false;
    }

    private static boolean hasCommonNicForConsoleAndStorage(ConfigInfo configInfo) {
        boolean vmKernelFound = false;
        boolean serviceConsoleFound = false;
        if (configInfo == null) {
            return false;
        }
        NetCapabilities netCap = configInfo.capabilities;
        if (netCap != null && !netCap.usesServiceConsoleNic) {
            return true;
        }
        NetworkInfo netInfo = configInfo.network;
        if (netInfo == null) {
            return false;
        }
        for (VirtualSwitch vSwitch : netInfo.vswitch) {
            vmKernelFound = false;
            serviceConsoleFound = false;
            for (String pGroupKey : vSwitch.portgroup) {
                PortGroupType type2;
                String pgName = "";
                for (PortGroup portGroup : netInfo.portgroup) {
                    if (!portGroup.key.equals(pGroupKey)) continue;
                    pgName = portGroup.spec.name;
                    break;
                }
                if (PortGroupType.VMOTION.equals((Object)(type2 = StorageUtil.getPortGroupType((String)pgName, (NetworkInfo)netInfo)))) {
                    vmKernelFound = true;
                    continue;
                }
                if (!PortGroupType.SERVICECONSOLE.equals((Object)type2)) continue;
                serviceConsoleFound = true;
            }
            if (!vmKernelFound || !serviceConsoleFound) continue;
            return true;
        }
        return false;
    }

    private String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)this.getClass().getClassLoader());
    }

    private <T> T getNewInstanceFromProperties(Class<T> cl, Map<String, String> properties) throws Exception {
        if (cl == null) {
            return null;
        }
        try {
            T instance = cl.newInstance();
            if (properties != null) {
                for (Map.Entry<String, String> pair : properties.entrySet()) {
                    try {
                        Field field = cl.getField(pair.getKey());
                        if (field.getType() == Long.class) {
                            field.set(instance, Long.parseLong(pair.getValue()));
                            continue;
                        }
                        if (field.getType() == Double.class) {
                            field.set(instance, Double.parseDouble(pair.getValue()));
                            continue;
                        }
                        if (field.getType() == Boolean.class) {
                            field.set(instance, Boolean.parseBoolean(pair.getValue()));
                            continue;
                        }
                        if (field.getType() == String.class) {
                            field.set(instance, pair.getValue());
                            continue;
                        }
                        _logger.warn((Object)String.format("Unsupported field type: (%s) for class: (%s).", pair.getKey(), cl.getCanonicalName()));
                    }
                    catch (Exception e) {
                        _logger.warn((Object)String.format("Error during dynamic object initialization for class (%s) and field (%s).", cl.getCanonicalName(), pair.getKey()), (Throwable)e);
                        throw e;
                    }
                }
            }
            return instance;
        }
        catch (Exception e) {
            _logger.warn((Object)String.format("Dynamic instantiation failed for class (%s).", cl.getCanonicalName()), (Throwable)e);
            throw new Exception(this.getLocalizedString("error.failedDynamicObjectInstantiation"));
        }
    }
}

