/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.impl;

import com.vmware.vim.binding.vim.Datastore;
import com.vmware.vim.binding.vim.ExtendedElementDescription;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.fault.NotSupportedHostForVFlash;
import com.vmware.vim.binding.vim.host.CacheConfigurationManager;
import com.vmware.vim.binding.vim.host.Capability;
import com.vmware.vim.binding.vim.host.DiagnosticPartition;
import com.vmware.vim.binding.vim.host.DiagnosticSystem;
import com.vmware.vim.binding.vim.host.DiskPartitionInfo;
import com.vmware.vim.binding.vim.host.FileSystemMountInfo;
import com.vmware.vim.binding.vim.host.HppPathSelectionPolicyOption;
import com.vmware.vim.binding.vim.host.MountInfo;
import com.vmware.vim.binding.vim.host.MultipathInfo;
import com.vmware.vim.binding.vim.host.MultipathStateInfo;
import com.vmware.vim.binding.vim.host.PathSelectionPolicyOption;
import com.vmware.vim.binding.vim.host.PlugStoreTopology;
import com.vmware.vim.binding.vim.host.ProtocolEndpoint;
import com.vmware.vim.binding.vim.host.ScsiDisk;
import com.vmware.vim.binding.vim.host.ScsiLun;
import com.vmware.vim.binding.vim.host.StorageArrayTypePolicyOption;
import com.vmware.vim.binding.vim.host.StorageDeviceInfo;
import com.vmware.vim.binding.vim.host.StorageSystem;
import com.vmware.vim.binding.vim.host.VffsVolume;
import com.vmware.vim.binding.vim.host.VmfsVolume;
import com.vmware.vim.binding.vim.host.VvolDatastoreInfo;
import com.vmware.vim.binding.vim.host.VvolVolume;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vsphere.client.storage.DatastoreProtocolEndpointHostData;
import com.vmware.vsphere.client.storage.DiagnosticPartitionType;
import com.vmware.vsphere.client.storage.ProtocolEndpointData;
import com.vmware.vsphere.client.storage.ScsiDiskInfo;
import com.vmware.vsphere.client.storage.StorageDataService;
import com.vmware.vsphere.client.storage.i18n.I18nUtil;
import com.vmware.vsphere.client.storage.util.HostStoragePropertyCache;
import com.vmware.vsphere.client.storage.util.StorageUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StoragePropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(StoragePropertyProvider.class);
    private static final String HOST_CAPABILITY_PROPERTY = "capability";
    private static final String CAPABILITY_IS_HPP_SUPPORTED_PROPERTY = "capability.hppPspSupported";
    private static final String HOST_MOUNT_PROPERTY = "hostMount";
    private static final String NOT_SUPPORTED_HOST_FOR_VFLASH_FAULT = NotSupportedHostForVFlash.class.getSimpleName();
    private DataService _dataService;
    private StorageDataService _storageDataService;

    public StoragePropertyProvider(DataService dataService, StorageDataService storageDataService) {
        this._dataService = dataService;
        this._storageDataService = storageDataService;
    }

    @type(value="HostSystem")
    public StorageDeviceInfo getStorageDeviceInfo(ManagedObjectReference hostRef) throws Exception {
        if (hostRef == null) {
            throw new IllegalArgumentException("hostRef cannot be null");
        }
        return this._storageDataService.getHostStorageDeviceInfo(hostRef);
    }

    @type(value="Datastore")
    public String getVStorageSupport(ManagedObjectReference dsRef, ManagedObjectReference hostRef) throws Exception {
        String result = FileSystemMountInfo.VStorageSupportStatus.vStorageUnknown.toString();
        if (dsRef == null) {
            String errorMessage = I18nUtil.getLocalizedString("error.invalidDatastore");
            throw new IllegalArgumentException(errorMessage);
        }
        Datastore.HostMount[] hostMounts = (Datastore.HostMount[])QueryUtil.getProperty((DataService)this._dataService, (Object)dsRef, (String)HOST_MOUNT_PROPERTY);
        Datastore.HostMount dsHostMount = null;
        if (hostMounts != null) {
            for (Datastore.HostMount hostMount : hostMounts) {
                if (!hostMount.key.equals((Object)hostRef)) continue;
                dsHostMount = hostMount;
                break;
            }
        }
        if (dsHostMount != null) {
            FileSystemMountInfo[] fileSystemMountInfos;
            for (FileSystemMountInfo fileSystemMountInfo : fileSystemMountInfos = this._storageDataService.getHostMountInfo(hostRef)) {
                if (!fileSystemMountInfo.mountInfo.path.equals(dsHostMount.mountInfo.path)) continue;
                result = fileSystemMountInfo.vStorageSupport;
                if (fileSystemMountInfo.vStorageSupport != null) break;
                result = FileSystemMountInfo.VStorageSupportStatus.vStorageUnsupported.toString();
                break;
            }
        }
        return result;
    }

    @type(value="HostSystem")
    public DiskPartitionInfo getDiskPartitionInfo(ManagedObjectReference hostRef, String devicePath) throws Exception {
        if (devicePath == null || devicePath.length() == 0) {
            return null;
        }
        StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        if (storageSystem == null) {
            _logger.error((Object)"getVmfsDatastoreCreateOptions: Failed to retrieve host's storageSystem.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        DiskPartitionInfo[] diskPartitionInfos = storageSystem.retrieveDiskPartitionInfo(new String[]{devicePath});
        if (diskPartitionInfos == null) {
            return null;
        }
        return diskPartitionInfos[0];
    }

    @type(value="HostSystem")
    public VmfsVolume.ConfigOption[] getVmfsConfigOption(ManagedObjectReference hostRef) throws Exception {
        StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        if (storageSystem == null) {
            _logger.error((Object)"getVmfsConfigOption: Failed to retrieve host's vmfs configOptions.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        VmfsVolume.ConfigOption[] vmfsConfigOptions = storageSystem.queryVmfsConfigOption();
        return vmfsConfigOptions;
    }

    @type(value="HostSystem")
    public CacheConfigurationManager.CacheConfigurationInfo[] getHostCacheConfigurationInfo(ManagedObjectReference hostRef) throws Exception {
        CacheConfigurationManager configManager = this._storageDataService.getHostCacheConfigurationManager(hostRef);
        if (configManager == null) {
            return new CacheConfigurationManager.CacheConfigurationInfo[0];
        }
        return configManager.getCacheConfigurationInfo();
    }

    @type(value="HostSystem")
    public ScsiDisk[] getAvailableSsdsForVFlash(ManagedObjectReference hostRef) throws Exception {
        ScsiDisk[] ssds = null;
        StorageSystem storageSystem = this._storageDataService.getHostStorageSystem(hostRef);
        if (storageSystem == null) {
            _logger.error((Object)"getAvailableSsdsForVFlash: Failed to retrieve host's storageSystem.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        try {
            ssds = storageSystem.queryAvailableSsds(null);
        }
        catch (SystemError e) {
            String systemErrorMsg = e.getMessage();
            if (systemErrorMsg != null && systemErrorMsg.contains(NOT_SUPPORTED_HOST_FOR_VFLASH_FAULT)) {
                _logger.info((Object)"Unable to retrieve available SSDs for Flash Read Cache. This is expected for hosts with a version less than 5.5.");
            }
            throw e;
        }
        return ssds;
    }

    @type(value="HostSystem")
    public FileSystemMountInfo getVffsFileSystemMountInfo(ManagedObjectReference hostRef) {
        try {
            FileSystemMountInfo[] mountInfos = this._storageDataService.getHostMountInfo(hostRef);
            if (mountInfos != null) {
                for (FileSystemMountInfo mountInfo : mountInfos) {
                    if (!(mountInfo.volume instanceof VffsVolume)) continue;
                    return mountInfo;
                }
            }
        }
        catch (Exception e) {
            _logger.info((Object)"cannot retrieve VFFS information", (Throwable)e);
        }
        return null;
    }

    @type(value="HostSystem")
    public PathSelectionPolicyOption[] getPathSelectionPolicyOptions(ManagedObjectReference hostRef) throws Exception {
        return this._storageDataService.getHostStorageSystem(hostRef).queryPathSelectionPolicyOptions();
    }

    @type(value="HostSystem")
    public HppPathSelectionPolicyOption[] getHppPathSelectionPolicyOptions(ManagedObjectReference hostRef) throws Exception {
        if (this.isHppSupportedOnHost(hostRef)) {
            HppPathSelectionPolicyOption[] options;
            for (HppPathSelectionPolicyOption op : options = this._storageDataService.getHostStorageSystem(hostRef).queryHppPathSelectionPolicyOptions()) {
                ArrayList<HppPathSelectionPolicyOption.HppPspParameterInfo> validParameters = new ArrayList<HppPathSelectionPolicyOption.HppPspParameterInfo>();
                if (op.paramInfo != null) {
                    for (HppPathSelectionPolicyOption.HppPspParameterInfo parameter : op.paramInfo) {
                        if (!this.isHppParameterValid(parameter.paramMapping)) continue;
                        validParameters.add(parameter);
                        StoragePropertyProvider.localizeExtendedElementDescription(parameter.paramDescription, false);
                    }
                }
                op.paramInfo = validParameters.toArray(new HppPathSelectionPolicyOption.HppPspParameterInfo[0]);
                StoragePropertyProvider.localizeExtendedElementDescription(op.policy, false);
            }
            return options;
        }
        return new HppPathSelectionPolicyOption[0];
    }

    @type(value="HostSystem")
    public StorageArrayTypePolicyOption[] getStorageArrayTypePolicyOptions(ManagedObjectReference hostRef) throws Exception {
        return this._storageDataService.getHostStorageSystem(hostRef).queryStorageArrayTypePolicyOptions();
    }

    @type(value="HostSystem")
    public DiagnosticPartition getActiveDiagnosticPartition(ManagedObjectReference hostRef) throws Exception {
        DiagnosticSystem diagnosticSystem = this._storageDataService.getHostDiagnosticSystem(hostRef);
        if (diagnosticSystem == null) {
            _logger.error((Object)"getActivePartition: Failed to retrieve host's diagnosticSystem.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        return diagnosticSystem.getActivePartition();
    }

    @type(value="HostSystem")
    public ScsiDiskInfo[] getAvailableDisksForDiagnosticPartition(ManagedObjectReference hostRef, DiagnosticPartitionType partitionType) throws Exception {
        DiagnosticSystem diagnosticSystem = this._storageDataService.getHostDiagnosticSystem(hostRef);
        if (diagnosticSystem == null) {
            _logger.error((Object)"getAvailableDisksForDiagnosticPartition: Failed to retrieve host's diagnosticSystem.");
            throw new IllegalArgumentException(I18nUtil.getLocalizedString("error.failedToRetrieveHostInfo"));
        }
        DiagnosticPartition.CreateOption[] createOptions = diagnosticSystem.queryPartitionCreateOptions(StorageUtil.getStorageType((DiagnosticPartitionType)partitionType), StorageUtil.getDiagnosticType((DiagnosticPartitionType)partitionType));
        if (createOptions == null || createOptions.length == 0) {
            return new ScsiDiskInfo[0];
        }
        StorageDeviceInfo deviceInfo = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        ScsiDiskInfo[] result = new ScsiDiskInfo[createOptions.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ScsiDiskInfo();
            result[i].disk = createOptions[i].disk;
            result[i].lun = StorageUtil.getDiskLunNumber((StorageDeviceInfo)deviceInfo, (String)result[i].disk.canonicalName);
        }
        return result;
    }

    @type(value="Datastore")
    public ProtocolEndpoint[] getDatastoreProtocolEndpointsData(ManagedObjectReference datastoreRef) {
        ProtocolEndpoint[] emptyResult = new ProtocolEndpoint[]{};
        Datastore.Info dsInfo = null;
        try {
            dsInfo = (Datastore.Info)QueryUtil.getProperty((DataService)this._dataService, (Object)datastoreRef, (String)"info");
        }
        catch (Exception exception) {
            _logger.warn((Object)"unable to fetch datastore info", (Throwable)exception);
            return emptyResult;
        }
        if (!(dsInfo instanceof VvolDatastoreInfo)) {
            _logger.error((Object)"datastore info is not of vvol type");
            return emptyResult;
        }
        VvolVolume vvolVolume = ((VvolDatastoreInfo)dsInfo).vvolDS;
        if (vvolVolume == null) {
            _logger.warn((Object)"vvol volume does not exist");
            return emptyResult;
        }
        VvolVolume.HostProtocolEndpoint[] hostPEs = vvolVolume.hostPE;
        if (hostPEs == null) {
            _logger.warn((Object)"host protocol endpoints do not exist");
            return emptyResult;
        }
        HashMap<String, ProtocolEndpoint> peMap = new HashMap<String, ProtocolEndpoint>();
        for (VvolVolume.HostProtocolEndpoint hostPE : hostPEs) {
            for (ProtocolEndpoint pe : hostPE.protocolEndpoint) {
                if (peMap.containsKey(pe.uuid)) continue;
                peMap.put(pe.uuid, pe);
            }
        }
        return peMap.values().toArray(new ProtocolEndpoint[0]);
    }

    @type(value="HostSystem")
    public ProtocolEndpointData[] getHostProtocolEndpointsData(ManagedObjectReference hostRef) throws Exception {
        String serverGuid = hostRef.getServerGuid();
        ProtocolEndpointData[] emptyResult = new ProtocolEndpointData[]{};
        FileSystemMountInfo[] mountInfo = this._storageDataService.getHostMountInfo(hostRef);
        if (mountInfo == null) {
            _logger.info((Object)"host file system volume info is unset");
            return emptyResult;
        }
        StorageDeviceInfo sdi = this._storageDataService.getHostStorageDeviceInfo(hostRef);
        if (sdi == null) {
            _logger.info((Object)"host storage device info is unset");
            return emptyResult;
        }
        MultipathStateInfo msi = this._storageDataService.getHostMultipathStateInfo(hostRef);
        if (msi == null) {
            _logger.info((Object)"host multipath state info is unset");
            return emptyResult;
        }
        HostStoragePropertyCache cache = new HostStoragePropertyCache(sdi, msi);
        LinkedHashMap<String, ProtocolEndpointData> peMap = new LinkedHashMap<String, ProtocolEndpointData>();
        for (FileSystemMountInfo fileSysMntInfo : mountInfo) {
            if (!(fileSysMntInfo.volume instanceof VvolVolume)) continue;
            VvolVolume vvolVolume = (VvolVolume)fileSysMntInfo.volume;
            if (vvolVolume.hostPE == null) {
                _logger.info((Object)"unable to get host protocol endpoint list");
                continue;
            }
            for (VvolVolume.HostProtocolEndpoint hostPE : vvolVolume.hostPE) {
                if (!serverGuid.equals(hostPE.key.getServerGuid())) continue;
                for (ProtocolEndpoint pe : hostPE.protocolEndpoint) {
                    ProtocolEndpointData peData;
                    if (peMap.containsKey(pe.uuid) || !this.fillProtocolEndpointData(pe, peData = new ProtocolEndpointData(), cache, fileSysMntInfo.mountInfo)) continue;
                    peMap.put(pe.uuid, peData);
                }
            }
        }
        return peMap.values().toArray(new ProtocolEndpointData[peMap.size()]);
    }

    private ScsiLun getUnderlyingLUN(String deviceId, StorageDeviceInfo storDevInfo) {
        if (deviceId == null) {
            _logger.warn((Object)"Protocol endpoint deviceId is not provided. Return null.");
            return null;
        }
        if (storDevInfo == null || storDevInfo.scsiLun == null) {
            _logger.warn((Object)"Insufficient storage information. Return null.");
            return null;
        }
        for (ScsiLun lun : storDevInfo.scsiLun) {
            if (!deviceId.equals(lun.canonicalName)) continue;
            return lun;
        }
        return null;
    }

    private PlugStoreTopology.Device getPeUnderlyingDevice(String key, StorageDeviceInfo storDevInfo) {
        if (storDevInfo == null || storDevInfo.plugStoreTopology == null || storDevInfo.plugStoreTopology.device == null) {
            return null;
        }
        for (PlugStoreTopology.Device device : storDevInfo.plugStoreTopology.device) {
            if (!key.equals(device.lun)) continue;
            return device;
        }
        return null;
    }

    private boolean fillProtocolEndpointData(ProtocolEndpoint pe, ProtocolEndpointData data, HostStoragePropertyCache cache, MountInfo mountInfo) {
        data.protocolEndpoint = pe;
        if (mountInfo != null) {
            data.accessible = mountInfo.accessible;
        }
        if (ProtocolEndpoint.PEType.nas.toString().equals(pe.peType)) {
            return true;
        }
        ScsiLun lun = this.getUnderlyingLUN(pe.deviceId, cache.storageDeviceInfo);
        if (lun == null) {
            _logger.warn((Object)"unable to find protocol endpoint LUN");
            return false;
        }
        PlugStoreTopology.Device device = this.getPeUnderlyingDevice(lun.key, cache.storageDeviceInfo);
        data.underlyingLun = lun;
        data.lunNumber = StorageUtil.getDiskLunNumber((StorageDeviceInfo)cache.storageDeviceInfo, (String)lun.canonicalName);
        data.ownerPlugin = StorageUtil.getOwnerPluginForDevice((PlugStoreTopology.Device)device, (PlugStoreTopology)cache.storageDeviceInfo.plugStoreTopology);
        data.transport = StorageUtil.getTransportForDevice((PlugStoreTopology.Device)device, (HashMap)cache.pstPaths, (HashMap)cache.pstTargets);
        return true;
    }

    @type(value="Datastore")
    public DatastoreProtocolEndpointHostData[] getDatastoreProtocolEndpointHostData(ManagedObjectReference datastore, String protocolEndpointId) throws Exception {
        LinkedList<DatastoreProtocolEndpointHostData> result = new LinkedList<DatastoreProtocolEndpointHostData>();
        Datastore.HostMount[] hostMounts = null;
        try {
            hostMounts = (Datastore.HostMount[])QueryUtil.getProperty((DataService)this._dataService, (Object)datastore, (String)HOST_MOUNT_PROPERTY);
        }
        catch (Exception e) {
            _logger.error((Object)"unable to retrieve host mount for datastore", (Throwable)e);
            return new DatastoreProtocolEndpointHostData[0];
        }
        if (hostMounts == null || hostMounts.length == 0) {
            _logger.error((Object)"no hosts are mounted to datastore");
            return new DatastoreProtocolEndpointHostData[0];
        }
        for (Datastore.HostMount hostMount : hostMounts) {
            ProtocolEndpointData[] protocolEndpoints;
            if (hostMount == null || hostMount.mountInfo == null || hostMount.mountInfo.mounted != null && !hostMount.mountInfo.mounted.booleanValue()) continue;
            ManagedObjectReference hostRef = hostMount.key;
            DatastoreProtocolEndpointHostData peHostData = new DatastoreProtocolEndpointHostData();
            for (ProtocolEndpointData peData : protocolEndpoints = this.getHostProtocolEndpointsData(hostRef)) {
                if (peData == null || peData.protocolEndpoint == null || peData.protocolEndpoint.uuid == null || !peData.protocolEndpoint.uuid.equals(protocolEndpointId)) continue;
                try {
                    peHostData.hostURL = (String)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)"name");
                    peHostData.peData = peData;
                    break;
                }
                catch (Exception e) {
                    _logger.error((Object)"could not get the Host name", (Throwable)e);
                }
            }
            if (peHostData.peData == null) continue;
            result.add(peHostData);
        }
        return result.toArray(new DatastoreProtocolEndpointHostData[0]);
    }

    @type(value="Folder,Datacenter,ClusterComputeResource,HostSystem")
    public boolean getVvolStorageSupported(ManagedObjectReference moRef) {
        try {
            if (moRef.getType().equals(HostSystem.class.getSimpleName()) && !this.vvolStorageSupportedOnHost(moRef)) {
                return false;
            }
            return StorageUtil.getVasaVvolManager((String)moRef.getServerGuid()) != null;
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            return false;
        }
    }

    private boolean vvolStorageSupportedOnHost(ManagedObjectReference hostRef) {
        try {
            Capability capability = (Capability)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)HOST_CAPABILITY_PROPERTY);
            if (capability == null) {
                _logger.warn((Object)"unable to retrieve host capabilities");
                return false;
            }
            return capability.virtualVolumeDatastoreSupported != null && capability.virtualVolumeDatastoreSupported != false;
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            return false;
        }
    }

    private boolean isHppSupportedOnHost(ManagedObjectReference hostRef) {
        try {
            return (Boolean)QueryUtil.getProperty((DataService)this._dataService, (Object)hostRef, (String)CAPABILITY_IS_HPP_SUPPORTED_PROPERTY);
        }
        catch (Exception exception) {
            _logger.error((Object)exception);
            return false;
        }
    }

    private boolean isHppParameterValid(String parameterMapping) {
        try {
            MultipathInfo.HppLogicalUnitPolicy.class.getField(parameterMapping);
            return true;
        }
        catch (NoSuchFieldException nsfe) {
            _logger.info((Object)String.format("Field was not found %s - %s.", parameterMapping, nsfe.getMessage()));
        }
        catch (Exception e) {
            _logger.info((Object)String.format("Error when extracting field %s - %s.", parameterMapping, e.getMessage()));
        }
        return false;
    }

    public static void localizeExtendedElementDescription(ExtendedElementDescription description, boolean omitSummaryIfMissing) {
        String summaryKey;
        String descriptionSummary;
        String descriptionLabel;
        if (description == null) {
            return;
        }
        String prefix = description.messageCatalogKeyPrefix;
        if (prefix == null || prefix.isEmpty()) {
            return;
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix.concat(".");
        }
        if ((descriptionLabel = LocalizationUtil.getLocalizedMessage((String)(prefix + "label"), (KeyAnyValue[])description.messageArg, (int)-1)) != null) {
            description.label = descriptionLabel;
        }
        if ((descriptionSummary = LocalizationUtil.getLocalizedMessage((String)(summaryKey = prefix + "summary"), (KeyAnyValue[])description.messageArg, (int)-1)) != null) {
            if (summaryKey.equals(descriptionSummary) && omitSummaryIfMissing) {
                if (description.summary != null && !description.summary.isEmpty()) {
                    description.summary = descriptionSummary;
                }
            } else {
                description.summary = descriptionSummary;
            }
        }
    }
}

