/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.storage.iofilters.impl;

import com.vmware.vim.binding.vim.ClusterComputeResource;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.IoFilterManager;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.device.VirtualDiskId;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.fault.SystemError;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryExecutor;
import com.vmware.vise.data.query.util.QuerySpecBuilder;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.storage.iofilters.data.HostFilterData;
import com.vmware.vsphere.client.storage.iofilters.data.IoFilterData;
import com.vmware.vsphere.client.storage.iofilters.data.VmData;
import com.vmware.vsphere.client.storage.iofilters.spec.QueryComputeResourceFilterDataSpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IoFilterPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(IoFilterPropertyProvider.class);
    private static final String NAME_PROPERTY = "name";
    private static final String HOST_PROPERTY = "host";
    private static final String VM_CLUSTER_RELATION = "cluster";
    private static final String CLUSTER_HOST_PROP = "host";
    private static final String IOFILTER_CONFIG_PROP = "config.ioFilterInfo";
    private final QueryExecutor _queryExecutor;
    private final QuerySpecBuilder _querySpecBuilder;

    public IoFilterPropertyProvider(QueryExecutor queryExecutor, QuerySpecBuilder querySpecBuilder) {
        this._queryExecutor = queryExecutor;
        this._querySpecBuilder = querySpecBuilder;
    }

    @type(value="HostSystem,ClusterComputeResource")
    public IoFilterData[] getIoFilterData(ManagedObjectReference moRef) throws Exception {
        IoFilterManager.ClusterIoFilterInfo[] filters;
        if (ClusterComputeResource.class.getSimpleName().equals(moRef.getType())) {
            IoFilterManager.ClusterIoFilterInfo[] clusterFilters;
            IoFilterManager manager = this.getIoFilterManager(moRef);
            if (manager == null) {
                return new IoFilterData[0];
            }
            filters = clusterFilters = manager.queryIoFilterInfo(moRef);
        } else if (HostSystem.class.getSimpleName().equals(moRef.getType())) {
            IoFilterManager.HostIoFilterInfo[] hostFilters = (IoFilterManager.HostIoFilterInfo[])this._queryExecutor.getProperty((Object)moRef, IOFILTER_CONFIG_PROP);
            filters = hostFilters;
        } else {
            _logger.error((Object)"Unsupported Reference type for quering the IO Filters");
            throw MixedUtil.getInvalidEntityFault();
        }
        ArrayList<IoFilterData> filtersInfo = new ArrayList<IoFilterData>();
        if (filters != null) {
            for (IoFilterManager.ClusterIoFilterInfo ioFilterInfo : filters) {
                IoFilterData filterData = new IoFilterData();
                filterData.computeResource = moRef;
                filterData.filterInfo = ioFilterInfo;
                filtersInfo.add(filterData);
            }
        }
        return filtersInfo.toArray(new IoFilterData[filtersInfo.size()]);
    }

    @type(value="ClusterComputeResource")
    public HostFilterData[] getHostsFilterData(ManagedObjectReference clusterRef, QueryComputeResourceFilterDataSpec querySpec) throws Exception {
        Map<ManagedObjectReference, HostFilterData> hosts = this.getClusterHosts(clusterRef);
        IoFilterManager manager = this.getIoFilterManager(clusterRef);
        if (manager == null) {
            return new HostFilterData[0];
        }
        IoFilterManager.QueryIssueResult hostIssuesResult = manager.queryIssue(querySpec.filterId, clusterRef);
        if (hostIssuesResult != null && hostIssuesResult.hostIssue != null) {
            for (IoFilterManager.QueryIssueResult.HostIssue hostIssue : hostIssuesResult.hostIssue) {
                if (!hosts.containsKey(hostIssue.host)) continue;
                hosts.get((Object)hostIssue.host).issues = hostIssue.issue;
            }
        }
        Map<ManagedObjectReference, List<VmData>> hostVmsMap = this.getAllClusterVms(clusterRef);
        for (ManagedObjectReference host : hostVmsMap.keySet()) {
            List<VmData> vms = hostVmsMap.get(host);
            hosts.get((Object)host).hostVms = vms.toArray(new VmData[vms.size()]);
        }
        Map<ManagedObjectReference, VmData[]> hostFilterVmsMap = this.getIoFilterVms(manager, querySpec.filterId, clusterRef, hostVmsMap);
        for (ManagedObjectReference host : hosts.keySet()) {
            hosts.get((Object)host).ioFilterVms = hostFilterVmsMap.get(host);
        }
        return hosts.values().toArray(new HostFilterData[hosts.values().size()]);
    }

    private Map<ManagedObjectReference, List<VmData>> getAllClusterVms(ManagedObjectReference clusterRef) throws Exception {
        ObjectIdentityConstraint identityConstraint = this._querySpecBuilder.createObjectIdentityConstraint((Object)clusterRef);
        RelationalConstraint constraint = this._querySpecBuilder.createRelationalConstraint(VM_CLUSTER_RELATION, (Constraint)identityConstraint, Boolean.valueOf(false), VirtualMachine.class.getSimpleName());
        QuerySpec query = this._querySpecBuilder.buildQuerySpec((Constraint)constraint, new String[]{NAME_PROPERTY, "host"});
        ResultSet resultSpec = this._queryExecutor.getData(query);
        HashMap<ManagedObjectReference, List<VmData>> hostVmsMap = new HashMap<ManagedObjectReference, List<VmData>>();
        if (ArrayUtils.isEmpty((Object[])resultSpec.items)) {
            return hostVmsMap;
        }
        for (ResultItem resultItem : resultSpec.items) {
            String vmName = null;
            ManagedObjectReference hostRef = null;
            for (PropertyValue prop : resultItem.properties) {
                if (prop.propertyName.equals(NAME_PROPERTY)) {
                    vmName = (String)prop.value;
                }
                if (!prop.propertyName.equals("host")) continue;
                hostRef = (ManagedObjectReference)prop.value;
            }
            if (vmName == null || hostRef == null) continue;
            if (!hostVmsMap.containsKey(hostRef)) {
                hostVmsMap.put(hostRef, new LinkedList());
            }
            VmData vmData = new VmData();
            vmData.vmReference = (ManagedObjectReference)resultItem.resourceObject;
            vmData.vmName = vmName;
            ((List)hostVmsMap.get(hostRef)).add(vmData);
        }
        return hostVmsMap;
    }

    private Map<ManagedObjectReference, VmData[]> getIoFilterVms(IoFilterManager manager, String filterId, ManagedObjectReference clusterRef, Map<ManagedObjectReference, List<VmData>> allHostVmsMap) throws Exception {
        VirtualDiskId[] virtualDisks = null;
        try {
            virtualDisks = manager.queryDisksUsingFilter(filterId, clusterRef);
        }
        catch (SystemError e) {
            _logger.warn((Object)"Exception occur during retriving IO Filter disks: ", (Throwable)e);
        }
        HashSet<ManagedObjectReference> vmsUsingIoFilter = new HashSet<ManagedObjectReference>();
        if (virtualDisks != null) {
            for (VirtualDiskId virtualDiskId : virtualDisks) {
                vmsUsingIoFilter.add(virtualDiskId.vm);
            }
        }
        HashMap<ManagedObjectReference, VmData[]> filterHostVmsMap = new HashMap<ManagedObjectReference, VmData[]>();
        for (ManagedObjectReference host : allHostVmsMap.keySet()) {
            LinkedList<VmData> filterVms = new LinkedList<VmData>();
            for (VmData vmData : allHostVmsMap.get(host)) {
                if (!vmsUsingIoFilter.contains(vmData.vmReference)) continue;
                filterVms.add(vmData);
            }
            if (filterVms.isEmpty()) continue;
            filterHostVmsMap.put(host, filterVms.toArray(new VmData[filterVms.size()]));
        }
        return filterHostVmsMap;
    }

    private Map<ManagedObjectReference, HostFilterData> getClusterHosts(ManagedObjectReference clusterRef) throws Exception {
        Object[] props = this._queryExecutor.getPropertiesForRelatedObjects((Object)clusterRef, "host", HostSystem.class.getSimpleName(), new String[]{NAME_PROPERTY});
        HashMap<ManagedObjectReference, HostFilterData> result = new HashMap<ManagedObjectReference, HostFilterData>();
        if (!ArrayUtils.isEmpty((Object[])props)) {
            for (Object pv : props) {
                HostFilterData hostData = new HostFilterData();
                hostData.hostReference = (ManagedObjectReference)((PropertyValue)pv).resourceObject;
                hostData.hostName = (String)((PropertyValue)pv).value;
                result.put(hostData.hostReference, hostData);
            }
        }
        return result;
    }

    private IoFilterManager getIoFilterManager(ManagedObjectReference moRef) throws Exception {
        String serviceGuid = moRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serviceGuid);
        ServiceInstance content = vcService.getServiceInstance();
        ManagedObjectReference managerRef = content.getContent().getIoFilterManager();
        if (managerRef == null) {
            return null;
        }
        return (IoFilterManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)managerRef);
    }
}

