/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.cis.license.client.LicenseClient;
import com.vmware.cis.license.client.LicenseClientException;
import com.vmware.cis.license.client.LicenseClientFactory;
import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseClientUnavailableException;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.LsVmodlVersionSelector;
import com.vmware.license.client.cis.ls.VpxLicenseServiceLocator;
import com.vmware.license.client.cis.ls.impl.OsgiLicenseClientFactoryImpl;
import com.vmware.license.client.cis.ls.scope.ScopeResolver;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import com.vmware.vim.vmomi.client.ext.ServerEndpointProvider;
import com.vmware.vim.vmomi.client.http.HttpConfiguration;
import com.vmware.vise.util.debug.TimeMonitor;
import com.vmware.vise.util.sidecar.SidecarUrlService;
import com.vmware.vise.vim.commons.vmomi.SharedHttpConfigPool;
import com.vmware.vise.vim.connections.SiteAffinityServerEndpointProvider;
import java.net.URI;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LicenseClientProviderImpl
implements LicenseClientProvider {
    private static final long LOGOUT_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private static final long CLOSE_THRESHOLD_IN_NANOS = TimeUnit.SECONDS.toNanos(2L);
    private final Log _logger = LogFactory.getLog(LicenseClientProviderImpl.class);
    private final OsgiLicenseClientFactoryImpl _licenseClientFactory;
    private final ScopeResolver _scopeResolver;
    private final VpxLicenseServiceLocator _vpxLicenseServiceLocator;
    private final SharedHttpConfigPool _sharedHttpConfigPool;
    private final LicenseClientFactory.LicenseClientAutomaticAuthenticator _licenseClientAuthenticator;
    private final Executor _logoutExecutor;
    private final LsVmodlVersionSelector _lsVmodlVersionSelector;
    private final SidecarUrlService _sidecarUrlService;

    public LicenseClientProviderImpl(OsgiLicenseClientFactoryImpl licenseClientFactory, ScopeResolver scopeResolver, VpxLicenseServiceLocator vpxLicenseServiceLocator, SharedHttpConfigPool sharedHttpConfigPool, LicenseClientFactory.LicenseClientAutomaticAuthenticator licenseClientAuthenticator, Executor logoutThreadPoolExecutor, LsVmodlVersionSelector lsVmodlVersionSelector, SidecarUrlService sidecarUrlService) {
        this._licenseClientFactory = licenseClientFactory;
        this._scopeResolver = scopeResolver;
        this._vpxLicenseServiceLocator = vpxLicenseServiceLocator;
        this._sharedHttpConfigPool = sharedHttpConfigPool;
        this._licenseClientAuthenticator = licenseClientAuthenticator;
        this._logoutExecutor = logoutThreadPoolExecutor;
        this._lsVmodlVersionSelector = lsVmodlVersionSelector;
        this._sidecarUrlService = sidecarUrlService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LicenseClient getLicenseClient(LicenseScope scope) throws LicenseClientUnavailableException {
        Validate.notNull((Object)scope);
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader licenseServiceBundleClassLoader = this.getClass().getClassLoader();
        LicenseClient resultLicenseClient = null;
        try {
            Thread.currentThread().setContextClassLoader(licenseServiceBundleClassLoader);
            try {
                resultLicenseClient = this.buildLicenseClient(scope);
            }
            catch (LicenseClientException e) {
                throw new LicenseClientUnavailableException(e, LicenseClientUnavailableException.Reason.CREATION_FAILED);
            }
            this._licenseClientAuthenticator.login(resultLicenseClient);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
        return resultLicenseClient;
    }

    @Override
    public void disposeLicenseClient(final LicenseClient licenseClient) {
        Validate.notNull((Object)licenseClient);
        this._logoutExecutor.execute(new Runnable(){

            @Override
            public void run() {
                LicenseClientProviderImpl.this.logoutLicenseClient(licenseClient);
                LicenseClientProviderImpl.this.closeLicenseClient(licenseClient);
            }
        });
    }

    private LicenseClient buildLicenseClient(LicenseScope scope) throws LicenseClientUnavailableException {
        HttpConfiguration httpConfig = this._sharedHttpConfigPool.getHttpConfig(scope.toString());
        URI lsUri = this.getLsUri(scope);
        URI sidecarUri = this._sidecarUrlService.createSidecarUrl(lsUri, SidecarUrlService.CertificateAuthority.VECS);
        SsoDomain ssoDomain = this.getSsoDomain(scope);
        Class<?> lsVmodlVersion = this._lsVmodlVersionSelector.getLicenseServiceVmodlVersion(scope);
        LicenseClient resultLicenseClient = null;
        boolean enableSiteAffinity = this.shouldEnableSiteAffinity(scope);
        resultLicenseClient = enableSiteAffinity ? this._licenseClientFactory.createClient((ServerEndpointProvider)new SiteAffinityServerEndpointProvider(sidecarUri), lsVmodlVersion, ssoDomain, httpConfig) : this._licenseClientFactory.createClient(sidecarUri, lsVmodlVersion, ssoDomain, httpConfig);
        return resultLicenseClient;
    }

    private URI getLsUri(LicenseScope scope) throws LicenseClientUnavailableException {
        URI resultLsUri = null;
        try {
            String vcId = this._scopeResolver.getVcId(scope);
            resultLsUri = this._vpxLicenseServiceLocator.getLicenseServiceUriForVc(vcId);
        }
        catch (Exception e) {
            throw new LicenseClientUnavailableException(e, LicenseClientUnavailableException.Reason.LOCATION_UNAVAILABLE);
        }
        return resultLsUri;
    }

    private SsoDomain getSsoDomain(LicenseScope scope) throws LicenseClientUnavailableException {
        SsoDomain ssoDomain = null;
        try {
            ssoDomain = this._scopeResolver.getSsoDomain(scope);
        }
        catch (Exception e) {
            throw new LicenseClientUnavailableException(e, LicenseClientUnavailableException.Reason.LOCATION_UNAVAILABLE);
        }
        return ssoDomain;
    }

    private boolean shouldEnableSiteAffinity(LicenseScope scope) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logoutLicenseClient(LicenseClient licenseClient) {
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            licenseClient.logout();
        }
        catch (Exception e) {
            this._logger.error((Object)("Failed to logout license client: " + licenseClient), (Throwable)e);
        }
        finally {
            timeMonitor.logTimeIfExceeding(LOGOUT_THRESHOLD_IN_NANOS, "LicenseClient.logout", LicenseClient.class, (Object)licenseClient);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeLicenseClient(LicenseClient licenseClient) {
        TimeMonitor timeMonitor = new TimeMonitor();
        try {
            timeMonitor.init();
            licenseClient.close();
        }
        catch (Exception e) {
            this._logger.error((Object)("Failed to close license client: " + licenseClient), (Throwable)e);
        }
        finally {
            timeMonitor.logTimeIfExceeding(CLOSE_THRESHOLD_IN_NANOS, "LicenseClient.close", LicenseClient.class, (Object)licenseClient);
        }
    }
}

