/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.impl;

import com.vmware.vim.vmomi.client.ext.InvocationContext;
import com.vmware.vim.vmomi.client.ext.InvocationInterceptor;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LoggingLsInvocationInterceptorImpl
implements InvocationInterceptor {
    private static final String CONTEXT_KEY_CALL_START_DATE = "callStartDate";
    private static final long LS_CALL_LOG_THRESHOLD_IN_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    private final Log _logger = LogFactory.getLog(LoggingLsInvocationInterceptorImpl.class);

    public void beginInvocation(InvocationContext context) {
        Date callStartDate = new Date();
        context.putInvocationContextObject(CONTEXT_KEY_CALL_START_DATE, (Object)callStartDate);
    }

    public void completeInvocation(InvocationContext context, boolean completed) {
        Object callStart = context.getInvocationContextObject(CONTEXT_KEY_CALL_START_DATE);
        if (!(callStart instanceof Date)) {
            return;
        }
        Date callStartDate = (Date)callStart;
        Date callEndDate = new Date();
        if (callEndDate.getTime() - callStartDate.getTime() > LS_CALL_LOG_THRESHOLD_IN_MILLIS) {
            this._logger.warn((Object)"LS call exceeded 30 second threshold.");
        }
    }
}

