/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.scope.impl;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.ls.scope.ScopeResolver;
import com.vmware.license.client.cis.ls.scope.ScopeResolverException;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProviderFactory;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vcenter.apigw.api.sso.SsoDomain;
import org.apache.commons.lang3.Validate;

public class ScopeResolverImpl
implements ScopeResolver {
    private final SsoSpecificTopologyInfoProviderFactory _topologyInfoProviderFactory;

    public ScopeResolverImpl(SsoSpecificTopologyInfoProviderFactory topologyInfoProviderFactory) {
        this._topologyInfoProviderFactory = topologyInfoProviderFactory;
    }

    @Override
    public String getVcId(LicenseScope scope) throws ScopeResolverException {
        Validate.notNull((Object)scope);
        String resultVcId = null;
        resultVcId = ManagementUtil.SCOPE_CIS_LICENSING.equals(scope) ? this.getLocalVcId() : scope.getId();
        return resultVcId;
    }

    @Override
    public SsoDomain getSsoDomain(LicenseScope scope) throws ScopeResolverException {
        SsoSpecificTopologyInfoProvider[] topologyInfoProviders;
        Validate.notNull((Object)scope);
        String resultVcId = this.getVcId(scope);
        for (SsoSpecificTopologyInfoProvider topologyInfoProvider : topologyInfoProviders = this._topologyInfoProviderFactory.getAllTopologyInfoProviders()) {
            if (!topologyInfoProvider.containsVcId(resultVcId)) continue;
            return SsoDomainHelper.valueOf((String)topologyInfoProvider.getSsoDomainId(), null, null);
        }
        return null;
    }

    private String getLocalVcId() throws ScopeResolverException {
        try {
            SsoSpecificTopologyInfoProvider ssoSpecificTopologyInfoProvider = this._topologyInfoProviderFactory.getDefaultTopologyInfoProvider();
            return ssoSpecificTopologyInfoProvider.getLocalVcId();
        }
        catch (TopologyInfoRetrievalException e) {
            throw new ScopeResolverException(e);
        }
    }

    @Override
    public boolean isLocalVcScope(LicenseScope scope) throws ScopeResolverException {
        Validate.notNull((Object)scope);
        LicenseScope localScope = ManagementUtil.SCOPE_CIS_LICENSING;
        String localVcId = this.getVcId(localScope);
        String scopeVcId = this.getVcId(scope);
        return localVcId.equals(scopeVcId);
    }
}

