/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.ls.topology.impl;

import com.vmware.license.client.cis.ls.topology.Folder;
import com.vmware.license.client.cis.ls.topology.LookupClient;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProvider;
import com.vmware.license.client.cis.ls.topology.SsoSpecificTopologyInfoProviderFactory;
import com.vmware.license.client.cis.ls.topology.TopologyInfoRetrievalException;
import com.vmware.license.client.cis.ls.topology.impl.AfdLocalFolderInfoProviderImpl;
import com.vmware.license.client.cis.ls.topology.impl.DsConfigLocalFolderInfoProviderImpl;
import com.vmware.license.client.cis.ls.topology.impl.SsoSpecificTopologyInfoProviderImpl;
import com.vmware.sso.tokenmgmt.SsoDomainHelper;
import com.vmware.vim.binding.lookup.ServiceRegistration;
import com.vmware.vise.util.client.configuration.ConfigurationService;
import com.vmware.vise.util.concurrent.ThreadPoolFactory;
import com.vmware.vise.util.concurrent.WorkerThreadFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SsoSpecificTopologyInfoProviderFactoryImpl
implements SsoSpecificTopologyInfoProviderFactory {
    private final Log _logger = LogFactory.getLog(SsoSpecificTopologyInfoProviderFactoryImpl.class);
    private static final ServiceRegistration.ServiceType VC_SERVICE_TYPE = new ServiceRegistration.ServiceType("com.vmware.cis", "vcenterserver");
    private static final ServiceRegistration.ServiceType LICENSE_SERVICE_TYPE = new ServiceRegistration.ServiceType("com.vmware.cis", "cs.license");
    private static final String AFD_DISABLED = "afd.disabled";
    private static final String SERVICE_INFO_DOMAIN_ID_ATTRIBUTE = "domainId";
    private static final String TOPOLOGY_INFO_PROVIDER_THREAD_FACTORY_NAME = "topology-info-provider-pool";
    private final LookupClient _lookupClient;
    private final ConfigurationService _configurationService;
    private Map<String, SsoSpecificTopologyInfoProvider> _domainToTopologyInfoProvider = new HashMap<String, SsoSpecificTopologyInfoProvider>();
    private SsoSpecificTopologyInfoProviderImpl _defaultSsoSpecificTopologyInfoProvider = null;
    private Object _topologyInfoRetrievalLock = new Object();

    public SsoSpecificTopologyInfoProviderFactoryImpl(LookupClient lookupClient, ConfigurationService configurationService) {
        this._lookupClient = lookupClient;
        this._configurationService = configurationService;
    }

    @Override
    public SsoSpecificTopologyInfoProvider getDefaultTopologyInfoProvider() throws TopologyInfoRetrievalException {
        this.initSsoSpecificTopologyInfoProvidersData();
        if (this._defaultSsoSpecificTopologyInfoProvider == null) {
            throw new TopologyInfoRetrievalException("The default SSO domain can't be determined.");
        }
        return this._defaultSsoSpecificTopologyInfoProvider;
    }

    @Override
    public SsoSpecificTopologyInfoProvider getTopologyInfoProviderForVc(String vcId) {
        this.initSsoSpecificTopologyInfoProvidersData();
        SsoSpecificTopologyInfoProvider topologyInfoProviderForVc = null;
        for (SsoSpecificTopologyInfoProvider topologyInfoProvider : this._domainToTopologyInfoProvider.values()) {
            if (!topologyInfoProvider.containsVcId(vcId)) continue;
            topologyInfoProviderForVc = topologyInfoProvider;
        }
        return topologyInfoProviderForVc;
    }

    @Override
    public SsoSpecificTopologyInfoProvider getTopologyInfoProviderForNode(String nodeId) {
        this.initSsoSpecificTopologyInfoProvidersData();
        SsoSpecificTopologyInfoProvider topologyInfoProviderForNode = null;
        for (SsoSpecificTopologyInfoProvider topologyInfoProvider : this._domainToTopologyInfoProvider.values()) {
            if (!topologyInfoProvider.containsNodeId(nodeId)) continue;
            topologyInfoProviderForNode = topologyInfoProvider;
        }
        return topologyInfoProviderForNode;
    }

    @Override
    public SsoSpecificTopologyInfoProvider getTopologyInfoProviderForSsoDomain(String ssoDomainId) {
        this.initSsoSpecificTopologyInfoProvidersData();
        SsoSpecificTopologyInfoProvider topologyInfoProvider = this._domainToTopologyInfoProvider.get(ssoDomainId);
        if (topologyInfoProvider == null && SsoDomainHelper.isLocalDomainId((String)ssoDomainId)) {
            topologyInfoProvider = this._defaultSsoSpecificTopologyInfoProvider;
        }
        return topologyInfoProvider;
    }

    @Override
    public SsoSpecificTopologyInfoProvider[] getAllTopologyInfoProviders() {
        this.initSsoSpecificTopologyInfoProvidersData();
        return this._domainToTopologyInfoProvider.values().toArray(new SsoSpecificTopologyInfoProvider[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSsoSpecificTopologyInfoProvidersData() {
        if (this._domainToTopologyInfoProvider.size() == 0) {
            Object object = this._topologyInfoRetrievalLock;
            synchronized (object) {
                if (this._domainToTopologyInfoProvider.size() == 0) {
                    WorkerThreadFactory threadFactory = new WorkerThreadFactory(TOPOLOGY_INFO_PROVIDER_THREAD_FACTORY_NAME);
                    ThreadPoolExecutor executor = ThreadPoolFactory.newFixedThreadPool((int)2, (ThreadFactory)threadFactory);
                    ArrayList<Callable<ServiceRegistration.Info[]>> tasks = new ArrayList<Callable<ServiceRegistration.Info[]>>();
                    tasks.add(this.createTaskForServiceInfoRetrievalOfType(VC_SERVICE_TYPE));
                    tasks.add(this.createTaskForServiceInfoRetrievalOfType(LICENSE_SERVICE_TYPE));
                    try {
                        List results = executor.invokeAll(tasks);
                        ServiceRegistration.Info[] vcServiceInfos = (ServiceRegistration.Info[])results.get(0).get();
                        ServiceRegistration.Info[] licenseServiceInfos = (ServiceRegistration.Info[])results.get(1).get();
                        this.populateInfoProvidersWithVcServicesInformation(vcServiceInfos);
                        this.populateInfoProvidersWithLsServicesInformation(licenseServiceInfos);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        this._logger.error((Object)"The retrieval of the VC and LS services infos failed. Error: ", (Throwable)e);
                    }
                    finally {
                        executor.shutdown();
                    }
                }
            }
        }
    }

    private void populateInfoProvidersWithVcServicesInformation(ServiceRegistration.Info[] vcServiceInfos) {
        if (vcServiceInfos != null && vcServiceInfos.length > 0) {
            for (ServiceRegistration.Info vcServiceInfo : vcServiceInfos) {
                String domainId = this.extractSsoDomainIdFromServiceRegistrationInfo(vcServiceInfo);
                String vcId = vcServiceInfo.getServiceId();
                SsoSpecificTopologyInfoProviderImpl topologyInfoProvider = this.getRegisteredTopologyInfoProviderForDomainId(vcServiceInfo);
                topologyInfoProvider.addVcIdToNodeIdMappings(vcId, vcServiceInfo.nodeId);
            }
            this.setLocalSsoDomainTopologyInfoProvider();
        }
    }

    private void setLocalSsoDomainTopologyInfoProvider() {
        for (String domainId : this._domainToTopologyInfoProvider.keySet()) {
            if (!SsoDomainHelper.isLocalDomainId((String)domainId)) continue;
            this._defaultSsoSpecificTopologyInfoProvider = (SsoSpecificTopologyInfoProviderImpl)this._domainToTopologyInfoProvider.get(domainId);
            break;
        }
        if (this._defaultSsoSpecificTopologyInfoProvider != null) {
            this.setLocalVcIdForLocalDomain();
        }
    }

    private void setLocalVcIdForLocalDomain() {
        String localNodeId = this.getLocalNodeId();
        if (localNodeId != null) {
            try {
                Map<String, String> nodeIdToVcId = this._defaultSsoSpecificTopologyInfoProvider.getNodeIdToVcId(Arrays.asList(localNodeId));
                String localVcId = nodeIdToVcId.get(localNodeId);
                this._defaultSsoSpecificTopologyInfoProvider.setLocalVcId(localVcId);
            }
            catch (TopologyInfoRetrievalException e) {
                this._logger.debug((Object)("Failed to retrieve the vc id for node: " + localNodeId + " Error: " + e));
            }
        }
    }

    private void populateInfoProvidersWithLsServicesInformation(ServiceRegistration.Info[] licenseServiceInfos) {
        if (licenseServiceInfos != null && licenseServiceInfos.length > 0) {
            for (ServiceRegistration.Info lsServiceInfo : licenseServiceInfos) {
                SsoSpecificTopologyInfoProviderImpl topologyInfoProvider = this.getRegisteredTopologyInfoProviderForDomainId(lsServiceInfo);
                topologyInfoProvider.addLicenseServiceInfo(lsServiceInfo);
            }
        }
    }

    private SsoSpecificTopologyInfoProviderImpl getRegisteredTopologyInfoProviderForDomainId(ServiceRegistration.Info serviceInfo) {
        String domainId = this.extractSsoDomainIdFromServiceRegistrationInfo(serviceInfo);
        SsoSpecificTopologyInfoProviderImpl topologyInfoProvider = (SsoSpecificTopologyInfoProviderImpl)this._domainToTopologyInfoProvider.get(domainId);
        if (topologyInfoProvider == null) {
            topologyInfoProvider = new SsoSpecificTopologyInfoProviderImpl(domainId);
            this._domainToTopologyInfoProvider.put(domainId, topologyInfoProvider);
        }
        return topologyInfoProvider;
    }

    private ServiceRegistration.Info[] searchServiceInfos(ServiceRegistration.ServiceType serviceType) {
        return this.searchServiceInfos(serviceType, null);
    }

    private ServiceRegistration.Info[] searchServiceInfos(ServiceRegistration.ServiceType serviceType, Folder folder) {
        return this._lookupClient.searchServiceInfos(serviceType, folder);
    }

    private String getLocalNodeId() {
        boolean isAfdDisabled = Boolean.parseBoolean(this._configurationService.getProperty(AFD_DISABLED));
        try {
            if (isAfdDisabled) {
                return new DsConfigLocalFolderInfoProviderImpl().getLocalFolderId();
            }
            return new AfdLocalFolderInfoProviderImpl().getLocalFolderId();
        }
        catch (Throwable e) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info((Object)("Both the DsConfigLocalFolderInfoProvider and AfdLocalFolderInfoProvider couldn't return localFolderId! Exception: " + e.getMessage()));
            }
            return null;
        }
    }

    private String extractSsoDomainIdFromServiceRegistrationInfo(ServiceRegistration.Info serviceInfo) {
        String domainId = null;
        if (serviceInfo != null) {
            for (ServiceRegistration.Attribute attribute : serviceInfo.serviceAttributes) {
                if (!SERVICE_INFO_DOMAIN_ID_ATTRIBUTE.equals(attribute.getKey())) continue;
                domainId = attribute.getValue();
                break;
            }
        }
        if (domainId == null) {
            domainId = SsoDomainHelper.getLocal().getId();
        }
        return domainId;
    }

    private Callable<ServiceRegistration.Info[]> createTaskForServiceInfoRetrievalOfType(final ServiceRegistration.ServiceType serviceType) {
        return new Callable<ServiceRegistration.Info[]>(){

            @Override
            public ServiceRegistration.Info[] call() throws Exception {
                ServiceRegistration.Info[] serviceInfos = SsoSpecificTopologyInfoProviderFactoryImpl.this.searchServiceInfos(serviceType);
                return serviceInfos;
            }
        };
    }
}

