/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.adapter;

import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ManagementEditor;
import com.vmware.license.client.cis.management.adapter.BaseManagementDataProviderAdapterImpl;
import com.vmware.license.client.cis.management.adapter.BasePropertyProviderBean;
import com.vmware.license.client.cis.management.adapter.ProductPropertyProviderBean;
import com.vmware.license.client.cis.management.ds.ProductAggregation;
import com.vmware.license.client.cis.management.util.UriUtil;
import com.vmware.vise.data.query.type;
import java.net.URI;

@type(value="Product")
public class ProductDataProviderAdapterImpl
extends BaseManagementDataProviderAdapterImpl<ProductAggregation> {
    private static final String RELATION_PRODUCTS = "products";
    private final ManagementEditor _managementEditor;

    private static boolean canHandleRelation(Object[] objectsRefs, String relation) {
        return RELATION_PRODUCTS.equals(relation) && UriUtil.containsSingleUriWithType(objectsRefs, "License");
    }

    private static URI getLicenseUri(Object[] objectsRefs) {
        return (URI)objectsRefs[0];
    }

    public ProductDataProviderAdapterImpl(ManagementEditor managementEditor) {
        this._managementEditor = managementEditor;
    }

    @Override
    protected BasePropertyProviderBean<ProductAggregation> getPropertyProvider() {
        return new ProductPropertyProviderBean();
    }

    @Override
    protected String getProvidedType() {
        return "Product";
    }

    @Override
    protected URI getUri(ProductAggregation productAggregation) {
        return productAggregation.getProduct().getUri();
    }

    protected ProductAggregation[] getObjectsByScope(LicenseScope scope) {
        return this._managementEditor.getProductAggregations(null, scope);
    }

    protected ProductAggregation[] getObjectsByUrisAndScope(URI[] productUris, LicenseScope scope) {
        return this._managementEditor.getProductAggregations(productUris, scope);
    }

    protected ProductAggregation[] getRelatedObjects(Object[] objectsRefs, String relation) {
        if (!ProductDataProviderAdapterImpl.canHandleRelation(objectsRefs, relation)) {
            return (ProductAggregation[])super.getRelatedObjects(objectsRefs, relation);
        }
        URI licenseUri = ProductDataProviderAdapterImpl.getLicenseUri(objectsRefs);
        return this._managementEditor.getProductAggregationsForLicense(licenseUri);
    }
}

