/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.management.util;

import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.util.ManagementUtil;
import com.vmware.vim.binding.impl.vmodl.KeyAnyValueImpl;
import com.vmware.vim.binding.vmodl.KeyAnyValue;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

public class CostUnitUtil {
    public static final Number NO_LIMIT_VALUE = 0;
    public static final int DEFAULT_NUMBER_CORES_7_0 = 32;
    public static final int DEFAULT_NUMBER_MINIMUM_CORES_8_0 = 16;
    public static final String COST_UNIT_CPU_PACKAGE = "cpuPackage";
    public static final String COST_UNIT_VM = "vm";
    public static final String COST_UNIT_CPU_CORE = "cpuCore";
    public static final String CPU_PACKAGE_CORE_LIMIT_PREFIX = "cpuPackage:";
    public static final String CPU_PACKAGE_CORE_LIMIT_SUFFIX = "core";
    public static final String CORES_MINIMUM_LIMIT_PREFIX = "cpuCore:";
    public static final String CORES_MINIMUM_LIMIT_SUFFIX = "core";
    private static final String CORES_REGEX_GROUP_NAME = "cores";
    private static final String MATCH_CONFIGURABLE_COST_UNIT_REGEX = String.format("^(?<costUnit>[a-zA-Z]+)\\:(?<%s>\\d+)core$", "cores");
    private static final String COST_UNIT_LOCALIZATION_KEY_FORMAT = "com.vmware.vim.license.CostUnit.%s.label";
    private static final String LEGACY_COST_UNIT_LOCALIZATION_KEY_FORMAT = "costUnit.%s.valueLabel";
    private static final String COST_UNIT_LOCALIZATION_KEY_LONG_FORMAT = "com.vmware.vim.license.CostUnit.%s.longLabel";
    private static final String LEGACY_COST_UNIT_LOCALIZATION_KEY_LONG_FORMAT = "costUnit.%s.longValueLabel";
    private static final String[] COST_UNIT_LOCALIZATION_KEY_FORMATS = new String[]{"com.vmware.vim.license.CostUnit.%s.label", "costUnit.%s.valueLabel"};
    private static final String[] COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS = new String[]{"com.vmware.vim.license.CostUnit.%s.longLabel", "costUnit.%s.longValueLabel"};
    private static Localizer _messageLocalizer = new ManagementUtilLocalizer();

    static void setLocalizer(Localizer localizer) {
        _messageLocalizer = localizer;
    }

    public static void formatCostUnits(CostUnit[] costUnits) {
        if (ArrayUtils.isEmpty((Object[])costUnits)) {
            return;
        }
        for (CostUnit costUnit : costUnits) {
            CostUnitUtil.formatCostUnit(costUnit);
        }
    }

    public static void formatCostUnit(CostUnit costUnit) {
        if (costUnit == null || costUnit.getId() == null) {
            return;
        }
        String formattedId = CostUnitUtil.getLongFormattedCostUnitId(costUnit.getId());
        costUnit.setFormattedId(formattedId);
        String valueFormat = "%s " + formattedId;
        costUnit.setValueFormat(valueFormat);
    }

    public static Set<String> getCostUnitIds(CostUnit[] costUnits) {
        LinkedHashSet<String> costUnitsIds = new LinkedHashSet<String>();
        if (ArrayUtils.isEmpty((Object[])costUnits)) {
            return costUnitsIds;
        }
        for (CostUnit costUnit : costUnits) {
            costUnitsIds.add(costUnit.getId());
        }
        return costUnitsIds;
    }

    public static void addCostUnitUsages(CostUnit[] sourceCostUnits, CostUnit[] destinationCostUnits) {
        if (ArrayUtils.isEmpty((Object[])sourceCostUnits) || ArrayUtils.isEmpty((Object[])destinationCostUnits)) {
            return;
        }
        for (CostUnit sourceCostUnit : sourceCostUnits) {
            if (sourceCostUnit.getUsage() == null) continue;
            for (CostUnit destinationCostUnit : destinationCostUnits) {
                if (destinationCostUnit.getUsage() == null || !destinationCostUnit.getId().equals(sourceCostUnit.getId())) continue;
                Double usage = destinationCostUnit.getUsage() + sourceCostUnit.getUsage();
                destinationCostUnit.setUsage(usage);
            }
        }
    }

    public static String[] getShortFormattedCostUnitIds(CostUnit[] costUnits) {
        String[] result = new String[costUnits.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CostUnitUtil.getShortFormattedCostUnitId(costUnits[i].getId());
        }
        return result;
    }

    public static String getShortFormattedCostUnitId(String costUnitId) {
        ConfigurableCostUnitKey configurableCostUnit = CostUnitUtil.buildConfigurableCostUnitKey(costUnitId);
        String costUnitIdentifier = configurableCostUnit != null ? configurableCostUnit.costUnitIdentifier : costUnitId;
        String result = CostUnitUtil.getCatalogFormattedCostUnitId(costUnitIdentifier, COST_UNIT_LOCALIZATION_KEY_FORMATS, null);
        if (result == null) {
            result = CostUnitUtil.getLocalResourceBundleFormattedCostUnitId(costUnitIdentifier, COST_UNIT_LOCALIZATION_KEY_FORMATS, new String[0]);
        }
        return result == null ? costUnitId : result;
    }

    public static String[] getLongFormattedCostUnitIds(CostUnit[] costUnits) {
        String[] result = new String[costUnits.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = CostUnitUtil.getLongFormattedCostUnitId(costUnits[i].getId());
        }
        return result;
    }

    public static String getLongFormattedCostUnitId(String costUnitId) {
        String result = null;
        ConfigurableCostUnitKey configurableCostUnit = CostUnitUtil.buildConfigurableCostUnitKey(costUnitId);
        if (configurableCostUnit != null) {
            String cores = String.valueOf(configurableCostUnit.cores);
            String costUnitIdentifier = configurableCostUnit.costUnitIdentifier;
            KeyAnyValueImpl coresArg = new KeyAnyValueImpl();
            coresArg.setKey("0");
            coresArg.setValue((Object)cores);
            result = CostUnitUtil.getCatalogFormattedCostUnitId(costUnitIdentifier, COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS, new KeyAnyValue[]{coresArg});
            if (result == null) {
                result = CostUnitUtil.getLocalResourceBundleFormattedCostUnitId(costUnitIdentifier, COST_UNIT_LOCALIZATION_KEY_LONG_FORMATS, cores);
            }
        }
        if (result == null) {
            result = CostUnitUtil.getShortFormattedCostUnitId(costUnitId);
        }
        return result == null ? costUnitId : result;
    }

    public static ConfigurableCostUnitKey buildConfigurableCostUnitKey(String costUnitId) {
        Pattern pattern = Pattern.compile(MATCH_CONFIGURABLE_COST_UNIT_REGEX);
        Matcher matcher = pattern.matcher(costUnitId);
        ConfigurableCostUnitKey configurableCostUnit = null;
        if (matcher.matches()) {
            String costUnitIdentifier = CostUnitUtil.getCostUnitIdentifier(costUnitId);
            String coresAsText = matcher.group(CORES_REGEX_GROUP_NAME);
            int cores = 0;
            try {
                cores = Integer.parseInt(coresAsText);
            }
            catch (NumberFormatException ex) {
                switch (costUnitIdentifier) {
                    case "cpuPackage": {
                        cores = 32;
                        break;
                    }
                    case "cpuCore": {
                        cores = 16;
                    }
                }
            }
            configurableCostUnit = new ConfigurableCostUnitKey(cores, costUnitIdentifier);
        }
        return configurableCostUnit;
    }

    private static String getCatalogFormattedCostUnitId(String costUnitIdentifier, String[] costUnitLocalizationKeyFormats, KeyAnyValue[] args) {
        for (String costUnitLocalizationKeyFormat : costUnitLocalizationKeyFormats) {
            String costUnitLocalizationKey = String.format(costUnitLocalizationKeyFormat, costUnitIdentifier);
            String costUnitFormattedId = _messageLocalizer.getCatalogLocalizedString(costUnitLocalizationKey, args);
            if (costUnitFormattedId == null) continue;
            return costUnitFormattedId;
        }
        return null;
    }

    private static String getLocalResourceBundleFormattedCostUnitId(String costUnitIdentifier, String[] costUnitLocalizationKeyFormats, String ... params) {
        for (String costUnitLocalizationKeyFormat : costUnitLocalizationKeyFormats) {
            String costUnitLocalizationKey = String.format(costUnitLocalizationKeyFormat, costUnitIdentifier);
            String costUnitFormattedId = _messageLocalizer.getLocalizedString(costUnitLocalizationKey, params);
            if (costUnitFormattedId == null) continue;
            return costUnitFormattedId;
        }
        return null;
    }

    private static String getCostUnitIdentifier(String costUnitId) {
        String costUnitIdentifier = null;
        if (costUnitId.startsWith(CPU_PACKAGE_CORE_LIMIT_PREFIX)) {
            costUnitIdentifier = COST_UNIT_CPU_PACKAGE;
        } else if (costUnitId.startsWith(CORES_MINIMUM_LIMIT_PREFIX)) {
            costUnitIdentifier = COST_UNIT_CPU_CORE;
        }
        return costUnitIdentifier;
    }

    public static class ConfigurableCostUnitKey {
        int cores;
        String costUnitIdentifier;

        public ConfigurableCostUnitKey(int cores, String costUnitIdentifier) {
            this.cores = cores;
            this.costUnitIdentifier = costUnitIdentifier;
        }
    }

    static class ManagementUtilLocalizer
    implements Localizer {
        ManagementUtilLocalizer() {
        }

        @Override
        public String getCatalogLocalizedString(String key, KeyAnyValue[] args) {
            return ManagementUtil.getCatalogLocalizedString(key, args);
        }

        @Override
        public String getLocalizedString(String key, String ... parameters) {
            return ManagementUtil.getLocalizedString(key, parameters);
        }
    }

    static interface Localizer {
        public String getCatalogLocalizedString(String var1, KeyAnyValue[] var2);

        public String getLocalizedString(String var1, String ... var2);
    }
}

