/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.myvmwaresync.impl;

import com.vmware.license.client.cis.ls.LicenseClientProvider;
import com.vmware.license.client.cis.ls.LicenseScope;
import com.vmware.license.client.cis.management.ds.CostUnit;
import com.vmware.license.client.cis.management.ds.License;
import com.vmware.license.client.cis.management.ds.ProductRestriction;
import com.vmware.license.client.cis.management.util.LicenseUtil;
import com.vmware.license.client.cis.myvmwaresync.MyVMwareSyncException;
import com.vmware.license.client.cis.myvmwaresync.ds.results.MyVMwareSyncPreviewResult;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncCommitSpec;
import com.vmware.license.client.cis.myvmwaresync.ds.specs.MyVMwareSyncPreviewSpec;
import com.vmware.license.client.cis.myvmwaresync.impl.MyVMwareSyncEditorImpl;
import com.vmware.license.client.cis.myvmwaresync.util.MyVMwareSyncUtil;
import com.vmware.license.myvmware.client.sync.MyVMwareUtil;
import com.vmware.vim.binding.cis.license.fault.MyVMwareSyncFault;
import com.vmware.vim.binding.cis.license.management.MyVMwareLicenseReport;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncInfo;
import com.vmware.vim.binding.cis.license.management.MyVMwareSyncSpec;
import com.vmware.vim.binding.cis.license.management.SystemManagementService;
import com.vmware.vim.binding.vmodl.MethodFault;
import java.io.IOException;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MyVMwareSyncEditor67Impl
extends MyVMwareSyncEditorImpl {
    private final Log _logger = LogFactory.getLog(MyVMwareSyncEditor67Impl.class);

    public MyVMwareSyncEditor67Impl(LicenseClientProvider licenseClientProvider) {
        super(licenseClientProvider);
    }

    @Override
    public MyVMwareSyncPreviewResult previewSyncFromMyVMware(MyVMwareSyncPreviewSpec syncPreviewSpec, LicenseScope scope) {
        MyVMwareLicenseReport myVMwareLicenseReport;
        Validate.notNull((Object)syncPreviewSpec);
        Validate.notNull((Object)scope);
        Validate.notNull((Object)syncPreviewSpec.myVMwareFileContent);
        try {
            myVMwareLicenseReport = MyVMwareUtil.buildMyVMwareLicenseReport((byte[])syncPreviewSpec.myVMwareFileContent);
        }
        catch (IOException e) {
            throw new MyVMwareSyncException(e);
        }
        SystemManagementService sms = this.getSystemManagementService(scope);
        try {
            com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult serviceSyncPreviewResult = sms.previewMyVMwareSync(myVMwareLicenseReport);
            return this.buildUiSyncPreviewResult(serviceSyncPreviewResult, scope);
        }
        catch (MethodFault fault) {
            throw new MyVMwareSyncException(fault);
        }
    }

    @Override
    public void commitSyncFromMyVMware(MyVMwareSyncCommitSpec syncCommitSpec, LicenseScope scope) {
        Validate.notNull((Object)syncCommitSpec);
        Validate.notNull((Object)scope);
        SystemManagementService systemManagementService = this.getSystemManagementService(scope);
        MyVMwareSyncSpec syncSpec = MyVMwareSyncUtil.buildServiceMyVMwareSyncSpec(syncCommitSpec);
        this._logger.info((Object)"Attempting to perform sync with My VMware...");
        try {
            systemManagementService.performMyVMwareSync(syncSpec);
        }
        catch (MyVMwareSyncFault myVMwareSyncFault) {
            this._logger.warn((Object)myVMwareSyncFault.getLocalizedMessage(), (Throwable)myVMwareSyncFault);
            throw new MyVMwareSyncException(myVMwareSyncFault);
        }
    }

    @Override
    public com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo getSyncInfo(LicenseScope scope) throws MyVMwareSyncException {
        try {
            SystemManagementService systemManagementService = this.getSystemManagementService(scope);
            MyVMwareSyncInfo myVMwareSyncInfo = systemManagementService.queryLastMyVMwareSyncInfo();
            com.vmware.license.client.cis.myvmwaresync.ds.MyVMwareSyncInfo uiMyVMwareSyncInfo = MyVMwareSyncUtil.buildUiMyVMwareSyncInfo(myVMwareSyncInfo);
            return uiMyVMwareSyncInfo;
        }
        catch (Exception e) {
            throw new MyVMwareSyncException(e);
        }
    }

    @Override
    protected MyVMwareSyncPreviewResult buildUiSyncPreviewResult(com.vmware.vim.binding.cis.license.management.MyVMwareSyncPreviewResult serviceSyncPreviewResult, LicenseScope scope) {
        MyVMwareSyncPreviewResult uiSyncPreviewResult = super.buildUiSyncPreviewResult(serviceSyncPreviewResult, scope);
        License[] licensesForRemoval = LicenseUtil.createLicenses(serviceSyncPreviewResult.getInactiveUnassignedLicenses(), scope);
        this.setLicensesUsageTo0(licensesForRemoval);
        uiSyncPreviewResult.licensesForRemoval = licensesForRemoval;
        return uiSyncPreviewResult;
    }

    private void setLicensesUsageTo0(License[] licenses) {
        for (License license : licenses) {
            ProductRestriction[] productRestrictions;
            for (ProductRestriction productRestriction : productRestrictions = license.getProductRestrictions()) {
                CostUnit[] costUnits;
                for (CostUnit costUnit : costUnits = productRestriction.getProduct().getCostUnits()) {
                    costUnit.setUsage(0.0);
                }
            }
        }
    }
}

