/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.license.client.cis.subscription;

import com.vmware.license.client.cis.subscription.global.SubscriptionGlobalInfoRetriever;
import com.vmware.vise.extensionfw.ExtensionInfo;
import com.vmware.vise.extensionfw.ExtensionObjectFilter;
import com.vmware.vise.extensionfw.PropertyInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;

public class EntitlementTypeFilter
implements ExtensionObjectFilter {
    private static final String ENTITLEMENT_TYPE_SUBSCRIPTION = "subscription";
    private static final String ENTITLEMENT_TYPE_LICENSE = "license";
    private static final String ENTITLEMENT_TYPE_FILTER_METADATA_TAG = "entitlementType";
    private static final PropertyInfo[] CONTEXT_PROPS = new PropertyInfo[0];
    private static final PropertyInfo[] FILTER_PROPS;
    private final SubscriptionGlobalInfoRetriever _subscriptionGlobalInfoRetriever;

    public EntitlementTypeFilter(SubscriptionGlobalInfoRetriever subscriptionGlobalInfoRetriever) {
        this._subscriptionGlobalInfoRetriever = subscriptionGlobalInfoRetriever;
    }

    public boolean returnsInstantly() {
        return true;
    }

    public PropertyInfo[] getContextProperties() {
        return CONTEXT_PROPS;
    }

    public PropertyInfo[] getFilterProperties() {
        return FILTER_PROPS;
    }

    public List<ExtensionInfo> apply(List<ExtensionInfo> extensionInfos, Map<String, Object> filterContext) {
        Validate.notNull(extensionInfos);
        ArrayList<ExtensionInfo> finalExtensionInfosList = new ArrayList<ExtensionInfo>();
        boolean vcSubscribed = this._subscriptionGlobalInfoRetriever.areAnyVcsOnSubscription();
        for (ExtensionInfo extension : extensionInfos) {
            String entitlementType = (String)extension.getMetadata().get(ENTITLEMENT_TYPE_FILTER_METADATA_TAG);
            if (vcSubscribed && entitlementType.equals(ENTITLEMENT_TYPE_SUBSCRIPTION)) {
                finalExtensionInfosList.add(extension);
            }
            if (vcSubscribed || !entitlementType.equals(ENTITLEMENT_TYPE_LICENSE)) continue;
            finalExtensionInfosList.add(extension);
        }
        return finalExtensionInfosList;
    }

    static {
        PropertyInfo prop = new PropertyInfo();
        prop.name = ENTITLEMENT_TYPE_FILTER_METADATA_TAG;
        prop.type = String.class.getName();
        prop.optional = false;
        FILTER_PROPS = new PropertyInfo[]{prop};
    }
}

