/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vim.binding.vim.DiagnosticManager;
import com.vmware.vim.binding.vim.HostSystem;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.SessionManager;
import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vim.encryption.KmipServerInfo;
import com.vmware.vim.binding.vim.encryption.KmipServerSpec;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.util.Pair;
import com.vmware.vise.util.i18n.ResourceUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.folder.keyServers.KeyProviderCreateSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipServerInfoSpec;
import com.vmware.vsphere.client.folder.keyServers.KmsServerData;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FolderUtils {
    private static final Log _logger = LogFactory.getLog(FolderUtils.class);
    private static final String RESOURCE_BUNDLE_NAME = "FolderService";
    private static final String ERROR_INVALID_DIAGNOSTIC_MANAGER = "error.invalidDiagnosticManager";
    private static final String ERROR_INVALID_VC = "error.invalidVC";

    public static DiagnosticManager getDiagnosticManager(ManagedObjectReference vcRef) throws Exception {
        VcService service = FolderUtils.getVcService(vcRef);
        ServiceInstanceContent serviceContent = service.getServiceInstanceContent();
        if (serviceContent == null) {
            _logger.error((Object)"Could not retrieve ServiceInstanceContent");
            throw new RuntimeException(FolderUtils.getLocalizedString(ERROR_INVALID_DIAGNOSTIC_MANAGER));
        }
        return (DiagnosticManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)serviceContent.getDiagnosticManager());
    }

    public static VcService getVcService(ManagedObjectReference vcRef) {
        return FolderUtils.getVcService(vcRef, null);
    }

    public static VcService getVcService(ManagedObjectReference objRef, HttpSession session) {
        if (!ManagedObjectUtil.isRootFolder((ManagedObjectReference)objRef) && !ManagedObjectUtil.isOfType((ManagedObjectReference)objRef, HostSystem.class)) {
            _logger.error((Object)("Fetch invalid objRef = " + (objRef == null ? null : objRef.getValue())));
            throw new RuntimeException(FolderUtils.getLocalizedString(ERROR_INVALID_VC));
        }
        VcService service = VimSessionUtil.getService((String)objRef.getServerGuid(), (HttpSession)session);
        if (service == null) {
            _logger.error((Object)"Could not retrieve VcService");
            throw new RuntimeException(FolderUtils.getLocalizedString(ERROR_INVALID_VC));
        }
        return service;
    }

    public static boolean isVcRef(ManagedObjectReference vcRef) throws Exception {
        assert (vcRef != null && vcRef.getValue().equals("group-d1"));
        if (vcRef == null || StringUtils.isEmpty((CharSequence)vcRef.getServerGuid())) {
            throw new MethodFault(FolderUtils.getLocalizedString("error.nullObject"));
        }
        VcService service = VimSessionUtil.getService((String)vcRef.getServerGuid());
        if (service == null) {
            throw new MethodFault("error.notRootFolder");
        }
        ServiceInstanceContent content = service.getServiceInstanceContent();
        if (!FolderUtils.isApplicableRootFolder(vcRef, content)) {
            throw new MethodFault("error.notRootFolder");
        }
        return true;
    }

    public static SessionManager getSessionManager(ManagedObjectReference vcRef) throws Exception {
        assert (FolderUtils.isVcRef(vcRef));
        String serverGuid = vcRef.getServerGuid();
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            throw new MethodFault("error.notRootFolder");
        }
        ManagedObjectReference sessionManagerMOR = service.getServiceInstanceContent().sessionManager;
        SessionManager sessionManager = (SessionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)sessionManagerMOR);
        return sessionManager;
    }

    public static CryptoManagerKmip getCryptoManager(ManagedObjectReference moRef) throws Exception {
        String serverGuid = moRef.getServerGuid();
        VcService service = VimSessionUtil.getService((String)serverGuid);
        if (service == null) {
            throw new MethodFault("error.notRootFolder");
        }
        ManagedObjectReference cryptoManagerMOR = service.getServiceInstanceContent().cryptoManager;
        if (cryptoManagerMOR == null) {
            return null;
        }
        CryptoManagerKmip cryptoManagerKmip = (CryptoManagerKmip)ManagedObjectUtil.getManagedObject((ManagedObjectReference)cryptoManagerMOR);
        return cryptoManagerKmip;
    }

    public static String getLocalizedString(String key) {
        return ResourceUtil.getString((String)RESOURCE_BUNDLE_NAME, (String)key, (ClassLoader)FolderUtils.class.getClassLoader());
    }

    public static KmipServerSpec getKmipServerSpec(KmipServerInfoSpec data) {
        KmipServerInfo serverInfo = new KmipServerInfo();
        serverInfo.name = data.name;
        serverInfo.address = data.address;
        serverInfo.port = data.port;
        serverInfo.userName = data.username;
        serverInfo.proxyAddress = data.proxyAddress;
        serverInfo.proxyPort = data.proxyPort;
        KmipServerSpec serverSpec = new KmipServerSpec();
        serverSpec.clusterId = FolderUtils.getKmipProviderIdByName(data.clusterName);
        serverSpec.info = serverInfo;
        if (data.isPasswordChanged) {
            serverSpec.password = data.password;
        }
        return serverSpec;
    }

    public static Pair<KmipServerSpec, Boolean>[] getKmipServersSpec(KeyProviderCreateSpec spec) {
        int length = spec.kmsServers.length;
        Pair[] result = new Pair[length];
        for (int i = 0; i < length; ++i) {
            KmsServerData data = spec.kmsServers[i];
            KmipServerInfo serverInfo = new KmipServerInfo();
            serverInfo.name = data.name;
            serverInfo.address = data.address;
            serverInfo.port = data.port;
            serverInfo.userName = spec.username;
            serverInfo.proxyAddress = spec.proxyAddress;
            serverInfo.proxyPort = spec.proxyPort;
            KmipServerSpec clusterSpec = new KmipServerSpec();
            clusterSpec.clusterId = FolderUtils.getKmipProviderIdByName(spec.keyProviderId);
            clusterSpec.info = serverInfo;
            if (spec.isPasswordChanged) {
                clusterSpec.password = spec.password;
            }
            result[i] = new Pair((Object)clusterSpec, (Object)data.isUpdated);
        }
        return result;
    }

    public static boolean doesKmsServerExist(KmipClusterInfo clusterInfo, KmipServerSpec kmipServerSpec) {
        for (KmipServerInfo serverInfo : clusterInfo.servers) {
            if (!serverInfo.name.equals(kmipServerSpec.info.name)) continue;
            return true;
        }
        return false;
    }

    public static KeyProviderId getKmipProviderIdByName(String name) {
        KeyProviderId providerId = new KeyProviderId();
        providerId.id = name;
        return providerId;
    }

    private static boolean isApplicableRootFolder(ManagedObjectReference object, ServiceInstanceContent content) {
        if (content == null) {
            return false;
        }
        ManagedObjectReference contentRF = content.rootFolder;
        return ManagedObjectUtil.areEqual((ManagedObjectReference)object, (ManagedObjectReference)contentRF);
    }
}

