/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vapi.bindings.client.AsyncCallback;
import com.vmware.vapi.bindings.client.AsyncCallbackFuture;
import com.vmware.vcenter.deployment.ImportHistory;
import com.vmware.vim.binding.vim.Folder;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.binding.vmodl.MethodFault;
import com.vmware.vise.core.model.exception.CompositeException;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.DataServiceExtensionRegistry;
import com.vmware.vise.data.query.PropertyProviderAdapter;
import com.vmware.vise.data.query.PropertyRequestSpec;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSet;
import com.vmware.vise.data.query.TypeInfo;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.VcServiceUtil;
import com.vmware.vise.vim.vapi.VapiConnectionManager;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LazyLoadingDataMigrationPropertyProvider
implements PropertyProviderAdapter {
    private static final Log _logger = LogFactory.getLog(LazyLoadingDataMigrationPropertyProvider.class);
    private static final String LAZY_IMPORT_DATA = "lazyImportData";
    private final VapiConnectionManager _apiGwBasedConnectionManager;
    private final DataServiceExtensionRegistry _extensionRegistry;

    public LazyLoadingDataMigrationPropertyProvider(VapiConnectionManager apiGwBasedConnectionManager, DataServiceExtensionRegistry registry) {
        this._apiGwBasedConnectionManager = apiGwBasedConnectionManager;
        this._extensionRegistry = registry;
    }

    public void initialize() {
        this._extensionRegistry.registerDataAdapter((PropertyProviderAdapter)this, this.getProvidedTypeInfos());
    }

    private TypeInfo[] getProvidedTypeInfos() {
        TypeInfo ti = new TypeInfo();
        ti.type = Folder.class.getSimpleName();
        ti.properties = new String[]{LAZY_IMPORT_DATA};
        return new TypeInfo[]{ti};
    }

    public ResultSet getProperties(PropertyRequestSpec propertyRequest) {
        Instant startTime = Instant.now();
        _logger.info((Object)String.format("[getProperties] startedTime -- '%s'", startTime));
        Validate.notNull((Object)propertyRequest);
        Object[] vcObjects = propertyRequest.objects;
        PropertySpec[] properties = propertyRequest.properties;
        if (vcObjects == null || vcObjects.length == 0 || properties == null || properties.length == 0) {
            return null;
        }
        ResultSet result = new ResultSet();
        ArrayList<ResultItem> allResultItems = new ArrayList<ResultItem>();
        ArrayList<MethodFault> faults = new ArrayList<MethodFault>();
        HashMap<ManagedObjectReference, AsyncCallbackFuture> futures = new HashMap<ManagedObjectReference, AsyncCallbackFuture>(vcObjects.length);
        for (Object vcObject : vcObjects) {
            ManagedObjectReference moRef = (ManagedObjectReference)vcObject;
            if (moRef == null || !VcServiceUtil.is66VcOrLaterByServerGuid((String)moRef.getServerGuid())) continue;
            try {
                AsyncCallbackFuture f = new AsyncCallbackFuture();
                ImportHistory importHistory = (ImportHistory)this._apiGwBasedConnectionManager.createServiceStub(ImportHistory.class);
                importHistory.get((AsyncCallback)f, VapiUtil.newInvocationConfig((String)moRef.getServerGuid()));
                futures.put(moRef, f);
            }
            catch (Exception ex) {
                _logger.error((Object)String.format("Connection to ImportHistory service for vcenter '%s' failed.", moRef.getServerGuid()));
                faults.add(MixedUtil.getMethodFault((Throwable)ex));
            }
        }
        for (Map.Entry entry : futures.entrySet()) {
            try {
                ResultItem resultItem = new ResultItem();
                resultItem.resourceObject = entry.getKey();
                PropertyValue pv = new PropertyValue();
                pv.resourceObject = entry.getKey();
                pv.propertyName = LAZY_IMPORT_DATA;
                pv.value = ((AsyncCallbackFuture)entry.getValue()).get();
                resultItem.properties = new PropertyValue[]{pv};
                allResultItems.add(resultItem);
            }
            catch (InterruptedException | ExecutionException e) {
                _logger.error((Object)("Exception is thrown while retrieving lazyImportData properties" + e));
                faults.add(MixedUtil.getMethodFault((Throwable)e));
            }
        }
        result.items = allResultItems.toArray(new ResultItem[0]);
        if (faults.size() > 0) {
            result.error = new CompositeException(faults);
        }
        _logger.info((Object)String.format("[getProperties] execution finished and timeTaken to get lazyImportData for '%s' vCenters is '%s'", vcObjects.length, Duration.between(startTime, Instant.now())));
        return result;
    }
}

