/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder;

import com.vmware.vim.binding.vim.HistoricalInterval;
import com.vmware.vim.binding.vim.InternalServiceInstanceContent;
import com.vmware.vim.binding.vim.PerformanceManager;
import com.vmware.vim.binding.vim.ResourcePlanningManager;
import com.vmware.vim.binding.vim.ServiceInstance;
import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.option.OptionDef;
import com.vmware.vim.binding.vim.option.OptionManager;
import com.vmware.vim.binding.vim.option.OptionValue;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.util.feature.FeatureStateService;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vise.vim.security.LegacyAuthorizationService;
import com.vmware.vsphere.client.advancedsettings.AdvancedSettingsUtil;
import com.vmware.vsphere.client.folder.ServerSettingData;
import com.vmware.vsphere.client.folder.VcServerSettingsDataBuilder;
import com.vmware.vsphere.client.folder.VcServerSettingsMetadataBuilder;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class VcServerSettingsManager {
    private static final String PRIVILEGE_SYSTEM_READ = "System.Read";
    private static final String PRIVILEGE_GLOBAL_EDIT = "Global.Settings";
    private LegacyAuthorizationService _authService;
    private FeatureStateService _featureStateService;
    private ManagedObjectReference _vcRef;

    private static Boolean hasPrivilege(LegacyAuthorizationService authService, ManagedObjectReference ref, String privilege) throws Exception {
        Boolean hasPrivilege = authService.checkPrivileges(new ManagedObjectReference[]{ref}, new String[]{privilege});
        return hasPrivilege;
    }

    public VcServerSettingsManager(ManagedObjectReference vcRef, LegacyAuthorizationService authService, FeatureStateService featureStateService) throws IllegalArgumentException {
        if (!ManagedObjectUtil.isRootFolder((ManagedObjectReference)vcRef)) {
            throw new IllegalArgumentException("The provided argument is not a valid root folder reference");
        }
        if (authService == null) {
            throw new IllegalArgumentException("The provided argument is not a valid authorization service.");
        }
        this._vcRef = vcRef;
        this._authService = authService;
        this._featureStateService = featureStateService;
    }

    public OptionValue[] getVcSettings() throws Exception {
        OptionValue[] settings = new OptionValue[]{};
        if (this.hasReadPrivilege().booleanValue()) {
            OptionManager optionManager = this.getOptionManager();
            settings = optionManager.getSetting();
        }
        return settings;
    }

    public OptionDef[] getVcSettingDefinitions() throws Exception {
        OptionDef[] definitions = new OptionDef[]{};
        if (this.hasReadPrivilege().booleanValue()) {
            OptionManager optionManager = this.getOptionManager();
            definitions = optionManager.getSupportedOption();
        }
        return definitions;
    }

    public ServerSettingData getVcSettingData(String key) throws Exception {
        ServerSettingData result = new ServerSettingData();
        result.optionValue = this.findVcSetting(key);
        result.optionDef = this.findVcSettingDefinition(key);
        if (this.isNullOrEmpty(result.optionValue).booleanValue()) {
            return result;
        }
        Boolean hasPrivilege = this.hasEditPrivilege();
        if (!hasPrivilege.booleanValue()) {
            if (result.optionDef == null) {
                result.optionDef = AdvancedSettingsUtil.createDefaultOptionDef((String)key);
            }
            result.optionDef.optionType.valueIsReadonly = true;
        }
        return result;
    }

    public OptionValue findVcSetting(String key) throws Exception {
        OptionValue[] settings = this.getVcSettings();
        OptionValue result = AdvancedSettingsUtil.findOptionValue((OptionValue[])settings, (String)key);
        if (result == null) {
            result = new OptionValue();
        }
        return result;
    }

    public OptionDef findVcSettingDefinition(String key) throws Exception {
        OptionDef[] definitions = this.getVcSettingDefinitions();
        return AdvancedSettingsUtil.findOptionDef((OptionDef[])definitions, (String)key);
    }

    public VcServerSettingsMetadataBuilder createMetadataBuilder() throws Exception {
        OptionDef[] definitions = this.getVcSettingDefinitions();
        Boolean allowEdit = this.hasEditPrivilege();
        VcServerSettingsMetadataBuilder metadataBuilder = new VcServerSettingsMetadataBuilder(this._featureStateService, definitions, allowEdit);
        return metadataBuilder;
    }

    public VcServerSettingsDataBuilder createDataBuilder() throws Exception {
        OptionValue[] settings = this.getVcSettings();
        VcServerSettingsDataBuilder dataBuilder = new VcServerSettingsDataBuilder(this._featureStateService, settings);
        return dataBuilder;
    }

    public HistoricalInterval[] getHistoricalIntervals() throws Exception {
        HistoricalInterval[] historicalInterval = new HistoricalInterval[]{};
        if (this.hasReadPrivilege().booleanValue()) {
            PerformanceManager perfManager = this.getPerformanceManager();
            historicalInterval = perfManager.getHistoricalInterval();
        }
        return historicalInterval;
    }

    public Long getEstimatedDastabaseSize(ResourcePlanningManager.DatabaseSizeParam dbSizeParam) throws Exception {
        if (!this.hasReadPrivilege().booleanValue()) {
            return 0L;
        }
        if (dbSizeParam.perfStatsDesc == null || dbSizeParam.perfStatsDesc.intervals == null) {
            dbSizeParam.perfStatsDesc = new ResourcePlanningManager.PerfStatsDescription();
            dbSizeParam.perfStatsDesc.intervals = this.getHistoricalIntervals();
        }
        ResourcePlanningManager rpManager = this.getResourcePlanningManager();
        ResourcePlanningManager.DatabaseSizeEstimate estimatedDbSize = rpManager.estimateDatabaseSize(dbSizeParam);
        return estimatedDbSize.size;
    }

    public void updateVcSettings(Map<String, Object> changeSet) throws Exception {
        if (changeSet == null || changeSet.isEmpty()) {
            return;
        }
        OptionValue[] values = AdvancedSettingsUtil.convertOptionMapToOptionValues(changeSet);
        OptionDef[] definitions = this.getVcSettingDefinitions();
        values = AdvancedSettingsUtil.transformAdvancedSettingsValueTypes((OptionValue[])values, (OptionDef[])definitions);
        OptionManager optionManager = this.getOptionManager();
        optionManager.updateValues(values);
    }

    public void updateHistoricalIntervals(HistoricalInterval[] intervals) throws Exception {
        if (ArrayUtils.isEmpty((Object[])intervals)) {
            return;
        }
        PerformanceManager perfManager = this.getPerformanceManager();
        HistoricalInterval[] oldIntervals = perfManager.getHistoricalInterval();
        HistoricalInterval[] newIntervals = new HistoricalInterval[intervals.length];
        System.arraycopy(intervals, 0, newIntervals, 0, intervals.length);
        Arrays.sort(newIntervals, new HistoricalIntervalKeyComparator());
        Stack<HistoricalInterval> deferredIntervals = new Stack<HistoricalInterval>();
        for (HistoricalInterval newInterval : newIntervals) {
            Integer newLevel = newInterval.getLevel();
            Integer oldLevel = null;
            for (HistoricalInterval oldInterval : oldIntervals) {
                if (newInterval.getKey() != oldInterval.getKey()) continue;
                oldLevel = oldInterval.getLevel();
                break;
            }
            if (oldLevel != null && newLevel < oldLevel) {
                deferredIntervals.add(newInterval);
                continue;
            }
            perfManager.updateHistoricalInterval(newInterval);
        }
        while (!deferredIntervals.empty()) {
            HistoricalInterval newInterval = (HistoricalInterval)deferredIntervals.pop();
            perfManager.updateHistoricalInterval(newInterval);
        }
    }

    private OptionManager getOptionManager() throws Exception {
        String serverGuid = this._vcRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        OptionManager optionManager = (OptionManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.setting);
        return optionManager;
    }

    private PerformanceManager getPerformanceManager() throws Exception {
        String serverGuid = this._vcRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ServiceInstanceContent content = vcService.getServiceInstanceContent();
        PerformanceManager perfManager = (PerformanceManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)content.perfManager);
        return perfManager;
    }

    private ResourcePlanningManager getResourcePlanningManager() throws Exception {
        String serverGuid = this._vcRef.getServerGuid();
        VcService vcService = VimSessionUtil.getService((String)serverGuid);
        ServiceInstance serviceInstance = vcService.getServiceInstance();
        InternalServiceInstanceContent internalContent = serviceInstance.retrieveInternalContent();
        ResourcePlanningManager resourcePlanningManager = (ResourcePlanningManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)internalContent.resourcePlanningManager);
        return resourcePlanningManager;
    }

    private Boolean isNullOrEmpty(OptionValue optionValue) {
        Boolean isNullOrEmpty = optionValue == null || StringUtils.isEmpty((CharSequence)optionValue.key) && optionValue.value == null;
        return isNullOrEmpty;
    }

    private Boolean hasReadPrivilege() throws Exception {
        Boolean hasPrivilege = VcServerSettingsManager.hasPrivilege(this._authService, this._vcRef, PRIVILEGE_SYSTEM_READ);
        return hasPrivilege;
    }

    private Boolean hasEditPrivilege() throws Exception {
        Boolean hasPrivilege = VcServerSettingsManager.hasPrivilege(this._authService, this._vcRef, PRIVILEGE_GLOBAL_EDIT);
        return hasPrivilege;
    }

    class HistoricalIntervalKeyComparator
    implements Comparator<HistoricalInterval> {
        HistoricalIntervalKeyComparator() {
        }

        @Override
        public int compare(HistoricalInterval x, HistoricalInterval y) {
            return Integer.valueOf(x.getKey()).compareTo(y.getKey());
        }
    }
}

