/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vim.binding.vim.TaskInfo;
import com.vmware.vim.binding.vim.encryption.CryptoManagerKmip;
import com.vmware.vim.binding.vim.encryption.KeyProviderId;
import com.vmware.vim.binding.vim.encryption.KmipClusterInfo;
import com.vmware.vim.binding.vim.encryption.KmipServerInfo;
import com.vmware.vim.binding.vim.fault.NoPermission;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vim.vmomi.core.Future;
import com.vmware.vim.vmomi.core.impl.BlockingFuture;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vise.vim.commons.i18n.LocalizationUtil;
import com.vmware.vise.vim.tasks.TaskMonitor;
import com.vmware.vsphere.client.folder.CertificateStatusExpDate;
import com.vmware.vsphere.client.folder.FolderUtils;
import com.vmware.vsphere.client.folder.KeyProviderData;
import com.vmware.vsphere.client.folder.KeyProvidersWithStatusData;
import com.vmware.vsphere.client.folder.KmipServerData;
import com.vmware.vsphere.client.folder.keyServers.KeyProviderRetrieveServerCertificatesSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipClusterStatusSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipRetrieveServerCertificateSpec;
import com.vmware.vsphere.client.folder.keyServers.KmipServerInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCenterKmipPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VCenterKmipPropertyProvider.class);
    public static final int SECONDS_PER_DAY = 86400;
    private final TaskMonitor _taskMonitor;

    public VCenterKmipPropertyProvider(TaskMonitor taskMonitor) {
        this._taskMonitor = taskMonitor;
    }

    @type(value="Folder")
    public KmipClusterInfo[] getKmipClusters(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        return cryptoManagerKmip.listKmipServers(null);
    }

    @type(value="Folder")
    public KmipClusterStatusSpec getH5DefaultKmipClusterStatus(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        try {
            KmipClusterInfo[] clusters = cryptoManagerKmip.listKmipServers(null);
            KmipClusterInfo defaultCluster = this.getDefaultKmsClusterFromInfos(clusters);
            if (defaultCluster == null) {
                return null;
            }
            KmipClusterStatusSpec result = new KmipClusterStatusSpec();
            if (KmipClusterInfo.KmsManagementType.nativeProvider.toString().equals(defaultCluster.managementType)) {
                result.connectionStatus = KmipServerInfo.ConnectionStatus.CONNECTED.name();
                result.certificateStatus = KmipServerInfo.CertStatus.GOOD;
                return result;
            }
            ManagedObjectReference task = cryptoManagerKmip.retrieveKmipServersStatus(new KmipClusterInfo[]{defaultCluster});
            TaskInfo taskInfo = this._taskMonitor.monitorTask(task);
            result.noPermission = false;
            result.name = defaultCluster.clusterId.id;
            if (taskInfo.error != null) {
                _logger.error((Object)"Error while retrieving Task Info", (Throwable)taskInfo.error);
                result.connectionStatus = KmipServerInfo.ConnectionStatus.ERROR_RETRIEVING.name();
                result.certificateStatus = KmipServerInfo.CertStatus.ERROR_RETRIEVING;
                return result;
            }
            CryptoManagerKmip.ClusterStatus clusterStatus = ((CryptoManagerKmip.ClusterStatus[])taskInfo.result)[0];
            result.connectionStatus = KmipServerInfo.ConnectionStatus.NO_TRUST_CONNECTION.name();
            result.certificateStatus = this.getCertificateStatus((CryptoManagerKmip.CertificateInfo)clusterStatus.clientCertInfo).certStatus;
            for (CryptoManagerKmip.ServerStatus serverStatus : clusterStatus.servers) {
                if (!result.connectionStatus.equals(KmipServerInfo.ConnectionStatus.NO_TRUST_CONNECTION.name())) continue;
                result.connectionStatus = this.getConnectionStatus(serverStatus);
            }
            return result;
        }
        catch (NoPermission e) {
            KmipClusterStatusSpec result = new KmipClusterStatusSpec();
            result.noPermission = true;
            return result;
        }
    }

    @type(value="Folder")
    public Map<String, com.vmware.vsphere.client.folder.keyServers.KmipServerInfo> getH5KmipServerInfos(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        LinkedHashMap<String, com.vmware.vsphere.client.folder.keyServers.KmipServerInfo> kmipServerInfoSpecsByName = new LinkedHashMap<String, com.vmware.vsphere.client.folder.keyServers.KmipServerInfo>();
        if (cryptoManagerKmip == null) {
            return kmipServerInfoSpecsByName;
        }
        Object[] kmipClusterInfos = cryptoManagerKmip.listKmipServers(null);
        if (ArrayUtils.isEmpty((Object[])kmipClusterInfos)) {
            return kmipServerInfoSpecsByName;
        }
        for (Object clusterInfo : kmipClusterInfos) {
            for (KmipServerInfo serverInfo : ((KmipClusterInfo)clusterInfo).servers) {
                com.vmware.vsphere.client.folder.keyServers.KmipServerInfo kmipServerInfo = new com.vmware.vsphere.client.folder.keyServers.KmipServerInfo();
                kmipServerInfoSpecsByName.put(((KmipClusterInfo)clusterInfo).clusterId.id + serverInfo.name, kmipServerInfo);
                kmipServerInfo.name = serverInfo.name;
                kmipServerInfo.clusterName = ((KmipClusterInfo)clusterInfo).clusterId.id;
                kmipServerInfo.useAsDefault = ((KmipClusterInfo)clusterInfo).useAsDefault;
                kmipServerInfo.address = serverInfo.address;
                kmipServerInfo.port = serverInfo.port;
                kmipServerInfo.proxyAddress = serverInfo.proxyAddress;
                kmipServerInfo.proxyPort = serverInfo.proxyPort;
                kmipServerInfo.username = serverInfo.userName;
            }
        }
        return kmipServerInfoSpecsByName;
    }

    @type(value="Folder")
    public Map<String, com.vmware.vsphere.client.folder.keyServers.KmipServerInfo> getH5KmipServerInfosWithStatus(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip.ClusterStatus[] clusterStatuses;
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        LinkedHashMap<String, com.vmware.vsphere.client.folder.keyServers.KmipServerInfo> kmipServerInfoSpecsByName = new LinkedHashMap<String, com.vmware.vsphere.client.folder.keyServers.KmipServerInfo>();
        if (cryptoManagerKmip == null) {
            return kmipServerInfoSpecsByName;
        }
        Object[] kmipClusterInfos = cryptoManagerKmip.listKmipServers(null);
        if (ArrayUtils.isEmpty((Object[])kmipClusterInfos)) {
            return kmipServerInfoSpecsByName;
        }
        for (Object clusterInfo : kmipClusterInfos) {
            KmipServerInfo[] kmipServerInfoArray = ((KmipClusterInfo)clusterInfo).servers;
            int n = kmipServerInfoArray.length;
            for (int i = 0; i < n; ++i) {
                KmipServerInfo serverInfo = kmipServerInfoArray[i];
                com.vmware.vsphere.client.folder.keyServers.KmipServerInfo kmipServerInfo = new com.vmware.vsphere.client.folder.keyServers.KmipServerInfo();
                kmipServerInfoSpecsByName.put(((KmipClusterInfo)clusterInfo).clusterId.id + serverInfo.name, kmipServerInfo);
                kmipServerInfo.name = serverInfo.name;
                kmipServerInfo.clusterName = ((KmipClusterInfo)clusterInfo).clusterId.id;
                kmipServerInfo.useAsDefault = ((KmipClusterInfo)clusterInfo).useAsDefault;
                kmipServerInfo.address = serverInfo.address;
                kmipServerInfo.port = serverInfo.port;
                kmipServerInfo.proxyAddress = serverInfo.proxyAddress;
                kmipServerInfo.proxyPort = serverInfo.proxyPort;
                kmipServerInfo.username = serverInfo.userName;
            }
        }
        ManagedObjectReference task = cryptoManagerKmip.retrieveKmipServersStatus((KmipClusterInfo[])kmipClusterInfos);
        TaskInfo taskInfo = this._taskMonitor.monitorTask(task);
        if (taskInfo.error != null) {
            _logger.error((Object)"Error while retrieving Task Info", (Throwable)taskInfo.error);
            for (com.vmware.vsphere.client.folder.keyServers.KmipServerInfo serverInfo : kmipServerInfoSpecsByName.values()) {
                serverInfo.connectionStatus = KmipServerInfo.ConnectionStatus.ERROR_RETRIEVING.name();
                serverInfo.clusterCertificateStatus = KmipServerInfo.CertStatus.ERROR_RETRIEVING;
                serverInfo.serverCertificateStatus = KmipServerInfo.CertStatus.ERROR_RETRIEVING;
                serverInfo.certificateErrorMessage = taskInfo.error.getMessage();
            }
            return kmipServerInfoSpecsByName;
        }
        for (CryptoManagerKmip.ClusterStatus clusterStatus : clusterStatuses = (CryptoManagerKmip.ClusterStatus[])taskInfo.result) {
            for (CryptoManagerKmip.ServerStatus serverStatus : clusterStatus.servers) {
                com.vmware.vsphere.client.folder.keyServers.KmipServerInfo h5KmipServerInfo = (com.vmware.vsphere.client.folder.keyServers.KmipServerInfo)kmipServerInfoSpecsByName.get(clusterStatus.clusterId.id + serverStatus.name);
                h5KmipServerInfo.connectionStatus = this.getConnectionStatus(serverStatus);
                CertificateStatusExpDate serverExpDate = this.getCertificateStatus(serverStatus.certInfo);
                h5KmipServerInfo.serverCertificateStatus = serverExpDate.certStatus;
                h5KmipServerInfo.serverExpirationDate = serverExpDate.expirationDateRaw;
                h5KmipServerInfo.serverSecondsBeforeExpiration = serverExpDate.secondsBeforeExpire;
                CertificateStatusExpDate clusterStatusExpDate = this.getCertificateStatus(clusterStatus.clientCertInfo);
                h5KmipServerInfo.clusterCertificateStatus = clusterStatusExpDate.certStatus;
                h5KmipServerInfo.clusterExpirationDate = clusterStatusExpDate.expirationDateRaw;
                h5KmipServerInfo.clusterSecondsBeforeExpiration = clusterStatusExpDate.secondsBeforeExpire;
            }
        }
        return kmipServerInfoSpecsByName;
    }

    @type(value="Folder")
    public KeyProvidersWithStatusData getKeyProviders(ManagedObjectReference vcRef) throws Exception {
        return this.getKeyProvidersByType(vcRef, 3);
    }

    @type(value="Folder")
    public KeyProvidersWithStatusData getAvailableTrustedKeyProviders(ManagedObjectReference vcRef) throws Exception {
        return this.getKeyProvidersByType(vcRef, 4);
    }

    private KeyProvidersWithStatusData getKeyProvidersByType(ManagedObjectReference vcRef, int providerType) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        KmipClusterInfo[] kmsClusters = cryptoManagerKmip.listKmsClusters(Boolean.valueOf(true), Integer.valueOf(providerType), Integer.valueOf(-1));
        if (kmsClusters == null) {
            return new KeyProvidersWithStatusData();
        }
        KeyProviderId defaultKmsCluster = cryptoManagerKmip.getDefaultKmsCluster(vcRef, Boolean.valueOf(true));
        String defaultKmsClusterId = defaultKmsCluster != null ? defaultKmsCluster.id : null;
        HashMap<String, KmipClusterInfo> kmsClustersById = new HashMap<String, KmipClusterInfo>();
        for (KmipClusterInfo clusterInfo : kmsClusters) {
            if (clusterInfo.servers == null) {
                clusterInfo.servers = new KmipServerInfo[0];
            }
            kmsClustersById.put(clusterInfo.clusterId.id, clusterInfo);
        }
        ArrayList<KeyProviderData> result = new ArrayList<KeyProviderData>();
        for (KmipClusterInfo clusterInfo : kmsClusters) {
            KeyProviderData status = new KeyProviderData();
            status.keyProviderName = clusterInfo.clusterId.id;
            status.managementType = clusterInfo.managementType;
            status.serversNotConnectedCount = -1;
            status.vcenterCertificateIssuesCount = -1;
            status.serverCertificateIssuesCount = -1;
            status.isDefaultKeyProvider = clusterInfo.clusterId.id.equals(defaultKmsClusterId);
            result.add(status);
            ArrayList<KmipServerData> serverStatuses = new ArrayList<KmipServerData>();
            KmipServerInfo firstServerInfo = null;
            for (KmipServerInfo serverInfo : clusterInfo.servers) {
                KmipServerData kmsData = new KmipServerData();
                if (serverInfo != null) {
                    kmsData.keyProviderName = status.keyProviderName;
                    kmsData.name = serverInfo.name;
                    kmsData.address = serverInfo.address;
                    kmsData.port = serverInfo.port;
                }
                if (firstServerInfo == null) {
                    firstServerInfo = serverInfo;
                } else if (!(Objects.equals(firstServerInfo.proxyAddress, serverInfo.proxyAddress) && Objects.equals(firstServerInfo.proxyPort, serverInfo.proxyPort) && Objects.equals(firstServerInfo.userName, serverInfo.userName))) {
                    status.hasDiffOptionalSettings = true;
                }
                kmsData.connectionStatus = KmipServerInfo.ConnectionStatus.RETRIEVING.name();
                CertificateStatusExpDate certificateStatusExpDate = new CertificateStatusExpDate();
                certificateStatusExpDate.certStatus = KmipServerInfo.CertStatus.NA;
                kmsData.serverExpDate = certificateStatusExpDate;
                kmsData.clusterExpDate = certificateStatusExpDate;
                serverStatuses.add(kmsData);
            }
            if (firstServerInfo != null && !status.hasDiffOptionalSettings) {
                status.proxyAddress = firstServerInfo.proxyAddress;
                status.proxyPort = firstServerInfo.proxyPort;
                status.username = firstServerInfo.userName;
            }
            status.servers = serverStatuses.toArray(new KmipServerData[0]);
        }
        KeyProvidersWithStatusData keyProvidersWithStatusData = new KeyProvidersWithStatusData();
        keyProvidersWithStatusData.keyProviderData = result.toArray(new KeyProviderData[0]);
        keyProvidersWithStatusData.statusRetreivalTask = cryptoManagerKmip.retrieveKmipServersStatus(kmsClusters);
        return keyProvidersWithStatusData;
    }

    private CertificateStatusExpDate getCertificateStatus(CryptoManagerKmip.CertificateInfo certInfo) {
        CertificateStatusExpDate certificateStatusExpDate = new CertificateStatusExpDate();
        if (certInfo == null) {
            return certificateStatusExpDate;
        }
        if (certInfo.secondsBeforeExpire <= 0) {
            certificateStatusExpDate.certStatus = KmipServerInfo.CertStatus.EXPIRED;
        } else if (certInfo.secondsBeforeExpire <= 432000) {
            certificateStatusExpDate.certStatus = KmipServerInfo.CertStatus.ABOUT_TO_EXPIRE;
            certificateStatusExpDate.secondsBeforeExpire = certInfo.secondsBeforeExpire;
        } else {
            certificateStatusExpDate.certStatus = KmipServerInfo.CertStatus.GOOD;
            certificateStatusExpDate.expirationDateRaw = certInfo.notAfter.getTime();
            certificateStatusExpDate.expirationDate = LocalizationUtil.formatLocalizedDate((Date)certInfo.notAfter.getTime());
        }
        return certificateStatusExpDate;
    }

    private String getConnectionStatus(CryptoManagerKmip.ServerStatus serverStatus) {
        if (serverStatus.serverTrustClient.booleanValue() && serverStatus.clientTrustServer.booleanValue()) {
            return KmipServerInfo.ConnectionStatus.CONNECTED.name();
        }
        if (serverStatus.clientTrustServer != null && serverStatus.clientTrustServer.booleanValue()) {
            return KmipServerInfo.ConnectionStatus.CLIENT_TRUST_SERVER.name();
        }
        if (serverStatus.serverTrustClient != null && serverStatus.serverTrustClient.booleanValue()) {
            return KmipServerInfo.ConnectionStatus.SERVER_TRUST_CLIENT.name();
        }
        return KmipServerInfo.ConnectionStatus.NO_TRUST_CONNECTION.name();
    }

    @type(value="Folder")
    public boolean getDefaultKmsClusterExists(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return false;
        }
        try {
            KmipClusterInfo[] kmipClusterInfos = cryptoManagerKmip.listKmipServers(null);
            return this.getDefaultKmsClusterFromInfos(kmipClusterInfos) != null;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve kms servers, returning true opportunistically.", (Throwable)e);
            return true;
        }
    }

    @type(value="Folder")
    public String getDefaultKmsClusterId(ManagedObjectReference vcRef) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return "";
        }
        try {
            return cryptoManagerKmip.getDefaultKmsCluster((ManagedObjectReference)vcRef, (Boolean)Boolean.valueOf((boolean)true)).id;
        }
        catch (Exception e) {
            _logger.error((Object)"Failed to retrieve getDefaultKmsCluster", (Throwable)e);
            return "";
        }
    }

    @type(value="Folder")
    public OperationResult getKmipClustersStatus(ManagedObjectReference vcRef, Object[] infos) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KmipClusterInfo[] clustersInfo = (KmipClusterInfo[])Arrays.copyOf(infos, infos.length, KmipClusterInfo[].class);
        OperationResult opResult = new OperationResult();
        opResult.entity = vcRef;
        try {
            opResult.task = cryptoManagerKmip.retrieveKmipServersStatus(clustersInfo);
        }
        catch (Exception exp) {
            _logger.error((Object)"Error retrieving kmip clusters and servers status.", (Throwable)MixedUtil.getMethodFault((Throwable)exp));
            opResult.error = MixedUtil.getMethodFault((Throwable)exp);
        }
        return opResult;
    }

    @type(value="Folder")
    public CryptoManagerKmip.ServerCertInfo getKmipServerTrustedCertificate(ManagedObjectReference vcRef, KmipRetrieveServerCertificateSpec spec) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(spec.clusterName);
        return cryptoManagerKmip.retrieveKmipServerCert(clusterId, spec.serverInfo);
    }

    @type(value="Folder")
    public CryptoManagerKmip.ServerCertInfo[] getKeyProviderTrustedCertificates(ManagedObjectReference vcRef, KeyProviderRetrieveServerCertificatesSpec spec) throws Exception {
        int i;
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(spec.keyProviderId);
        int serversCount = spec.serversInfo.length;
        BlockingFuture[] futures = new BlockingFuture[serversCount];
        CryptoManagerKmip.ServerCertInfo[] certificates = new CryptoManagerKmip.ServerCertInfo[serversCount];
        for (i = 0; i < serversCount; ++i) {
            BlockingFuture future;
            futures[i] = future = new BlockingFuture();
            cryptoManagerKmip.retrieveKmipServerCert(clusterId, spec.serversInfo[i], (Future)future);
        }
        for (i = 0; i < serversCount; ++i) {
            certificates[i] = (CryptoManagerKmip.ServerCertInfo)futures[i].get();
        }
        return certificates;
    }

    @type(value="Folder")
    public String getKmipCsrCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        String certificate = cryptoManagerKmip.retrieveClientCsr(clusterId);
        if (StringUtils.isEmpty((CharSequence)certificate)) {
            certificate = cryptoManagerKmip.generateClientCsr(clusterId, null);
        }
        return certificate;
    }

    @type(value="Folder")
    public String getKmipNewCsrCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        return cryptoManagerKmip.generateClientCsr(clusterId, null);
    }

    @type(value="Folder")
    public String getKmipClientCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        String certificate = cryptoManagerKmip.retrieveClientCert(clusterId);
        if (StringUtils.isEmpty((CharSequence)certificate)) {
            certificate = cryptoManagerKmip.generateSelfSignedClientCert(clusterId, null);
            cryptoManagerKmip.updateSelfSignedClientCert(clusterId, certificate);
        }
        return certificate;
    }

    @type(value="Folder")
    public String getKmipNewClientCertificate(ManagedObjectReference vcRef, String clusterName) throws Exception {
        CryptoManagerKmip cryptoManagerKmip = FolderUtils.getCryptoManager(vcRef);
        if (cryptoManagerKmip == null) {
            return null;
        }
        KeyProviderId clusterId = FolderUtils.getKmipProviderIdByName(clusterName);
        return cryptoManagerKmip.generateSelfSignedClientCert(clusterId, null);
    }

    private KmipClusterInfo getDefaultKmsClusterFromInfos(KmipClusterInfo[] kmipClusterInfos) {
        if (kmipClusterInfos != null) {
            for (KmipClusterInfo kmipClusterInfo : kmipClusterInfos) {
                if (!kmipClusterInfo.useAsDefault) continue;
                return kmipClusterInfo;
            }
        }
        return null;
    }
}

