/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.folder.impl;

import com.vmware.vapi.bindings.client.InvocationConfig;
import com.vmware.vcenter.trusted_infrastructure.NetworkAddress;
import com.vmware.vcenter.trusted_infrastructure.attestation.ServicesTypes;
import com.vmware.vcenter.trusted_infrastructure.kms.Services;
import com.vmware.vcenter.trusted_infrastructure.kms.ServicesTypes;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vise.vim.vapi.util.VapiUtil;
import com.vmware.vsphere.client.folder.TrustedHostData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VCenterLangleyKmsPropertyProvider
implements PropertyProviderBean {
    private static final Log _logger = LogFactory.getLog(VCenterLangleyKmsPropertyProvider.class);
    private final Services _kmsServices;
    private final com.vmware.vcenter.trusted_infrastructure.attestation.Services _attestationServices;
    private static final String PROP_IS_TRUSTED_HOST_SERVICES_ENABLED = "isTrustedHostServicesEnabled";

    public VCenterLangleyKmsPropertyProvider(Services kmsServices, com.vmware.vcenter.trusted_infrastructure.attestation.Services attestationServices) {
        this._kmsServices = kmsServices;
        this._attestationServices = attestationServices;
    }

    @type(value="Folder")
    public boolean getIsTrustedClusterAvailable(ManagedObjectReference rootFolderRef) throws Exception {
        ServicesTypes.FilterSpec kmsFilterSpec = new ServicesTypes.FilterSpec();
        String nodeUuid = rootFolderRef.getServerGuid();
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
        List kmsServicesSummary = this._kmsServices.list(kmsFilterSpec, invConfig);
        boolean hasKmsServices = !kmsServicesSummary.isEmpty();
        ServicesTypes.FilterSpec attestationFilterSpec = new ServicesTypes.FilterSpec();
        List attestationServicesSummary = this._attestationServices.list(attestationFilterSpec, invConfig);
        boolean hasAttestationServices = !attestationServicesSummary.isEmpty();
        return hasKmsServices && hasAttestationServices;
    }

    @type(value="Folder")
    public List<TrustedHostData> getTrustedHosts(ManagedObjectReference rootFolderRef) throws Exception {
        HashMap<NetworkAddress, TrustedHostData> result = new HashMap<NetworkAddress, TrustedHostData>();
        String nodeUuid = rootFolderRef.getServerGuid();
        InvocationConfig invConfig = VapiUtil.newInvocationConfig((String)nodeUuid);
        ServicesTypes.FilterSpec kmsFilterSpec = new ServicesTypes.FilterSpec();
        List kmsServicesSummary = this._kmsServices.list(kmsFilterSpec, invConfig);
        for (ServicesTypes.Summary kmsServiceSummary : kmsServicesSummary) {
            TrustedHostData hostData = (TrustedHostData)result.get(kmsServiceSummary.getAddress());
            if (hostData == null) {
                hostData = new TrustedHostData();
                hostData.address = kmsServiceSummary.getAddress();
                result.put(kmsServiceSummary.getAddress(), hostData);
            }
            hostData.kmsService = kmsServiceSummary;
        }
        ServicesTypes.FilterSpec attestationFilterSpec = new ServicesTypes.FilterSpec();
        List attestationServicesSummary = this._attestationServices.list(attestationFilterSpec, invConfig);
        for (ServicesTypes.Summary attestationServiceSummary : attestationServicesSummary) {
            TrustedHostData hostData = (TrustedHostData)result.get(attestationServiceSummary.getAddress());
            if (hostData == null) {
                hostData = new TrustedHostData();
                hostData.address = attestationServiceSummary.getAddress();
                result.put(attestationServiceSummary.getAddress(), hostData);
            }
            hostData.attestationService = attestationServiceSummary;
        }
        return new ArrayList<TrustedHostData>(result.values());
    }
}

