/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.dscluster.model;

import com.vmware.cis.data.model.NestedQueryBinding;
import com.vmware.cis.data.model.Property;
import com.vmware.cis.data.model.QueryBinding;
import com.vmware.cis.data.model.Relationship;
import com.vmware.vim.binding.vim.vm.device.VirtualDevice;
import com.vmware.vim.binding.vim.vm.device.VirtualDisk;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vsphere.client.drs.model.DatastoreNameData;
import com.vmware.vsphere.client.drs.model.IdentifiableModelImpl;
import com.vmware.vsphere.client.drs.model.TargetNameData;
import java.util.HashMap;
import java.util.Map;

@QueryBinding(value="VirtualMachine")
public class SdrsFaultVmData
extends IdentifiableModelImpl
implements TargetNameData {
    @Property(value="VirtualMachine/name")
    private String name;
    @Property(value="VirtualMachine/virtualDisks")
    private VirtualDisk[] virtualDisks;
    @NestedQueryBinding
    @Relationship(value={"VirtualMachine/datastore"})
    private DatastoreNameData[] datastores;
    private Map<Integer, VirtualDisk> virtualDisksById;
    private Map<ManagedObjectReference, DatastoreNameData> datastoresByUid;

    public String getName() {
        return this.name;
    }

    private Map<Integer, VirtualDisk> getVirtualDisksById() {
        if (this.virtualDisksById == null) {
            this.virtualDisksById = new HashMap<Integer, VirtualDisk>();
            for (VirtualDisk virtualDisk : this.virtualDisks) {
                this.virtualDisksById.put(virtualDisk.getKey(), virtualDisk);
            }
        }
        return this.virtualDisksById;
    }

    private Map<ManagedObjectReference, DatastoreNameData> getDatastoresByUid() {
        if (this.datastoresByUid == null) {
            this.datastoresByUid = new HashMap<ManagedObjectReference, DatastoreNameData>();
            for (DatastoreNameData datastore : this.datastores) {
                if (!(datastore.getProvider() instanceof ManagedObjectReference)) continue;
                this.datastoresByUid.put((ManagedObjectReference)datastore.getProvider(), datastore);
            }
        }
        return this.datastoresByUid;
    }

    public DatastoreNameData getVmdkDatastoreData(int diskId) {
        VirtualDisk vDisk = this.getVirtualDisksById().get(diskId);
        if (vDisk != null && vDisk.getBacking() != null && vDisk.getBacking() instanceof VirtualDevice.FileBackingInfo) {
            VirtualDevice.FileBackingInfo vDiskFileBack = (VirtualDevice.FileBackingInfo)vDisk.getBacking();
            if (vDiskFileBack == null || vDiskFileBack.getDatastore() == null) {
                return null;
            }
            ManagedObjectReference dsRef = vDiskFileBack.getDatastore();
            return this.getDatastoresByUid().get(dsRef);
        }
        return null;
    }

    public String getVmdkName(int diskId) {
        String vmdkName = null;
        VirtualDisk vDisk = this.getVirtualDisksById().get(diskId);
        if (vDisk != null && vDisk.getDeviceInfo() != null && vDisk.getDeviceInfo().getLabel() != null) {
            vmdkName = vDisk.getDeviceInfo().getLabel();
        }
        return vmdkName;
    }
}

