/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.config.impl;

import com.vmware.vim.binding.vim.vm.ConfigInfo;
import com.vmware.vim.binding.vim.vm.VirtualNuma;
import com.vmware.vsphere.client.vm.config.impl.CpuSpec;

public class CpuSpecBuilder {
    static CpuSpec buildSpec(ConfigInfo config) {
        CpuSpec result = new CpuSpec();
        result.numCpu = config.hardware.numCPU;
        int coresPerSocket = config.hardware.numCoresPerSocket != null ? config.hardware.numCoresPerSocket : 0;
        boolean autoCoresPerSocket = Boolean.TRUE.equals(config.hardware.autoCoresPerSocket);
        result.numCoresPerSocket = autoCoresPerSocket ? 0 : coresPerSocket;
        result.simultaneousThreads = config.hardware.simultaneousThreads;
        if (config.numaInfo != null) {
            result.virtualNuma = new VirtualNuma();
            int coresPerNumaNode = config.numaInfo.coresPerNumaNode != null ? config.numaInfo.coresPerNumaNode : 0;
            boolean autoCoresPerNumaNode = Boolean.TRUE.equals(config.numaInfo.autoCoresPerNumaNode);
            result.virtualNuma.coresPerNumaNode = autoCoresPerNumaNode ? 0 : coresPerNumaNode;
        }
        return result;
    }

    static CpuSpec buildSpec(ConfigInfo originalConfig, ConfigInfo desiredConfig) {
        CpuSpec result = new CpuSpec();
        result.numCpu = originalConfig.hardware.numCPU != desiredConfig.hardware.numCPU ? new Integer(desiredConfig.hardware.numCPU) : null;
        result.numCoresPerSocket = CpuSpecBuilder.calcCoresPerSocket(originalConfig, desiredConfig);
        result.simultaneousThreads = originalConfig.hardware.simultaneousThreads != desiredConfig.hardware.simultaneousThreads ? new Integer(desiredConfig.hardware.simultaneousThreads) : null;
        result.virtualNuma = CpuSpecBuilder.calcVirtualNuma(originalConfig, desiredConfig);
        return result;
    }

    private static Integer calcCoresPerSocket(ConfigInfo originalConfig, ConfigInfo desiredConfig) {
        Integer coresPerSocket = null;
        Integer origCoresPerSocket = originalConfig.hardware.numCoresPerSocket;
        Boolean origAutoCoresPerSocket = originalConfig.hardware.autoCoresPerSocket;
        Integer desiredCoresPerSocket = desiredConfig.hardware.numCoresPerSocket;
        Boolean desiredAutoCoresPerSocket = desiredConfig.hardware.autoCoresPerSocket;
        if (desiredAutoCoresPerSocket == null) {
            boolean needChange = !Boolean.TRUE.equals(origAutoCoresPerSocket) && desiredCoresPerSocket != null && desiredCoresPerSocket.compareTo(origCoresPerSocket) != 0;
            coresPerSocket = needChange ? desiredCoresPerSocket : null;
        } else if (desiredAutoCoresPerSocket != origAutoCoresPerSocket) {
            coresPerSocket = desiredAutoCoresPerSocket != false ? new Integer(0) : desiredCoresPerSocket;
        } else if (!desiredAutoCoresPerSocket.booleanValue()) {
            coresPerSocket = desiredCoresPerSocket != null && desiredCoresPerSocket.compareTo(origCoresPerSocket) != 0 ? desiredCoresPerSocket : null;
        }
        return coresPerSocket;
    }

    private static VirtualNuma calcVirtualNuma(ConfigInfo originalConfig, ConfigInfo desiredConfig) {
        VirtualNuma vNuma = null;
        if (desiredConfig.numaInfo != null) {
            Integer origCoresPerNumaNode = originalConfig.numaInfo != null ? originalConfig.numaInfo.coresPerNumaNode : null;
            Boolean origAutoCoresPerNumaNode = originalConfig.numaInfo != null ? originalConfig.numaInfo.autoCoresPerNumaNode : null;
            Integer desiredCoresPerNumaNode = desiredConfig.numaInfo.coresPerNumaNode;
            Boolean desiredAutoCoresPerNumaNode = desiredConfig.numaInfo.autoCoresPerNumaNode;
            vNuma = new VirtualNuma();
            if (desiredAutoCoresPerNumaNode == null) {
                boolean needChange = !Boolean.TRUE.equals(origAutoCoresPerNumaNode) && desiredCoresPerNumaNode != null && desiredCoresPerNumaNode.compareTo(origCoresPerNumaNode) != 0;
                vNuma.coresPerNumaNode = needChange ? desiredCoresPerNumaNode : null;
            } else if (desiredAutoCoresPerNumaNode != origAutoCoresPerNumaNode) {
                vNuma.coresPerNumaNode = desiredAutoCoresPerNumaNode != false ? new Integer(0) : desiredCoresPerNumaNode;
            } else if (!desiredAutoCoresPerNumaNode.booleanValue()) {
                vNuma.coresPerNumaNode = desiredCoresPerNumaNode != null && desiredCoresPerNumaNode.compareTo(origCoresPerNumaNode) != 0 ? desiredCoresPerNumaNode : null;
            }
        }
        return vNuma;
    }
}

