/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.customizations.impl;

import com.vmware.vim.binding.vim.vm.customization.Password;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class VmCustomizationPasswordService {
    public String encryptPassword(byte[] key, String password) throws GeneralSecurityException, UnsupportedEncodingException {
        String encryptedPassword = "";
        if (key == null || password == null || password == "") {
            return encryptedPassword;
        }
        CertificateFactory fact = CertificateFactory.getInstance("X.509");
        X509Certificate x509crt = (X509Certificate)fact.generateCertificate(new ByteArrayInputStream(key));
        Cipher cipher = Cipher.getInstance("RSA/None/PKCS1Padding");
        cipher.init(3, x509crt.getPublicKey());
        byte[] passwordBytesWithoutBom = password.getBytes("UTF-16LE");
        SecretKeySpec passwordKey = new SecretKeySpec(passwordBytesWithoutBom, "VMW_PASSWORD");
        byte[] encryptedData = cipher.wrap(passwordKey);
        this.reverseArray(encryptedData);
        encryptedPassword = new String(Base64.encodeBase64((byte[])encryptedData));
        return encryptedPassword;
    }

    void reverseArray(byte[] array) {
        if (array == null) {
            return;
        }
        int left = 0;
        for (int right = array.length - 1; left < right; ++left, --right) {
            byte temp = array[left];
            array[left] = array[right];
            array[right] = temp;
        }
    }

    public boolean isPasswordEncryptionNeeded(Password password) {
        return password != null && !password.plainText;
    }
}

