/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.guest.auth.impl;

import com.vmware.vim.binding.vim.ServiceInstanceContent;
import com.vmware.vim.binding.vim.vm.guest.AliasManager;
import com.vmware.vim.binding.vim.vm.guest.GuestAuthentication;
import com.vmware.vim.binding.vim.vm.guest.GuestOperationsManager;
import com.vmware.vim.binding.vim.vm.guest.NamePasswordAuthentication;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.VimSessionUtil;
import com.vmware.vise.vim.commons.vcservice.VcService;
import com.vmware.vsphere.client.vm.guest.auth.GuestAuthSpec;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class VmGuestUtilities {
    private static final String DEFAULT_CHARSET = "UTF-8";

    public static AliasManager getAliasManager(ManagedObjectReference vmRef) throws Exception {
        GuestOperationsManager guestOpsMgr = VmGuestUtilities.getGuestOperationsManager(vmRef);
        ManagedObjectReference aliasMgrRef = guestOpsMgr.getAliasManager();
        AliasManager aliasMgr = (AliasManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)aliasMgrRef);
        return aliasMgr;
    }

    public static GuestOperationsManager getGuestOperationsManager(ManagedObjectReference vmRef) throws Exception {
        ServiceInstanceContent serviceContent = VmGuestUtilities.getServiceInstanceContent(vmRef);
        ManagedObjectReference guestOpsMgrRef = serviceContent.getGuestOperationsManager();
        GuestOperationsManager guestOpsMgr = (GuestOperationsManager)ManagedObjectUtil.getManagedObject((ManagedObjectReference)guestOpsMgrRef);
        return guestOpsMgr;
    }

    public static ServiceInstanceContent getServiceInstanceContent(ManagedObjectReference moRef) throws Exception {
        VcService vcService = VimSessionUtil.getService((String)moRef.getServerGuid());
        ServiceInstanceContent serviceContent = vcService.getServiceInstanceContent();
        return serviceContent;
    }

    public static GuestAuthSpec encrypt(GuestAuthSpec guestAuthSpec, ManagedObjectReference vmRef) throws Exception {
        if (guestAuthSpec.isEncrypted) {
            return guestAuthSpec;
        }
        GuestAuthSpec result = new GuestAuthSpec();
        result.guestAuth = VmGuestUtilities.applyCipher(guestAuthSpec.guestAuth, vmRef, 1);
        result.isEncrypted = true;
        return result;
    }

    public static GuestAuthSpec decrypt(GuestAuthSpec guestAuthSpec, ManagedObjectReference vmRef) throws Exception {
        if (!guestAuthSpec.isEncrypted) {
            return guestAuthSpec;
        }
        GuestAuthSpec result = new GuestAuthSpec();
        result.guestAuth = VmGuestUtilities.applyCipher(guestAuthSpec.guestAuth, vmRef, 2);
        result.isEncrypted = false;
        return result;
    }

    private static GuestAuthentication applyCipher(GuestAuthentication guestAuth, ManagedObjectReference vmRef, int mode) throws Exception {
        Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
        SecretKey key = VmGuestUtilities.generateKey(vmRef, cipher);
        cipher.init(mode, key);
        if (guestAuth instanceof NamePasswordAuthentication) {
            NamePasswordAuthentication npAuth = (NamePasswordAuthentication)guestAuth;
            if (mode == 1) {
                byte[] encryptedPass = cipher.doFinal(npAuth.password.getBytes(DEFAULT_CHARSET));
                byte[] encryptedAndEncodedPass = Base64.encodeBase64((byte[])encryptedPass);
                return new NamePasswordAuthentication(npAuth.interactiveSession, npAuth.username, new String(encryptedAndEncodedPass, DEFAULT_CHARSET));
            }
            if (mode == 2) {
                byte[] decodedButEncryptedPass = Base64.decodeBase64((byte[])npAuth.password.getBytes(DEFAULT_CHARSET));
                byte[] decryptedPass = cipher.doFinal(decodedButEncryptedPass);
                return new NamePasswordAuthentication(npAuth.interactiveSession, npAuth.username, new String(decryptedPass, DEFAULT_CHARSET));
            }
        }
        throw new Exception("Guest Authorization: Incorrect operation mode");
    }

    private static SecretKey generateKey(ManagedObjectReference vmRef, Cipher cipher) throws UnsupportedEncodingException {
        VcService vcService = VimSessionUtil.getService((String)vmRef.getServerGuid());
        byte[] token = vcService.getConnectionInfo().getSessionCookie().getBytes(DEFAULT_CHARSET);
        token = Arrays.copyOfRange(token, 0, cipher.getBlockSize());
        return new SecretKeySpec(token, "AES");
    }
}

