/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.issue.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.vm.ConfigOptionDescriptor;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.monitor.IssueInfo;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.QuerySpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vsphere.client.issue.impl.IssueAdapterBase;
import com.vmware.vsphere.client.vm.issue.impl.VmToolsIssueAdapter;
import com.vmware.vsphere.client.vm.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@type(value="Issue,VmCompatibilityIssue")
public class VmCompatibilityIssueAdapter
extends IssueAdapterBase {
    private static final String VM_COMPATIBILITY_ISSUE_TYPE = "VmCompatibilityIssue";
    private static final String VM_NAME_PROPERTY = "name";
    private static final String VERSION_PROPERTY = "config.version";
    private static final String ENV_BROWSER_PROPERTY = "environmentBrowser";
    private static final String CONFIG_OPTION_DESCRIPTORS_PROPERTY = "optionDescriptors";
    private static final Log _logger = LogFactory.getLog(VmToolsIssueAdapter.class);
    private DataService _dataService;

    public VmCompatibilityIssueAdapter(DataService dataService) {
        super(VM_COMPATIBILITY_ISSUE_TYPE);
        this._dataService = dataService;
    }

    protected IssueAdapterBase.IssueData[] getIssues(QuerySpec querySpec, IssueAdapterBase.RequestContext context) {
        Object entity = this.extractEntityFromQuerySpec(querySpec);
        if (!(entity instanceof ManagedObjectReference) || !ManagedObjectUtil.isOfType((ManagedObjectReference)((ManagedObjectReference)entity), VirtualMachine.class)) {
            return new IssueAdapterBase.IssueData[0];
        }
        String vmName = null;
        String currentHwVersion = null;
        ManagedObjectReference envBrowser = null;
        ConfigOptionDescriptor[] descriptors = null;
        try {
            PropertyValue[] propertyValues;
            for (PropertyValue propertyValue : propertyValues = QueryUtil.getProperties((DataService)this._dataService, (Object)entity, (String[])new String[]{VM_NAME_PROPERTY, VERSION_PROPERTY, ENV_BROWSER_PROPERTY})) {
                if (VM_NAME_PROPERTY.equals(propertyValue.propertyName)) {
                    vmName = (String)propertyValue.value;
                    continue;
                }
                if (VERSION_PROPERTY.equals(propertyValue.propertyName)) {
                    currentHwVersion = (String)propertyValue.value;
                    continue;
                }
                if (!ENV_BROWSER_PROPERTY.equals(propertyValue.propertyName)) continue;
                envBrowser = (ManagedObjectReference)propertyValue.value;
            }
            if (vmName == null) {
                _logger.warn((Object)String.format("Cound not retrieve VM name for %s", entity.toString()));
            }
            if (currentHwVersion == null) {
                _logger.warn((Object)String.format("Cound not retrieve hw version for %s", entity.toString()));
                return new IssueAdapterBase.IssueData[0];
            }
            if (envBrowser == null) {
                _logger.warn((Object)String.format("Cound not retrieve environment browser for %s", entity.toString()));
                return new IssueAdapterBase.IssueData[0];
            }
            propertyValues = QueryUtil.getProperties((DataService)this._dataService, envBrowser, (String[])new String[]{CONFIG_OPTION_DESCRIPTORS_PROPERTY});
            if (propertyValues == null || propertyValues.length == 0) {
                _logger.warn((Object)String.format("Cound not retrieve config option descriptors for %s", entity.toString()));
                return new IssueAdapterBase.IssueData[0];
            }
            descriptors = (ConfigOptionDescriptor[])propertyValues[0].value;
        }
        catch (Exception e) {
            _logger.error((Object)String.format("Error retrieving VM properties for %s", entity.toString()), (Throwable)e);
            throw new RuntimeException(e);
        }
        boolean isRunSupported = true;
        boolean isUpgradeSupported = true;
        for (ConfigOptionDescriptor descriptor : descriptors) {
            if (!currentHwVersion.equals(descriptor.key)) continue;
            isRunSupported = descriptor.runSupported == null ? true : descriptor.runSupported;
            isUpgradeSupported = descriptor.upgradeSupported == null ? true : descriptor.upgradeSupported;
            break;
        }
        if (isRunSupported) {
            return new IssueAdapterBase.IssueData[0];
        }
        String description = Util.getLocalizedString("issue.vmCompatibility");
        IssueInfo issueInfo = new IssueInfo();
        issueInfo.typeDisplayName = Util.getLocalizedString("issue.vmCompatibility.displayName");
        issueInfo.description = description;
        issueInfo.entity = entity;
        issueInfo.entityName = vmName;
        issueInfo.details = isUpgradeSupported;
        IssueAdapterBase.IssueData issueData = new IssueAdapterBase.IssueData();
        issueData.key = entity.toString();
        issueData.issueInfo = issueInfo;
        return new IssueAdapterBase.IssueData[]{issueData};
    }
}

