/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.migration.impl;

import com.vmware.vim.binding.vim.vm.check.Result;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.ValidationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.internal.PropertyProviderBean;
import com.vmware.vise.data.query.type;
import com.vmware.vsphere.client.vm.VmCloneSpec;
import com.vmware.vsphere.client.vm.impl.VmMutationProvider;
import com.vmware.vsphere.client.vm.migration.LocationSpecPair;
import com.vmware.vsphere.client.vm.migration.VmMigrationService;
import java.util.ArrayList;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmMigrationPropertyProvider
implements PropertyProviderBean {
    private static final Log LOGGER = LogFactory.getLog(VmMigrationPropertyProvider.class);
    private static final ManagedObjectReference[] EMPTY_ENTITY_ARRAY = new ManagedObjectReference[0];
    private final VmMigrationService _migrationService;
    private final VmMutationProvider _vmMutationProvider;

    public VmMigrationPropertyProvider(VmMigrationService migrationService, MutationProvider vmMutationProvider) {
        this._migrationService = migrationService;
        this._vmMutationProvider = (VmMutationProvider)vmMutationProvider;
    }

    @type(value="ClusterComputeResource,ResourcePool,VirtualApp")
    public ManagedObjectReference[] getValidDestinationHosts(ManagedObjectReference resourceRef, Object spec) {
        ManagedObjectReference[] result = EMPTY_ENTITY_ARRAY;
        ValidationResult compatCheckResult = null;
        if (spec instanceof VmCloneSpec) {
            VmCloneSpec vmCloneSpec = (VmCloneSpec)spec;
            try {
                compatCheckResult = this._vmMutationProvider.validate(vmCloneSpec.vm, vmCloneSpec);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Cannot retrieve valid destination hosts for cloning!", (Throwable)ex);
            }
        } else if (spec instanceof LocationSpecPair) {
            LocationSpecPair locationSpecPair = (LocationSpecPair)spec;
            try {
                compatCheckResult = this._migrationService.validate(locationSpecPair.entity, locationSpecPair.spec);
            }
            catch (Exception ex) {
                LOGGER.error((Object)"Cannot retrieve valid destination hosts for migration!", (Throwable)ex);
            }
        }
        result = VmMigrationPropertyProvider.getCompatibleHosts(compatCheckResult);
        return result;
    }

    private static final ManagedObjectReference[] getCompatibleHosts(ValidationResult compatCheckResult) {
        Result[] allResultsForVm;
        if (compatCheckResult == null || compatCheckResult.error != null || !(compatCheckResult.result instanceof Result[])) {
            LOGGER.warn((Object)"Empty or invalid VM compatibility check results retrieved!");
            return EMPTY_ENTITY_ARRAY;
        }
        ArrayList<ManagedObjectReference> compatibleHosts = new ArrayList<ManagedObjectReference>();
        for (Result result : allResultsForVm = (Result[])compatCheckResult.result) {
            if (!ArrayUtils.isEmpty((Object[])result.error) || result.host == null) continue;
            compatibleHosts.add(result.host);
        }
        if (CollectionUtils.isEmpty(compatibleHosts)) {
            LOGGER.warn((Object)"No compatible hosts found.");
            return EMPTY_ENTITY_ARRAY;
        }
        return compatibleHosts.toArray(new ManagedObjectReference[compatibleHosts.size()]);
    }
}

