/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vsphere.client.vm.snapshot.impl;

import com.vmware.vim.binding.vim.VirtualMachine;
import com.vmware.vim.binding.vim.fault.InvalidState;
import com.vmware.vim.binding.vim.scheduler.ScheduledTaskSpec;
import com.vmware.vim.binding.vim.vm.Snapshot;
import com.vmware.vim.binding.vim.vm.SnapshotInfo;
import com.vmware.vim.binding.vim.vm.SnapshotTree;
import com.vmware.vim.binding.vmodl.ManagedObject;
import com.vmware.vim.binding.vmodl.ManagedObjectReference;
import com.vmware.vise.core.model.mutation.OperationResult;
import com.vmware.vise.data.mutation.MutationProvider;
import com.vmware.vise.data.query.DataService;
import com.vmware.vise.data.query.util.QueryUtil;
import com.vmware.vise.vim.commons.ManagedObjectUtil;
import com.vmware.vise.vim.commons.MixedUtil;
import com.vmware.vsphere.client.common.util.SchedulingUtil;
import com.vmware.vsphere.client.vm.snapshot.VmSnapshotConsolidateSpec;
import com.vmware.vsphere.client.vm.snapshot.VmSnapshotEditSpec;
import com.vmware.vsphere.client.vm.snapshot.VmSnapshotRemovalSpec;
import com.vmware.vsphere.client.vm.snapshot.VmSnapshotRemoveAllSpec;
import com.vmware.vsphere.client.vm.snapshot.VmSnapshotRevertSpec;
import com.vmware.vsphere.client.vm.snapshot.VmSnapshotSpec;
import com.vmware.vsphere.client.vm.util.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VmSnapshotMutationProvider
implements MutationProvider {
    private static String PROPERTY_SNAPSHOT_LOCKED = "config.flags.snapshotLocked";
    private static final String SNAPSHOT_PROPERTY_NAME = "snapshot";
    private static final Log _logger = LogFactory.getLog(VmSnapshotMutationProvider.class);
    private DataService _dataService;

    public VmSnapshotMutationProvider(DataService dataService) {
        this._dataService = dataService;
    }

    public OperationResult[] addMulti(VmSnapshotSpec[] snapshotSpecs) {
        int snapshotsCount = snapshotSpecs.length;
        OperationResult[] results = new OperationResult[snapshotsCount];
        for (int i = 0; i < snapshotsCount; ++i) {
            VmSnapshotSpec vmSnapshotSpec = snapshotSpecs[i];
            OperationResult result = new OperationResult();
            result.entity = vmSnapshotSpec.vm;
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmSnapshotSpec.vm);
                result.task = vm.createSnapshot(vmSnapshotSpec.name, vmSnapshotSpec.description, vmSnapshotSpec.memory, vmSnapshotSpec.quiesce);
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    public OperationResult addDeferred(VmSnapshotSpec snapshotSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        OperationResult result = new OperationResult();
        try {
            ManagedObjectReference entity = null;
            entity = scheduleSpec.scheduledTask != null ? this.addDeferredExisting(snapshotSpec, scheduleSpec) : this.addDeferredNew(snapshotSpec, scheduleSpec);
            result.entity = entity;
        }
        catch (Exception e) {
            _logger.error((Object)e);
            result.error = MixedUtil.getMethodFault((Throwable)e);
        }
        return result;
    }

    private ManagedObjectReference addDeferredExisting(VmSnapshotSpec snapshotSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createScheduledVcTaskSpec(snapshotSpec, scheduleSpec);
        return SchedulingUtil.updateVcScheduledTask((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec, (ScheduledTaskSpec)vcTaskSpec);
    }

    private ManagedObjectReference addDeferredNew(VmSnapshotSpec snapshotSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) throws Exception {
        ScheduledTaskSpec vcTaskSpec = this.createScheduledVcTaskSpec(snapshotSpec, scheduleSpec);
        return SchedulingUtil.createVcScheduledTask((DataService)this._dataService, (ManagedObjectReference)snapshotSpec.vm, (ScheduledTaskSpec)vcTaskSpec);
    }

    public OperationResult remove(ManagedObjectReference moRef, VmSnapshotRemovalSpec spec) {
        OperationResult result = new OperationResult();
        try {
            Snapshot snapshot = (Snapshot)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
            if (this.isSnapshotLocked(moRef)) {
                InvalidState error = new InvalidState();
                String message = Util.getLocalizedString("error.SnapshotService.SnapshotLocked");
                error.setMessage(message);
                throw error;
            }
            result.task = snapshot.remove(spec.removeChildren, spec.consolidate);
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult[] removeOnMultiEntity(ManagedObjectReference[] entities, VmSnapshotRemoveAllSpec removeAllSpec) {
        int entitiesCount = entities.length;
        OperationResult[] results = new OperationResult[entitiesCount];
        for (int i = 0; i < entitiesCount; ++i) {
            ManagedObjectReference vmMoRef = entities[i];
            OperationResult result = new OperationResult();
            result.entity = vmMoRef;
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmMoRef);
                result.task = vm.removeAllSnapshots(null);
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    public OperationResult apply(ManagedObjectReference moRef, VmSnapshotEditSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = spec.vm;
        try {
            SnapshotInfo propValue = (SnapshotInfo)QueryUtil.getProperty((DataService)this._dataService, (Object)spec.vm, (String)SNAPSHOT_PROPERTY_NAME);
            SnapshotTree oldSnapshot = this.getSnapshotTree(propValue, moRef);
            Snapshot snapshot = (Snapshot)ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
            snapshot.rename(spec.name, spec.description);
            QueryUtil.waitUntilPropertyChanged((DataService)this._dataService, (Object)spec.vm, (QueryUtil.PropertyChangeInfo)new SnapshotChangeInfo(oldSnapshot.name, oldSnapshot.description, moRef));
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    private ScheduledTaskSpec createScheduledVcTaskSpec(VmSnapshotSpec snapshotSpec, com.vmware.vise.core.model.scheduling.ScheduledTaskSpec scheduleSpec) {
        ScheduledTaskSpec vcTaskSpec = SchedulingUtil.newVcScheduledTaskSpec((com.vmware.vise.core.model.scheduling.ScheduledTaskSpec)scheduleSpec);
        vcTaskSpec.action = SchedulingUtil.newMethodAction((String)"CreateSnapshot_Task", (Object[])new Object[]{snapshotSpec.name, snapshotSpec.description, snapshotSpec.memory, snapshotSpec.quiesce});
        return vcTaskSpec;
    }

    private SnapshotTree getSnapshotTree(SnapshotInfo info, ManagedObjectReference snapshotMoRef) {
        ArrayList<SnapshotTree> trees = new ArrayList<SnapshotTree>();
        VmSnapshotMutationProvider.addNodesToList(info.rootSnapshotList, trees);
        for (int i = 0; i < trees.size(); ++i) {
            if (((SnapshotTree)trees.get((int)i)).snapshot.equals((Object)snapshotMoRef)) {
                return (SnapshotTree)trees.get(i);
            }
            VmSnapshotMutationProvider.addNodesToList(((SnapshotTree)trees.get((int)i)).childSnapshotList, trees);
        }
        return null;
    }

    private static void addNodesToList(SnapshotTree[] nodes, List<SnapshotTree> list) {
        if (!ArrayUtils.isEmpty((Object[])nodes)) {
            list.addAll(Arrays.asList(nodes));
        }
    }

    public OperationResult apply(ManagedObjectReference moRef, VmSnapshotRevertSpec spec) {
        OperationResult result = new OperationResult();
        result.entity = moRef;
        try {
            ManagedObject mo = ManagedObjectUtil.getManagedObject((ManagedObjectReference)moRef);
            if (mo instanceof Snapshot) {
                Snapshot snapshot = (Snapshot)mo;
                result.task = snapshot.revert(spec.host, Boolean.valueOf(spec.suppressPowerOn));
            } else if (mo instanceof VirtualMachine) {
                VirtualMachine vm = (VirtualMachine)mo;
                result.task = vm.revertToCurrentSnapshot(spec.host, Boolean.valueOf(spec.suppressPowerOn));
            }
        }
        catch (Exception ex) {
            _logger.error((Object)ex);
            result.error = MixedUtil.getMethodFault((Throwable)ex);
        }
        return result;
    }

    public OperationResult[] applyOnMultiEntity(ManagedObjectReference[] entities, VmSnapshotConsolidateSpec consolidateSpec) {
        int entitiesCount = entities.length;
        OperationResult[] results = new OperationResult[entitiesCount];
        for (int i = 0; i < entitiesCount; ++i) {
            ManagedObjectReference vmMoRef = entities[i];
            OperationResult result = new OperationResult();
            result.entity = vmMoRef;
            results[i] = result;
            try {
                VirtualMachine vm = (VirtualMachine)ManagedObjectUtil.getManagedObject((ManagedObjectReference)vmMoRef);
                result.task = vm.consolidateDisks();
                continue;
            }
            catch (Exception ex) {
                _logger.error((Object)ex);
                result.error = MixedUtil.getMethodFault((Throwable)ex);
            }
        }
        return results;
    }

    private boolean isSnapshotLocked(ManagedObjectReference snapshot) throws Exception {
        Object result = QueryUtil.getProperty((DataService)this._dataService, (Object)snapshot, (String)PROPERTY_SNAPSHOT_LOCKED);
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return false;
    }

    private class SnapshotChangeInfo
    implements QueryUtil.PropertyChangeInfo {
        private String _oldName;
        private String _oldDescription;
        private ManagedObjectReference _snapshot;

        public SnapshotChangeInfo(String oldName, String oldDescription, ManagedObjectReference snapshot) {
            this._oldName = oldName;
            this._oldDescription = oldDescription;
            this._snapshot = snapshot;
        }

        public String getPropertyName() {
            return VmSnapshotMutationProvider.SNAPSHOT_PROPERTY_NAME;
        }

        public boolean isChanged(Object newValue) {
            SnapshotTree treeNode = VmSnapshotMutationProvider.this.getSnapshotTree((SnapshotInfo)newValue, this._snapshot);
            return !this._oldName.equals(treeNode.name) || !this._oldDescription.equals(treeNode.description);
        }
    }
}

